<?php

//include_once("Container.class.php");
//include_once("../phpsrc/command/CmdGetEventMaxNo.class.php");

class Evt
{
	public $Class;
	public $Code;
	public $Severity;
	public $AdapterID;
	public $SeverityImg;
	public $SeverityTitle;
	public $Date;
	public $Log;

	public function setEvt($Event)
	{
		$this->Class = $Event->getClass();
		$this->Code = $Event->getCode();
		$this->Severity = $Event->getSeverity();
		$this->AdapterID = $Event->getAdapterID();
		$this->Date = $Event->getTime();
		$this->Log = $Event->getEvtLog();
		
		$this->SeverityImg = EventSeverity::getSeverityImg($Event->getSeverity());
		$this->SeverityTitle = EventSeverity::getSeverityTitle($Event->getSeverity());
		$this->SeverityTitle = gettext($this->SeverityTitle);
	}
	
	public function convertWords()
	{
		$this->Log = htmlspecialchars($this->Log,ENT_QUOTES);
		
		//need to convert time.
		$classInt = $this->Class;
		$this->Class = EventClass::getEventClassStr($this->Class);
		if($this->Class == EventClass::EVT_CLASS_UNKNOWN)
		{
			$this->Class = gettext($this->Class) . "(" . $classInt . ")";
		}
		else
		{ 
			$this->Class = gettext($this->Class);
		}
	}
	
}

class CtnEventList extends Container
{
	const default_len = 20;
	private $StartNo;
	private $EventNum;
	private $EventMaxNum;
	
	protected function setBase()
	{
		$this->base = new EventList();
		
		$this->base->setStartNo($this->StartNo);
		
		if (!$this->EventNum) {
			$this->base->setEventNum(self::default_len);
		}
		else 
		{
			$this->base->setEventNum($this->EventNum);
		}
	}
	
	public function setStartNo($startNo)
	{
		$this->StartNo = $startNo;
	}
	
	public function getStartNo()
	{
		return $this->StartNo;
	}
	
	public function setEventNum($EventNum)
	{
		$this->EventNum = $EventNum;
	}
	
	protected function setDataToPage()
	{
		$EventList = array();
		$bases = $this->base->getBaseClasses();
		foreach ($bases as $Event)
		{
			$evt = new Evt();
			$evt->setEvt($Event);
			$evt->convertWords();
			
			$EventList[] = $evt;
		}
		//display xml
		
		$EventList = array_reverse($EventList);
		$this->StartNo = $this->base->getStartNo();
		$this->EventNum = sizeof($EventList);
		$this->EventMaxNum = $this->base->getEventMaxNum();
		if ($EventList) {
			$StartID = $this->StartNo + 1;
			$EndID = $this->StartNo + $this->EventNum;
			if ($EndID > $this->EventMaxNum) {
				$EndID = $this->EventMaxNum;
			}
			$this->smarty->assign("EventMaxNum",$this->EventMaxNum);
		}
		else {
			$StartID = 0;
			$EndID = 0;
			$this->EventMaxNum = 0;
		}
		$this->setInfo($EventList);
		$this->smarty->assign("EventList",$EventList);
		$this->smarty->assign("StartID",$StartID);
		$this->smarty->assign("EndID", $EndID);
		$this->smarty->assign("EventMaxNum",$this->EventMaxNum);
		
	}	
	public function displayXML()
	{
		$this->display("XML_EventList.tpl");
	}
}

class CtnAllEventList
{
	const EVENTLIST_MAX_NUM = 100; //the XML doc buffer of zraidapi can contain 100 Events xml Elements 
	
	private $allEvents = array();
	private $startNo = 0;
	
	public function getAllEvents()
	{
		return $this->allEvents;
	}
	
	public function setStartNo($startNo)
	{
		$this->startNo = $startNo;
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	protected function initBases()
	{	
		$this->base = array();
		$endNo = EventList::GetEventEndNo();		
		$startNo = $this->startNo;
		
		while($startNo < $endNo + 1)
		{
			$evtList = new EventList();
			$evtList->setStartNo($startNo);
			
			if ($startNo + self::EVENTLIST_MAX_NUM > $endNo) 
			{
				$evtList->setEventNum($endNo - $startNo + 1);
			}
			else 
			{
				$evtList->setEventNum(self::EVENTLIST_MAX_NUM);
			}
			
			$this->base[] = $evtList;
			$startNo += self::EVENTLIST_MAX_NUM;
		}
	}
	
	private function setDataFromBase()
	{
		$this->allEvents = array();
		foreach ($this->base as $evtList)
		{
			$events = array();
			$bases = $evtList->getBaseClasses();
			foreach ($bases as $Event)
			{
				$evt = new Evt();
				$evt->setEvt($Event);
				$evt->convertWords();
				
				$events[] = $evt;
			}
			$this->allEvents = array_merge($this->allEvents,$events);
		}
		$this->allEvents = array_reverse($this->allEvents);
	}
	
	protected function saveDataToPage()
	{
		$this->smarty->assign("EventList",$this->allEvents);
	}
	
	public function initData()
	{
		$this->initBases();
		foreach ($this->base as $evtList)
		{
			$evtList->initData();
		}
		$this->setDataFromBase();
	}
		
	//over ride the base class' initContainer() method
	public function initContainer()
	{
		$this->initBases();
		foreach ($this->base as $evtList)
		{
			$evtList->initData();
		}
		$this->setDataFromBase();
		$this->saveDataToPage();
	}
	
	protected function displayXML()
	{
		$this->smarty->display("EventsSaveFilePage.tpl");
	}
	
	public function display($tplName)
	{
		$this->smarty->display($tplName);
	}
}

?>