<?php
class PgAcceleratorScheduleDisplayer extends PageDisplayer
{
	protected function initPage()
	{
		$smarty = $this->smarty;
		$type = getRequestPara('type');
		
		//delete operation
		if ($type == 'delete') {
			$selectedJobIDs = getRequestPara('selectedJobIDs');
			//do delete
			if (trim($selectedJobIDs)) {
				$selectedJobIDs = trim($selectedJobIDs);
				$idArr = explode(' ',$selectedJobIDs);
				$DA = new BGAJobDataAccess();
				foreach ($idArr as $id)
				{
					$DA->deleteBGAJobByID($id);
				}
			}
			$this->jumptoPage('Target=AcceleratorSchedule');
		} //add new
		else if ($type == 'bgaSave') {
			$jobs = new CtnAcceleratorJobList();
			$jobs->smartyAssign($smarty);
			$jobs->initContainer();
			
			//tmp for the issue that refresh the page will add more schedule
			if ($jobs->getJobListSize() == 0)
				$this->addBGAJob();
		} //modify
		else if ($type == 'saveModify') {
			//submit from bga save page
			$JobID = getRequestPara('jobID');
			if ($JobID) {				
				$da = new BGAJobDataAccess();
				$modifyJob = $da->getBGAJobByID($JobID);
				if ($modifyJob) {
					$status = $modifyJob->getStatus();
					$settingType = $modifyJob->getSettingType();
					if( $status != ScheduleStatus::NOT_RUN && ScheduleSettingType::No_REPEAT == $settingType)
					{
						$this->jumptoPage('Target=AcceleratorSchedule&CanNotModify=1');
					}else {
						//will only modify bga type
						$this->modifyBGAJob();
					}
				}
			}
		}
		
		if (getRequestPara('CanNotModify') != null) {
			$smarty->assign("CanNotModify",1);
		}
		
		$jobs = new CtnAcceleratorJobList();
		$jobs->smartyAssign($smarty);
		$jobs->initContainer();
		
                $smarty->assign("jobFound",($jobs->getJobListSize() > 0));

                $volList = new CtnAccelerateVolumeList();
                $volList->smartyAssign($smarty);
                $volList->initContainer();
                $vols = $volList->getInfos();
                if (sizeof($vols) == 0) {
                    $smarty->assign("noValidVolume", 1);
                }
		
		$this->setPageName("XML_Accelerator_Schedule.tpl");
	}
	
	private function addBGAJob()
	{
		$settingType = getRequestPara('settingType');
		$settingTime = trim(getRequestPara('settingTime'));
		$settingTime = substr($settingTime,0,2) . substr($settingTime,3,2);
		//only once
		if ($settingType == ScheduleSettingType::No_REPEAT) {
			$settingDate = getRequestPara('settingDate1');
			$month = substr($settingDate,0,2);
			$day = substr($settingDate,3,2);
			$year = substr($settingDate,6,4);
			$settingDate = date('Ymd',mktime(0,0,0,$month,$day,$year));
			$settingDateSupplement = 0;
		}
		else if ($settingType == ScheduleSettingType::DAY_REPEAT) {
			$settingDate = getRequestPara('settingDate2');
			$settingDateSupplement = getRequestPara('settingDateSupplement2');
		}
		else if ($settingType == ScheduleSettingType::WEEK_REPEAT) {
			$settingDate = getRequestPara('settingDate3');
			$settingDateSupplement = getRequestPara('settingDateSupplement3');
		}
		else if ($settingType == ScheduleSettingType::MONTH_REPEAT) {
			$settingDate = getRequestPara('settingDate4');
			$settingDateSupplement = getRequestPara('settingDateSupplement4');
		}
		
		$now = getNow();
		$nowTime = strtotime($now);
		$startTime = date('YmdHi',$nowTime);
		$status = ScheduleStatus::NOT_RUN;
		$result = '0';
		$resultText = 'Not Run';
		
		$job = new BGAJob();
		
		$job->setBgaType(ScheduledBGAType::ACCELERATOR_AUTO );
		
		$job->setSettingType($settingType);
		$job->setSettingTime($settingTime);
		$job->setSettingDate($settingDate);
		$job->setSettingDateSupplement($settingDateSupplement);
		
		$job->setStartTime($startTime);
		$job->setStatus($status);
		$job->setResult($result);
		$job->setResultText($resultText);
		
		$DA = new BGAJobDataAccess();
		$JobID = $DA->addJob($job);
	}
	
	private function modifyBGAJob()
	{
		$JobID = getRequestPara('jobID');
		
		$settingType = getRequestPara('settingType');
		$settingTime = trim(getRequestPara('settingTime'));
		
		$job = new BGAJob();
		
		if($settingType != '' && $settingTime != '')
		{
			$settingTime = substr($settingTime,0,2) . substr($settingTime,3,2);
			//only once
			if ($settingType == ScheduleSettingType::No_REPEAT) {
				$settingDate = getRequestPara('settingDate1');
				$month = substr($settingDate,0,2);
				$day = substr($settingDate,3,2);
				$year = substr($settingDate,6,4);
				$settingDate = date('Ymd',mktime(0,0,0,$month,$day,$year));
				$settingDateSupplement = 0;
			}
			else if ($settingType == ScheduleSettingType::DAY_REPEAT) {
				$settingDate = getRequestPara('settingDate2');
				$settingDateSupplement = getRequestPara('settingDateSupplement2');
			}
			else if ($settingType == ScheduleSettingType::WEEK_REPEAT) {
				$settingDate = getRequestPara('settingDate3');
				$settingDateSupplement = getRequestPara('settingDateSupplement3');
			}
			else if ($settingType == ScheduleSettingType::MONTH_REPEAT) {
				$settingDate = getRequestPara('settingDate4');
				$settingDateSupplement = getRequestPara('settingDateSupplement4');
			}
			$job->setSettingType($settingType);
			$job->setSettingTime($settingTime);
			$job->setSettingDate($settingDate);
			$job->setSettingDateSupplement($settingDateSupplement);
		}
		
		$job->setBgaType(ScheduledBGAType::ACCELERATOR_AUTO);
		
		$DA = new BGAJobDataAccess();
		$JobID = $DA->updateBGAJobByID($JobID,$job);
	}
}

?>