--
-- The function will be executed before main screen starting.
--
function BeforeStarted (arg)
  if arg[1] == "saveacpi" then
    local FileName = "ACPI.txt"
    local AcpiTable = platform.AcpiTableEnumerate ()
    local lines = {}
    local f, ErrMsg = io.open (FileName, "wt")
    if f == nil then
      print("Failed to create file: "..FileName)
      return "exit"
    end
    local function AddLine (Line)
      f:write (Line.."\n")
    end
    for i, entry in ipairs (AcpiTable) do
      lines[#lines + 1] = string.format ("[%s]", entry.signature)
      lines[#lines + 1] = string.format ("Addr: %08x:%08xh", entry.address.msb, entry.address.lsb)
      local Stream = bitstream.Create (entry.data)
      if AcpiSpec[entry.signature] ~= nil then
        ProcessAcpiSpecTable (AcpiSpec, entry.signature, Stream, AddLine)
      else
        ProcessAcpiSpecTable (AcpiSpec, "DEFAULT", Stream, AddLine)
      end
      lines[#lines + 1] = ""
    end
    f:close ()
    print ("ACPI.txt is saved.")
    return "exit"
  end
  return true
end

--
-- The function will be executed after main screen started.
--
function AfterStarted ()
  local Param = {}
  
  --[[
  --
  -- ACPI table viewer.
  --
  Param.Signature = "AAFT"
  CreateAcpiView (nil, Param.Signature)
  --]]

  --[[
  --
  -- CMOS monitor.
  --
  Param.RefreshCycle = 1
  Param.Monitoring = true

  CreateCmosMonitorView (nil, Param.RefreshCycle, Param.Monitoring)
  --]]

  --[[
  --
  -- CPU MSR edit.
  --
  Param.CpuCoreIndex = 0
  Param.MsrIndex = 0x10
  Param.Load = true

  CreateCpuMsrDialog (nil, Param.CpuCoreIndex, Param.MsrIndex, Param.Load)
  --]]

  --[[
  --
  -- UEFI Variable edit.
  --
  Param.VariableName = "SETUP"

  CreateEfiVarEditView (nil, Param.VariableName)
  --]]

  --[[
  --
  -- Indexed I/O monitor.
  --
  Param.IndexPort = 0x70
  Param.DataPort = 0x71
  Param.Unit = "BYTE"
  Param.IndexStart = 0
  Param.IndexStop = 0x7f
  Param.RefreshCycle = 1
  Param.Monitoring = false

  CreateIndexIoMonitorView (nil, Param.IndexPort, Param.DataPort, Param.Unit, Param.IndexStart, Param.IndexStop, Param.RefreshCycle, Param.Monitoring)
  --]]

  --[[
  --
  -- I/O monitor.
  --
  Param.StartPort = 0x20
  Param.StopPort = 0x8f
  Param.Unit = "BYTE"
  Param.RefreshCycle = 1
  Param.Monitoring = true

  CreateIoMonitorView (nil, Param.StartPort, Param.StopPort, Param.Unit, Param.RefreshCycle, Param.Monitoring)
  --]]

  --[[
  --
  -- Memory monitor.
  --
  Param.StartAddr = 0xF0000
  Param.Length = 0x10000
  Param.Unit = "BYTE"
  Param.Load = true

  CreateMemoryEditView (nil, Param.StartAddr, Param.Length, Param.Unit, Param.Load)
  --]]

  --[[
  --
  -- PCI monitor.
  --
  Param.DeviceID = "00:01:0"
  Param.RefreshCycle = 1
  Param.Unit = "WORD"
  Param.Monitoring = true
  Param.RangeStart = 0x10
  Param.RangeStop = 0xaf
  Param.ReloadAfterUpdated = true

  CreatePciMonitorView (nil, Param.DeviceID , Param.RefreshCycle, Param.Unit, Param.Monitoring, Param.RangeStart, Param.RangeStop, Param.ReloadAfterUpdated)
  --]]

  --[[
  --
  -- Performance Log View.
  --
  Param.TableName = "BDPT"

  CreateBiosPerformanceLogView (nil, Param.TableName)
  --]]

  --[[
  --
  -- SMBIOS View.
  --
  Param.Type = 5

  CreateSmBiosView (nil, Param.Type)
  --]]
end

--
-- CPU MSR read filter.
--
function CpuMsrGetFilter (CpuCoreIndex, RegisterIndex)
  local AccessRight = false
  local MessageIfDenied = "All access are denied!"
  return AccessRight, MessageIfDenied
end

--
-- CPU MSR set filter.
--
function CpuMsrSetFilter (CpuCoreIndex, RegisterIndex, ValueMsb, ValueLsb)
  local AccessRight = false
  local MessageIfDenied = "All access are denied!"
  return AccessRight, MessageIfDenied
end

---
--- Index I/O Access filter
---
function IndexIOAccessFilter (Action, Index, Value)
  --
  -- To avoid super I/O lock
  --
  if (Action == "READ") or (Action == "WRITE") then
    if Index == 0xAA then
      return false
    end
  end
  return true
end

--
-- Super I/O unlock
--
function SuperIOUnlock ()
  --
  -- Write 0x87 twice to 0x2e port to unlock Winbond W83627H.
  --
  platform.Outp8 (0x2e, 0x87)
  platform.Outp8 (0x2e, 0x87)
end

--
-- Super I/O Lock
--
function SuperIOLock ()
  --
  -- Write 0xaa to 0x2e port to lock Winbond W83627H.
  --
  platform.Outp8 (0x2e, 0xAA)
end
