/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.ObservableModel;
import java.io.File;

public abstract class AbstractEntity
extends ObservableModel {
    @JsonIgnore
    private String jsonFilePath;

    public AbstractEntity() {
    }

    public AbstractEntity(String jsonFilePath) {
        this.jsonFilePath = jsonFilePath;
    }

    @JsonIgnore
    public String getJsonFilePath() {
        return this.jsonFilePath;
    }

    @JsonIgnore
    public void setJsonFilePath(String jsonFilePath) {
        this.jsonFilePath = jsonFilePath;
    }

    @JsonIgnore
    public File getAbsoluteParentFolder() {
        return new File(this.jsonFilePath).getParentFile();
    }

    @JsonIgnore
    public String getAbsoluteParentFolderAsStr() {
        String folderPath = "";
        try {
            folderPath = this.getAbsoluteParentFolder().getCanonicalPath();
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
            ExceptionHandler.HandleException((Exception)e);
        }
        return folderPath;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractEntity)) {
            return false;
        }
        AbstractEntity that = (AbstractEntity)o;
        String thisJsonFilePath = new File(this.getJsonFilePath()).getAbsolutePath();
        String thatJsonFilePath = new File(that.getJsonFilePath()).getAbsolutePath();
        return thisJsonFilePath.contentEquals(thatJsonFilePath);
    }
}

