/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.BusInfo;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.payloads.configurations.EcConfigurationPayload;

public class EcConfiguration
implements ConfigurationEditor {
    private EcConfigurationPayload _payload = null;
    private Sensor _sensor = null;
    protected Shell shlEc;
    private Display display;
    private SensorModifier _parent;
    private InformationStore infoStore = null;
    private BusInfo _busInfo;
    private Combo cboInputReporter;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };

    public EcConfiguration(SensorModifier parent, EcConfigurationPayload payload, Sensor sensor) {
        this._payload = payload;
        this._sensor = sensor;
        this._parent = parent;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlEc, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.createContents();
        this.fillData();
        this.shlEc.open();
        this.shlEc.layout();
        while (!this.shlEc.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        this._busInfo.copyBusInfo(this._parent.getBusInfo());
        if (this._payload != null) {
            if (this._payload.getSensorType() == 769) {
                this.cboInputReporter.select(0);
            } else if (this._payload.getSensorType() == 768) {
                this.cboInputReporter.select(1);
            } else if (this._payload.getSensorType() == 777) {
                this.cboInputReporter.select(2);
            } else if (this._payload.getSensorType() == 774) {
                this.cboInputReporter.select(3);
            }
        }
        this._properties.setModified(false);
    }

    public void saveData() {
        EcConfigurationPayload payload = this._payload;
        boolean newConfiguration = false;
        if (payload == null) {
            payload = new EcConfigurationPayload();
            newConfiguration = true;
        }
        if (this.cboInputReporter.getSelectionIndex() == -1) {
            MessageBox messageBox = new MessageBox(this.shlEc, 513);
            messageBox.setText("Invalid Input Reporter");
            messageBox.setMessage("You must select an input reporter.");
            messageBox.open();
            return;
        }
        if (this.cboInputReporter.getSelectionIndex() == 0) {
            payload.setSensorType(769);
        } else if (this.cboInputReporter.getSelectionIndex() == 1) {
            payload.setSensorType(768);
        } else if (this.cboInputReporter.getSelectionIndex() == 2) {
            payload.setSensorType(777);
        } else if (this.cboInputReporter.getSelectionIndex() == 3) {
            payload.setSensorType(774);
        }
        try {
            this._busInfo.busPayloadFromFields();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlEc, 513);
            messageBox.setText("Bus Information");
            messageBox.setMessage(e.getMessage() != null ? e.getMessage() : "Unknown Error: " + e.getStackTrace());
            messageBox.open();
            return;
        }
        this._parent.getBusInfo().copyBusInfo(this._busInfo);
        this._payload = payload;
        if (newConfiguration) {
            if (this._sensor != null) {
                this._sensor.addPayload(this._payload);
            }
            this._parent.addNewConfiguration(this._payload);
        }
        this._properties.setModified(false);
        this._parent.setModified();
        this.shlEc.close();
    }

    public static boolean chooseComboItemByValue(Combo combo) {
        return GuiUtils.chooseComboItemByValue(combo);
    }

    protected void createContents() {
        this.shlEc = new Shell(65760);
        this.shlEc.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (EcConfiguration.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(EcConfiguration.this.shlEc, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEc.setImage(SWTResourceManager.getImage(EcConfiguration.class, "/resources/Intel.ico"));
        GridLayout gridLayoutshlEc = new GridLayout(2, false);
        gridLayoutshlEc.marginWidth = 10;
        gridLayoutshlEc.marginHeight = 10;
        gridLayoutshlEc.horizontalSpacing = 10;
        gridLayoutshlEc.verticalSpacing = 10;
        this.shlEc.setLayout((Layout)gridLayoutshlEc);
        this.shlEc.setText("Embedded Control Configuration");
        try {
            this._busInfo = new BusInfo(this._properties);
            this._busInfo.filterBusTypes(InformationStore.getInstance().getSensorRelevantBusTypes());
            this._busInfo.drawBusInfo(this.shlEc, (Composite)this.shlEc);
            this._busInfo.setLayoutData(new GridData(4, 0x1000000, true, true, 2, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Group grpInputReporter = GuiUtils.addGroupToComposite("", (Composite)this.shlEc, 0, 4, 128, true, false, 2, 1, 2);
        GuiUtils.addLabelToComposite("Input Reporter:", (Composite)grpInputReporter, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cboInputReporter = GuiUtils.addComboToComposite((Composite)grpInputReporter, 12, 4, 16384, true, false, 1, 1);
        this.cboInputReporter.add("On Table Detection");
        this.cboInputReporter.add("PLM");
        this.cboInputReporter.add("Dynamic Keyboard Lighting");
        this.cboInputReporter.add("Device Posture");
        this.cboInputReporter.select(1);
        Button btnSaveAndClose = new Button((Composite)this.shlEc, 0);
        GridData gd_btnSaveAndClose = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnSaveAndClose.widthHint = GuiUtils.getButtonWidth((Control)this.shlEc);
        btnSaveAndClose.setLayoutData((Object)gd_btnSaveAndClose);
        btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EcConfiguration.this.saveData();
            }
        });
        btnSaveAndClose.setText("Save and Close");
        Button btnCancel = new Button((Composite)this.shlEc, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlEc);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EcConfiguration.this.shlEc.close();
            }
        });
        btnCancel.setText("Cancel");
        this.shlEc.setSize(this.shlEc.computeSize(-1, -1));
        this.shlEc.setLocation(GuiUtils.getMiddleLocation(this.shlEc, this.display));
    }

    @Override
    public String getConfigurationFormatName() {
        return "Embedded Control Configuration";
    }
}

