/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.persistence.cache.Impl;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.persistence.cache.api.ModuleCacheManager;
import com.intel.sensing.fdk.model.service.PlatformService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class KitModuleCacheManager
extends ModuleCacheManager {
    private static KitModuleCacheManager _instance;
    private static final int MAX_SEARCH_DEPTH = 4;
    private static final Path kitBaseDir;
    private static PlatformService fPlatformService;

    static {
        kitBaseDir = Paths.get(ManagerFileUtils.getKitsBaseDir(), new String[0]);
    }

    private KitModuleCacheManager() throws ISSException, IOException {
        super(kitBaseDir, true, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KitModuleCacheManager init() throws ISSException, IOException {
        if (_instance != null) return _instance;
        Class<KitModuleCacheManager> clazz = KitModuleCacheManager.class;
        synchronized (KitModuleCacheManager.class) {
            if (_instance != null) return _instance;
            fPlatformService = PlatformService.getInstance();
            _instance = new KitModuleCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    @Override
    public List<String> generateAllModulePathList() throws IOException {
        List platformList = Files.list(kitBaseDir).filter(f -> f != null && Files.isDirectory(f, new LinkOption[0])).filter(f -> fPlatformService.supportPlaform(f.toFile().getName())).collect(Collectors.toList());
        List versionList = platformList.stream().flatMap(platform -> Arrays.stream(platform.toFile().listFiles())).filter(file -> file != null && file.exists() && file.isDirectory()).map(file -> file.toPath().resolve("modules")).filter(path -> path != null && path.toFile().exists() && path.toFile().isDirectory()).collect(Collectors.toList());
        ArrayList<Path> modulePathList = new ArrayList<Path>();
        for (Path path2 : versionList) {
            this.getModulePaths(path2, modulePathList, 0);
        }
        List<String> ret = modulePathList.stream().map(p -> p.toString()).collect(Collectors.toList());
        return ret;
    }

    private int getModulePaths(Path root, ArrayList<Path> allModules, int searchDepth) {
        File rootFile = root.toFile();
        if (rootFile == null || !rootFile.exists() || !rootFile.isDirectory() || searchDepth > 4) {
            return searchDepth - 1;
        }
        Path moduleFilePath = root.resolve("module.json");
        if (moduleFilePath.toFile().exists()) {
            allModules.add(root);
        } else {
            File[] fileArray = rootFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.getModulePaths(file.toPath(), allModules, searchDepth + 1);
                ++n2;
            }
        }
        return searchDepth - 1;
    }
}

