/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pdtEditor.CalibrationParser;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Validator;

public class AlsCalibrationPayload
extends CalibrationPayload {
    public static final int CALIBRATION_TYPE = 1;
    public static final String CALIBRATION_FORMAT_STRING = "Intel Ambient Light Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    public static final int LATEST_FORMAT = 1;
    private static final int NUM_OF_STEPS_FIELD_SIZE = 1;
    public static final int MIN_NUMBER_OF_STEPS = 3;
    public static final int MAX_NUMBER_OF_STEPS = (int)Math.pow(2.0, 8.0) - 1;
    private static final int LAST_ALS_FORMAT_FOR_PDT_FORMAT_VERSION1 = 0;
    private static final int MIN_PDT_FORMAT_VERSION_FOR_ALS_FORMAT1 = 2;
    public static final int SCALE_FACTOR_FIELD_SIZE = 2;
    public static final int SCALE_FACTOR_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
    private static final int DIVIDER_FIELD_SIZE = 1;
    private static final int DIVIDER_FOR_MULTIPLIER_CALCULATION = 255;
    private static final int LUX_FIELD_SIZE = 2;
    private static final int BRIGHTNESS_FIELD_SIZE = 2;
    private int _formatID = AlsCalibrationPayload.getLatestFormatVersion();
    private int _version = 0;
    private int _scaleFactor = 1;
    private int _divider = 1;
    private ArrayList<Step> _steps = new ArrayList();
    private ArrayList<Byte> _vendorDefinedData = new ArrayList();

    public AlsCalibrationPayload() {
    }

    public AlsCalibrationPayload(AlsCalibrationPayload other) {
        super(other);
        this.copyContent(other);
    }

    public void copyContent(AlsCalibrationPayload other) {
        this._formatID = other._formatID;
        this._version = other._version;
        this._scaleFactor = other._scaleFactor;
        this._divider = other._divider;
        this._steps.clear();
        for (Step step : other._steps) {
            this._steps.add(step);
        }
        this._vendorDefinedData.clear();
        for (Byte value : other._vendorDefinedData) {
            this._vendorDefinedData.add(value);
        }
    }

    public AlsCalibrationPayload(int formatId, int dataLength, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        if (this._formatID == 0) {
            this.readFormatVersion0(dataLength, reader, payloadXmlNode);
        } else if (DataStore.getInstance().getPdtFormatVersion() >= 2 && this._formatID == 1) {
            this.readFormatVersion1(dataLength, reader, payloadXmlNode);
        } else {
            if (this._formatID > 1) {
                throw new FeatureNotSupportedYetException(this);
            }
            throw new RuntimeException("The ALS calibration's format ID is not reconized for this version of the PDT format");
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof AlsCalibrationPayload)) {
            return false;
        }
        AlsCalibrationPayload other = (AlsCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._scaleFactor == other._scaleFactor && this._divider == other._divider && (this._steps == null && other._steps == null || this._steps != null && this._steps.equals(other._steps)) || (this._vendorDefinedData != null || other._vendorDefinedData != null) && (this._vendorDefinedData == null || !this._vendorDefinedData.equals(other._vendorDefinedData));
    }

    private void readSteps(BinReader reader, Node calibElement, int numOfSteps) {
        for (int i = 1; i <= numOfSteps; ++i) {
            Element stepElement = reader.readNewField((String)new StringBuilder().append((String)"Step").append((int)i).toString(), (Node)calibElement).xmlElement;
            Step step = new Step();
            step._brightnessPercent = reader.readNewField((String)"BrightnessPercent", (int)2, (boolean)false, (Node)stepElement).value;
            step._luxValue = reader.readNewField((String)"LuxValue", (int)2, (boolean)false, (Node)stepElement).value;
            this._steps.add(step);
        }
    }

    private void readFormatVersion0(int dataLength, BinReader reader, Node parent) {
        Element calibElement = reader.readNewField((String)"AlsCalibrationV0", (Node)parent).xmlElement;
        int numOfSteps = (dataLength - 2) / 4;
        this.readSteps(reader, calibElement, numOfSteps);
    }

    private void readFormatVersion1(int dataLength, BinReader reader, Node parent) {
        Element calibElement = reader.readNewField((String)"AlsCalibrationV1", (Node)parent).xmlElement;
        this._scaleFactor = reader.readNewField((String)"ScaleFactor", (int)2, (boolean)false, (Node)calibElement).value;
        this._divider = reader.readNewField((String)"Divider", (int)1, (boolean)false, (Node)calibElement).value;
        int numOfSteps = reader.readNewField((String)"NumOfSteps", (int)1, (boolean)false, (Node)calibElement).value;
        this.readSteps(reader, calibElement, numOfSteps);
        if (6 + numOfSteps * 4 < dataLength) {
            byte[] venDefinedData;
            int vendorDefSize = reader.readNewField((String)"VendorDefinedSize", (int)2, (boolean)false, (Node)calibElement).value;
            byte[] byArray = venDefinedData = reader.readBytes(vendorDefSize, "VendorDefinedData", calibElement);
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte b = byArray[i];
                this._vendorDefinedData.add(b);
            }
        }
    }

    @Override
    public AlsCalibrationPayload clone() {
        return new AlsCalibrationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        switch (this._formatID) {
            case 0: {
                this.appendFormatV0Content(writer, parent);
                break;
            }
            case 1: {
                this.appendFormatV1Content(writer, parent);
            }
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    private void appendFormatV0Content(BinWriter writer, Element parent) {
        Element calibrationElement = writer.writeNewField((String)"AlsCalibrationV0", (Node)parent).xmlElement;
        int i = 1;
        for (Step step : this._steps) {
            Element stepElement = writer.writeNewField((String)new StringBuilder().append((String)"Step").append((int)i).toString(), (Node)calibrationElement).xmlElement;
            writer.writeNewField("BrightnessPercent", 2, step._brightnessPercent, (Node)stepElement);
            writer.writeNewField("LuxValue", 2, step._luxValue, (Node)stepElement);
            ++i;
        }
    }

    private void appendFormatV1Content(BinWriter writer, Element parent) {
        Element calibrationElement = writer.writeNewField((String)"AlsCalibrationV1", (Node)parent).xmlElement;
        writer.writeNewField("ScaleFactor", 2, this._scaleFactor, (Node)calibrationElement);
        writer.writeNewField("Divider", 1, this._divider, (Node)calibrationElement);
        writer.writeNewField("NumOfSteps", 1, this._steps.size(), (Node)calibrationElement);
        int i = 1;
        for (Step step : this._steps) {
            Element stepElement = writer.writeNewField((String)new StringBuilder().append((String)"Step").append((int)i).toString(), (Node)calibrationElement).xmlElement;
            writer.writeNewField("BrightnessPercent", 2, step._brightnessPercent, (Node)stepElement);
            writer.writeNewField("LuxValue", 2, step._luxValue, (Node)stepElement);
            ++i;
        }
        if (this._vendorDefinedData.size() > 0) {
            writer.writeNewField("VendorDefinedSize", 2, this._vendorDefinedData.size(), (Node)calibrationElement);
            writer.writerBinaryField("VendorDefinedData", this._vendorDefinedData, calibrationElement);
        }
    }

    public void setDataFromXalibrationXML(Element calibrationData) {
        block19: {
            Element dataElement = (Element)DataStore.getChildNodeByName(calibrationData, "Steps");
            try {
                Integer.valueOf(dataElement.getAttribute("NumOfSteps"));
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid value for the numOfSteps attribute");
                throw e;
            }
            this._steps.clear();
            NodeList steps = dataElement.getChildNodes();
            for (int i = 0; i < steps.getLength(); ++i) {
                Node node = steps.item(i);
                if (node.getNodeType() != 1) continue;
                int lux = -1;
                int scale = -1;
                Element stepElement = (Element)node;
                NodeList stepValues = stepElement.getChildNodes();
                for (int j = 0; j < stepValues.getLength(); ++j) {
                    if (stepValues.item(j).getNodeType() != 1) continue;
                    Element valNode = (Element)stepValues.item(j);
                    String valName = valNode.getNodeName();
                    try {
                        if (valName.equals("Lux")) {
                            lux = Integer.valueOf(valNode.getAttribute("value"));
                            continue;
                        }
                        if (!valName.equals("Scale")) continue;
                        scale = Integer.valueOf(valNode.getAttribute("value"));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid values in the step");
                        throw e;
                    }
                }
                if (lux < 0 || scale < 0) {
                    System.err.println("Corrupted step");
                    throw new RuntimeException("Corrupted step");
                }
                Step step = new Step();
                step._brightnessPercent = scale;
                step._luxValue = lux;
                this._steps.add(step);
            }
            Element scaleFactorElement = (Element)DataStore.getChildNodeByName(calibrationData, "Multiplier");
            if (scaleFactorElement != null) {
                try {
                    this._scaleFactor = Integer.valueOf(scaleFactorElement.getTextContent());
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("ALS calibration: Invalid multiplier value");
                }
                String divider = scaleFactorElement.getAttribute("Divider");
                if (divider != null) {
                    try {
                        this._divider = Integer.valueOf(divider);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("ALS calibration: Invalid divider value");
                    }
                }
            }
            try {
                Element vendorDataElement;
                try {
                    vendorDataElement = (Element)DataStore.getChildNodeByName(calibrationData, "VendorData");
                }
                catch (Exception e) {
                    break block19;
                }
                if (vendorDataElement != null) {
                    this._vendorDefinedData = CalibrationParser.getBinaryData(vendorDataElement);
                }
            }
            catch (Exception e) {
                System.err.println("Corrupted vendor data");
                throw new RuntimeException(e);
            }
        }
    }

    public static int getLatestFormatVersion() {
        if (DataStore.getInstance().getPdtFormatVersion() >= 2) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public int getScaleFactor() {
        return this._scaleFactor;
    }

    public void setScaleFactor(int scaleFactor) {
        this._scaleFactor = scaleFactor;
    }

    public int getDivider() {
        return this._divider;
    }

    public void setDivider(int divider) {
        this._divider = divider;
    }

    public double getMultiplier() {
        return this._divider != 0 ? (double)this._scaleFactor / (double)this._divider : (double)this._scaleFactor;
    }

    public void setMultiplier(double value) {
        int calculatedScaleFactor = (int)Math.round(value * 255.0);
        if (calculatedScaleFactor > SCALE_FACTOR_MAX_VALUE) {
            this._scaleFactor = (int)Math.round(value);
            this._divider = 1;
        } else {
            this._scaleFactor = calculatedScaleFactor;
            this._divider = 255;
        }
    }

    public ArrayList<Step> getSteps() {
        return this._steps;
    }

    public void setSteps(ArrayList<Step> steps) {
        this._steps = steps;
    }

    public ArrayList<Byte> getVendorDefinedData() {
        return this._vendorDefinedData;
    }

    public void setVendorDefinedData(ArrayList<Byte> vendorDefinedData) {
        this._vendorDefinedData = vendorDefinedData;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class Step {
        public int _brightnessPercent;
        public int _luxValue;

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof Step)) {
                return false;
            }
            Step other = (Step)arg0;
            return this._brightnessPercent == other._brightnessPercent && this._luxValue == other._luxValue;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

