/*
 * Decompiled with CFR 0.152.
 */
package manager.utils.log;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import manager.utils.log.HtmlFormatter;

public class LogManager {
    private static Logger logger = null;
    private static FileHandler fileTxt;
    private static SimpleFormatter formatterTxt;
    private static FileHandler fileHTML;
    private static Formatter formatterHTML;

    public static void setup(String logsFolder) throws SecurityException, IOException {
        fileTxt = new FileHandler(String.valueOf(logsFolder) + "/log.txt");
        fileHTML = new FileHandler(String.valueOf(logsFolder) + "/log.html");
        logger = Logger.getLogger("global");
        logger.setLevel(Level.INFO);
        formatterTxt = new SimpleFormatter();
        fileTxt.setFormatter(formatterTxt);
        logger.addHandler(fileTxt);
        formatterHTML = new HtmlFormatter();
        fileHTML.setFormatter(formatterHTML);
        logger.addHandler(fileHTML);
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers[0] instanceof ConsoleHandler) {
            rootLogger.removeHandler(handlers[0]);
        }
    }

    public static void log(Level logLevel, String message) {
        if (logger != null) {
            LogManager.log(logLevel, LogManager.getCallerClassName(), LogManager.getCallerMethodName(), message);
        }
    }

    private static void log(Level logLevel, String sourceClass, String sourceMethod, String message) {
        logger.logp(logLevel, sourceClass, sourceMethod, message);
    }

    public static void log(String message) {
        LogManager.log(Level.INFO, LogManager.getCallerClassName(), LogManager.getCallerMethodName(), message);
    }

    private static String getCallerMethodName() {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
        return traceElement.getMethodName();
    }

    private static String getCallerClassName() {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
        return traceElement.getClassName();
    }
}

