/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinWriter;
import dbgConfig.DbgConfig;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import packaging.NvarPackage;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.Luid;
import pdtEditor.PdtFile;
import pdtEditor.PdtWriter;
import pdtEditor.Sensor;

public class CLIUtils {
    public static void changePDTFormat(String pdtFilePath, int newFormat) throws IOException, TransformerException {
        if (DataStore.getInstance().getPdtFiles().size() > 0) {
            throw new RuntimeException("This upgrade operation is not allowed if some PDT files already loaded.");
        }
        if (pdtFilePath == null || !new File(pdtFilePath).isFile()) {
            throw new RuntimeException("Invalid path.");
        }
        if (newFormat < 0 || newFormat > 5) {
            throw new RuntimeException("This version of the PDT Editor cannot convert files to format version " + newFormat + ".");
        }
        PdtFile pdt = new PdtFile(pdtFilePath);
        try {
            DataStore.getInstance().loadFromPdtBin(pdt);
        }
        catch (Exception e) {
            throw new RuntimeException("The selected file is not in a proper PDT format.\nException: " + e.getMessage());
        }
        DataStore.FlowResults result = new DataStore.FlowResults();
        DataStore.getInstance().setPdtFormatVersion(newFormat, result);
        DataStore.getInstance().saveToPdtBin(pdt);
        DataStore.getInstance().removePdtFile(pdt);
        System.out.println("PDT format change completed successfully.");
    }

    public static void mergePdts(String pdtPath1, String pdtPath2) throws IOException, TransformerException {
        PdtFile pdtFile1;
        if (DataStore.getInstance().getPdtFiles().size() > 0) {
            throw new RuntimeException("This merge operation is not allowed if some PDT files already loaded.");
        }
        if (pdtPath1 == null || !new File(pdtPath1).isFile() || pdtPath2 == null || !new File(pdtPath2).isFile()) {
            throw new RuntimeException("Invalid paths.");
        }
        if (NvarPackage.isNVARPackage(pdtPath1)) {
            DataStore.getInstance().loadNVARPAckage(pdtPath1);
            if (DataStore.getInstance().getCurrentPdtFile() == null) {
                throw new RuntimeException("Bad PDT file");
            }
            pdtFile1 = new PdtFile(DataStore.getInstance().getCurrentPdtFile());
        } else {
            pdtFile1 = new PdtFile(pdtPath1);
            try {
                DataStore.getInstance().loadFromPdtBin(pdtFile1);
            }
            catch (Exception e) {
                throw new RuntimeException("The selected file (" + pdtPath1 + ") is not in a proper PDT format.\nException: " + e.getMessage());
            }
        }
        if (NvarPackage.isNVARPackage(pdtPath2)) {
            throw new RuntimeException("The merged file cannot be a NVAR package, only a PDT file.");
        }
        PdtFile pdtFile2 = new PdtFile(pdtPath2);
        try {
            DataStore.getInstance().loadFromPdtBin(pdtFile2);
        }
        catch (Exception e) {
            throw new RuntimeException("The selected file (" + pdtPath2 + ") is not in a proper PDT format.\nException: " + e.getMessage());
        }
        for (int i = 0; i < pdtFile2.getDevices().size(); ++i) {
            Device deviceIn2 = pdtFile2.getDevices().get(i);
            if (i >= pdtFile1.getDevices().size()) {
                pdtFile1.addDevice(deviceIn2);
                break;
            }
            Device deviceIn1 = pdtFile1.getDevices().get(i);
            if (deviceIn2.getProductId() != deviceIn1.getProductId() || deviceIn2.getVendorId() != deviceIn1.getVendorId()) continue;
            for (Sensor sensorIn2 : deviceIn2.getSensors()) {
                boolean duplicatedSensor = false;
                Luid luidOf2 = sensorIn2.getLuid();
                for (Sensor sensorin1 : deviceIn1.getSensors()) {
                    if (!luidOf2.equals(sensorin1.getLuid())) continue;
                    System.out.println("The following sensor [" + sensorIn2.toString() + "] already exist in the PDT file.");
                    duplicatedSensor = true;
                    break;
                }
                if (duplicatedSensor) continue;
                deviceIn1.addSensor(sensorIn2);
            }
        }
        NvarPackage nvarPackage = new NvarPackage();
        nvarPackage.setPdtGivenName(pdtFile1.getPDTName());
        nvarPackage.setBinPath(pdtFile1.getPath());
        nvarPackage.setPdtContent(pdtFile1.getPdtBinaryContent());
        DbgConfig dbgConfig = DataStore.getInstance().getDbgConfigData();
        if (dbgConfig != null) {
            nvarPackage.setDebugConfContent(dbgConfig.getBinaryContent());
        }
        nvarPackage.writeNvarPackage();
        DataStore.getInstance().removePdtFile(pdtFile1);
        DataStore.getInstance().removePdtFile(pdtFile2);
        System.out.println("PDT merge completed successfully.");
    }

    public static void updateCustomVersion(String inputpdtFilePath, String outputpdtFilePath, int version) throws IOException, TransformerException {
        if (DataStore.getInstance().getPdtFiles().size() > 0) {
            throw new RuntimeException("This upgrade operation is not allowed if some PDT files already loaded.");
        }
        if (outputpdtFilePath == null) {
            outputpdtFilePath = inputpdtFilePath;
        }
        if (inputpdtFilePath == null || !new File(inputpdtFilePath).isFile()) {
            throw new RuntimeException("Invalid input PDT path.");
        }
        if (outputpdtFilePath == null) {
            throw new RuntimeException("Invalid output PDT path.");
        }
        if (NvarPackage.isNVARPackage(inputpdtFilePath)) {
            DataStore.getInstance().loadNVARPAckage(inputpdtFilePath);
            if (DataStore.getInstance().getCurrentPdtFile() == null) {
                throw new RuntimeException("Bad PDT file");
            }
            PdtFile pdtFile = new PdtFile(DataStore.getInstance().getCurrentPdtFile());
            NvarPackage nvarPackage = new NvarPackage();
            nvarPackage.setPdtGivenName(pdtFile.getPDTName());
            nvarPackage.setBinPath(outputpdtFilePath);
            pdtFile.setSkuId(version);
            nvarPackage.setPdtContent(pdtFile.getPdtBinaryContent());
            DbgConfig dbgConfig = DataStore.getInstance().getDbgConfigData();
            if (dbgConfig != null) {
                nvarPackage.setDebugConfContent(dbgConfig.getBinaryContent());
            }
            BinWriter pdtWriter = new BinWriter(true, "ISH");
            new PdtWriter(pdtWriter, DataStore.getInstance().getCurrentPdtFile()).writePdtContent();
            Element headElement = pdtWriter.getHeadElement();
            nvarPackage.writeNvarPackage(headElement, false);
            DataStore.getInstance().removePdtFile(pdtFile);
            System.out.println("PDT NVAR version updated successfully.");
        } else {
            PdtFile pdtFile = new PdtFile(inputpdtFilePath);
            try {
                DataStore.getInstance().loadFromPdtBin(pdtFile);
            }
            catch (Exception e) {
                throw new RuntimeException("The selected file (" + inputpdtFilePath + ") is not in a proper PDT format.\nException: " + e.getMessage());
            }
            pdtFile.setSkuId(version);
            pdtFile.setPath(outputpdtFilePath);
            DataStore.getInstance().setCurrentPdtFile(pdtFile);
            DataStore.getInstance().saveToPdtBin(pdtFile);
            DataStore.getInstance().removePdtFile(pdtFile);
            System.out.println("PDT version updated successfully.");
        }
    }
}

