/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.abstractData;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.model.abstractData.AbstractData;
import com.intel.sensing.fdk.model.abstractData.CategoryData;
import com.intel.sensing.fdk.model.abstractData.DataUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Category
extends AbstractData {
    private String description;
    private static int index = 0;
    private static AbstractData first = null;
    private static AbstractData last = null;
    public static final Category OS = new Category(CategoryData.OS.getName(), CategoryData.OS.getDetail());
    public static final Category RTOS = new Category(CategoryData.RTOS.getName(), CategoryData.RTOS.getDetail());
    public static final Category API = new Category(CategoryData.API.getName(), CategoryData.API.getDetail());
    public static final Category APP = new Category(CategoryData.APP.getName(), CategoryData.APP.getDetail());
    public static final Category LIB = new Category(CategoryData.LIB.getName(), CategoryData.LIB.getDetail());
    public static final Category BSP = new Category(CategoryData.BSP.getName(), CategoryData.BSP.getDetail());
    public static final Category AON = new Category(CategoryData.AON.getName(), CategoryData.AON.getDetail());
    public static final Category HEADERS = new Category(CategoryData.HEADERS.getName(), CategoryData.HEADERS.getDetail());
    public static final Category SENSOR = new Category(CategoryData.SENSOR.getName(), CategoryData.SENSOR.getDetail());
    public static final Category UNKNOWN = new Category(CategoryData.UNKNOWN.getName(), CategoryData.UNKNOWN.getDetail());

    public Category(String name) {
        this(name, "");
    }

    public Category(String name, String desc) {
        super(name);
        if (first == null) {
            first = this;
        }
        last = this;
        this.description = desc;
    }

    @Override
    protected int nextId() {
        return index++;
    }

    @Override
    protected AbstractData last() {
        return last;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static String[] getItems() {
        return DataUtils.getItems(first);
    }

    public static int getItemIndexByName(String name) {
        String[] item = Category.getItems();
        int i = 0;
        while (i < item.length) {
            if (item[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Category getItemById(int id) {
        return (Category)DataUtils.getItemById(id, first);
    }

    public static Category getItemByName(String name) throws ISSException {
        Category category = (Category)DataUtils.getItemByName(name, first);
        if (category == null) {
            throw new ISSException("Category not recognized: " + name);
        }
        return category;
    }

    public static List<Category> getList() {
        ArrayList<Category> items = new ArrayList<Category>();
        Enumeration<AbstractData> e = DataUtils.elements(first);
        while (e.hasMoreElements()) {
            Category ca = (Category)e.nextElement();
            items.add(ca);
        }
        return items;
    }
}

