/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.abstractData;

import com.intel.sensing.fdk.model.abstractData.VersionRange;
import java.io.File;

public class Dependency {
    private String name;
    private VersionRange range;
    private String relativePath;

    public Dependency(String name, VersionRange range, String path) {
        this.name = name;
        this.range = range;
        this.relativePath = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public void setRange(VersionRange range) {
        this.range = range;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getFullName() {
        File relative = new File(this.relativePath);
        if (relative.exists()) {
            this.relativePath = relative.getName();
        }
        return String.valueOf(this.relativePath) + "/" + this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)obj;
        return this.getFullName().equals(dependency.getFullName());
    }

    public static Dependency parseFullName(String fullName) {
        int index = fullName.indexOf("/");
        if (index < 0) {
            index = 0;
        }
        String path = fullName.substring(0, index);
        index = fullName.lastIndexOf(File.separator) > 0 ? fullName.lastIndexOf(File.separator) : index;
        while (index == fullName.length()) {
            int n = index = fullName.lastIndexOf(File.separator) > 0 ? fullName.lastIndexOf(File.separator) : index;
        }
        int rIndex = fullName.indexOf(":");
        if (rIndex < 0) {
            rIndex = fullName.length();
        }
        String moduleName = fullName.substring(index + 1, rIndex);
        return new Dependency(moduleName, null, path);
    }

    public static Dependency generate(String name, String path) {
        return new Dependency(name, null, path);
    }
}

