$myDevName = "Intel(R) PPM Provisioning Package"
$devices = Get-PnpDevice -FriendlyName $myDevName

if ($devices) {
    $devices | ForEach-Object {
        Write-Output "-----------------------------"
        Write-Output "DeviceName: $($_.FriendlyName)"
        Write-Output "InstanceId: $($_.InstanceId)"
        Write-Output "Status: $($_.Status)"
        Write-Output "-----------------------------"
    }
	
	# Define the folder path

    $strWindir = [System.Environment]::GetEnvironmentVariable("windir")
    $folderPath = "$strWindir\Provisioning\Packages\"
    $keyword = "PPM-"

    # Get the newest file in the folder with the specified keyword
    $newestFile = Get-ChildItem -Path $folderPath -Filter "$keyword*" | Sort-Object LastWriteTime -Descending | Select-Object -First 1
	if ($newestFile) {
        $ppmpath = $newestFile.FullName
	    Write-Output $ppmpath
	
        # Install PPM
        dism /Online /Add-ProvisioningPackage /PackagePath:$ppmpath
	}
}


exit 0
