/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.files.json.JsonSerializer;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.FileSystemUtils;
import com.intel.sensing.fdk.common.utils.JsonFormatTool;
import com.intel.sensing.fdk.common.utils.StringUtils;
import com.intel.sensing.fdk.model.entity.AbstractEntity;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractJsonDao<T> {
    public void saveEntity(T t) {
        if (t instanceof AbstractEntity) {
            this.saveToJsonFile(t, ((AbstractEntity)t).getJsonFilePath());
        }
    }

    protected void modifyEntity(T t, String key, Object value) {
        try {
            Class<?> clazz = t.getClass();
            if (this.ifKeyExist(key, clazz)) {
                Method valueSetter = this.getSetterByKey(key, clazz);
                valueSetter.invoke(t, value);
            }
        }
        catch (NoSuchMethodException e) {
            ISSLogger.e((Exception)e);
            ExceptionHandler.HandleException((Exception)e);
        }
        catch (SecurityException e) {
            ExceptionHandler.HandleException((Exception)e);
            ISSLogger.e((Exception)e);
        }
        catch (NoSuchFieldException e) {
            ExceptionHandler.HandleException((Exception)e);
            ISSLogger.e((Exception)e);
        }
        catch (Exception e) {
            ExceptionHandler.HandleException((Exception)e);
            ISSLogger.e((Exception)e);
        }
    }

    public void deleteEntity(T t) {
        Assert.isNotNull(t);
        if (!(t instanceof AbstractEntity)) {
            return;
        }
        String filePath = ((AbstractEntity)t).getJsonFilePath();
        this.deleteJsonFile(filePath);
    }

    protected T getEntityByFilePath(String filePath, Class<? extends Object> clazz) {
        Object t = null;
        try {
            String jContent = FileSystemUtils.readFileContent((File)new File(filePath));
            t = JsonSerializer.deserialize((String)jContent, clazz);
            if (t instanceof AbstractEntity) {
                ((AbstractEntity)t).setJsonFilePath(filePath);
            }
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
            return null;
        }
        return (T)t;
    }

    public String toJsonString(T entity) {
        String jsonString = "";
        try {
            jsonString = JsonSerializer.serialize(entity);
        }
        catch (JsonProcessingException e) {
            ISSLogger.e((Exception)((Object)e));
        }
        if (jsonString == null) {
            jsonString = "";
        }
        return jsonString;
    }

    protected abstract T getEntityByFilePath(String var1) throws Exception;

    public void saveToJsonFile(T t, String filePath) {
        T entity = t;
        try {
            String json = JsonSerializer.serialize(entity);
            json = JsonFormatTool.formatJson((String)json);
            if (new File(filePath).exists()) {
                FileSystemUtils.writeToFile((String)filePath, (String)json);
            } else {
                FileSystemUtils.createFile((String)filePath, (String)json);
            }
        }
        catch (JsonProcessingException e) {
            ISSLogger.e((Exception)((Object)e));
            ExceptionHandler.HandleExceptionInSeparateThread((Exception)((Object)e));
        }
        catch (IOException e) {
            ISSLogger.e((Exception)e);
            ExceptionHandler.HandleExceptionInSeparateThread((Exception)e);
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
            ExceptionHandler.HandleExceptionInSeparateThread((Exception)e);
        }
    }

    protected void deleteJsonFile(String filePath) {
        try {
            boolean success = FileSystemUtils.deleteFile((String)filePath);
            if (!success) {
                throw new Exception("Cannot delete file: " + filePath);
            }
        }
        catch (IOException e) {
            ISSLogger.e((Exception)e);
            ExceptionHandler.HandleExceptionInSeparateThread((Exception)e);
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
            ExceptionHandler.HandleExceptionInSeparateThread((Exception)e);
        }
    }

    protected boolean ifKeyExist(String key, Class<T> clazz) throws Exception {
        if (Assert.isTrue((boolean)Arrays.stream(clazz.getFields()).anyMatch(f -> f.getName().equals(key)))) {
            return true;
        }
        throw new Exception("Key not found in" + clazz.getCanonicalName());
    }

    protected Method getSetterByKey(String key, Class<T> clazz) throws NoSuchMethodException, SecurityException, NoSuchFieldException, Exception {
        Method method = null;
        if (this.ifKeyExist(key, clazz)) {
            method = clazz.getDeclaredMethod("set" + StringUtils.firstLetterToUpper((String)key), ModuleEntity.class.getField(key).getType());
        }
        return method;
    }
}

