/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class PojoValueProperty
extends SimpleValueProperty {
    private final PropertyDescriptor propertyDescriptor;
    private final Class valueType;

    public PojoValueProperty(PropertyDescriptor propertyDescriptor, Class valueType) {
        this.propertyDescriptor = propertyDescriptor;
        this.valueType = valueType == null ? propertyDescriptor.getPropertyType() : valueType;
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected Object doGetValue(Object source) {
        if (source == null) {
            return null;
        }
        return BeanPropertyHelper.readProperty(source, this.propertyDescriptor);
    }

    protected void doSetValue(Object source, Object value) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, value);
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return null;
    }

    public String toString() {
        String s = BeanPropertyHelper.propertyName(this.propertyDescriptor);
        if (this.valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

