/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.util.concurrent.CancellationException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.AlsCalibrationEditor;
import resources.CustomSpinner;

public class AlsCalibrationEditorDialog {
    protected Shell editCalibrationStepShell;
    private AlsCalibrationEditor _parent = null;
    private CustomSpinner brightnessSpinner;
    private CustomSpinner luxValueSpinner;
    private int _brightness = 0;
    private int _luxValue = 0;
    private Display display;

    public static void main(String[] args) {
        try {
            AlsCalibrationEditorDialog window = new AlsCalibrationEditorDialog(null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AlsCalibrationEditorDialog(AlsCalibrationEditor parent) {
        this._parent = parent;
    }

    public AlsCalibrationEditorDialog(AlsCalibrationEditor parent, int brightness, int luxValue) {
        this._parent = parent;
        this._brightness = brightness;
        this._luxValue = luxValue;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.editCalibrationStepShell.open();
        this.editCalibrationStepShell.layout();
        while (!this.editCalibrationStepShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void fillData() {
        this.brightnessSpinner.setSelection(this._brightness);
        this.luxValueSpinner.setSelection(this._luxValue);
    }

    protected void createContents() {
        this.editCalibrationStepShell = new Shell(65632);
        this.editCalibrationStepShell.setImage(SWTResourceManager.getImage(AlsCalibrationEditorDialog.class, "/resources/Intel.ico"));
        this.editCalibrationStepShell.setText("Edit Calibration Step");
        GuiUtils.setGridLayoutToComposite((Composite)this.editCalibrationStepShell, 2);
        Label lblInstruction = new Label((Composite)this.editCalibrationStepShell, 0);
        lblInstruction.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblInstruction.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        lblInstruction.setText("Please enter the requested values of the step:");
        Label lblBrightness = new Label((Composite)this.editCalibrationStepShell, 0);
        lblBrightness.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblBrightness.setText("Brightness Percent:");
        this.brightnessSpinner = new CustomSpinner((Composite)this.editCalibrationStepShell, 2048, this.editCalibrationStepShell);
        this.brightnessSpinner.setMaximum(65535);
        this.brightnessSpinner.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblLuxLevel = new Label((Composite)this.editCalibrationStepShell, 0);
        lblLuxLevel.setText("Lux Value:");
        lblLuxLevel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.luxValueSpinner = new CustomSpinner((Composite)this.editCalibrationStepShell, 2048, this.editCalibrationStepShell);
        this.luxValueSpinner.setMaximum(65535);
        this.luxValueSpinner.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        Button btnUpdate = new Button((Composite)this.editCalibrationStepShell, 0);
        GridData gd_btnUpdate = new GridData(131072, 0x1000000, false, false, 2, 1);
        btnUpdate.setLayoutData((Object)gd_btnUpdate);
        gd_btnUpdate.widthHint = GuiUtils.getButtonWidth((Control)this.editCalibrationStepShell);
        btnUpdate.setText("Update");
        btnUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    AlsCalibrationEditorDialog.this._parent.updateStepModification(AlsCalibrationEditorDialog.this.brightnessSpinner.getSelection(), AlsCalibrationEditorDialog.this.luxValueSpinner.getSelection());
                }
                catch (CancellationException e) {
                    AlsCalibrationEditorDialog.this.editCalibrationStepShell.setFocus();
                    return;
                }
                AlsCalibrationEditorDialog.this.editCalibrationStepShell.close();
            }
        });
        this.editCalibrationStepShell.setSize(this.editCalibrationStepShell.computeSize(-1, -1));
        this.editCalibrationStepShell.setLocation(GuiUtils.getMiddleLocation(this.editCalibrationStepShell, this.display));
    }
}

