/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.OnTableDetectionCalibration;
import pdtEditor.payloads.calibrations.OnTableDetectionCalibrationPayload;
import resources.CustomSpinner;
import resources.DoubleHolder;

public class OnTableDetectionAutoBomModifier {
    private static final int DOUBLE_PRECISION = 4;
    protected Shell shell;
    private Display display;
    private OnTableDetectionCalibration parent;
    private CustomSpinner spnEnterHysteresis;
    private CustomSpinner spnExitHysteresis;
    private DoubleHolder dbhEnterThresh;
    private DoubleHolder dbhExitThreshBase;
    private DoubleHolder dbhExitThreshMax;
    private DoubleHolder dbhStepFactor;
    private Group grpThreshold;
    private Combo cmbVendor;
    private Combo cmbModel;
    private Button btnSave;
    private Map<Integer, List<Sensor>> vendorAndModelMap = new HashMap<Integer, List<Sensor>>();
    private OnTableDetectionCalibrationPayload payload;
    private OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload data;
    private int autoBomIndex = 0;

    public OnTableDetectionAutoBomModifier(OnTableDetectionCalibration parentWindow, Map<Integer, List<Sensor>> map, OnTableDetectionCalibrationPayload payload, OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload selectData, int index) {
        this.parent = parentWindow;
        this.payload = payload;
        this.vendorAndModelMap = map;
        this.autoBomIndex = index;
        if (selectData != null) {
            OnTableDetectionCalibrationPayload onTableDetectionCalibrationPayload = payload;
            Objects.requireNonNull(onTableDetectionCalibrationPayload);
            this.data = new OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload(onTableDetectionCalibrationPayload, selectData);
        }
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        ArrayList<Integer> vendorIdList = new ArrayList<Integer>();
        try {
            for (Integer vendorId : this.vendorAndModelMap.keySet()) {
                this.cmbVendor.add(InformationStore.getInstance().getVendorName(vendorId));
                vendorIdList.add(vendorId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cmbVendor.setData("IDList", vendorIdList);
        if (this.data == null) {
            this.dbhEnterThresh.setValue(1.5);
            this.dbhExitThreshBase.setValue(5.0);
            this.dbhExitThreshMax.setValue(15.0);
            this.dbhStepFactor.setValue(0.002);
            this.spnEnterHysteresis.setSelection(20);
            this.spnExitHysteresis.setSelection(0);
        } else {
            this.dbhEnterThresh.setValue(this.data.getEnterThresh());
            this.dbhExitThreshBase.setValue(this.data.getExitThreshBase());
            this.dbhExitThreshMax.setValue(this.data.getExitThreshMax());
            this.dbhStepFactor.setValue(this.data.getStepFactor());
            this.spnEnterHysteresis.setSelection(this.data.getEnterHysteresis());
            this.spnExitHysteresis.setSelection(this.data.getExitHysteresis());
            for (int i = 0; i < vendorIdList.size(); ++i) {
                int vendorId = (Integer)vendorIdList.get(i);
                if (vendorId != this.data.getLuid().getVendorId()) continue;
                this.cmbVendor.select(i);
                break;
            }
            List<Sensor> subSensorList = this.vendorAndModelMap.get(this.data.getLuid().getVendorId());
            for (int i = 0; subSensorList != null && i < subSensorList.size(); ++i) {
                Sensor sensor = subSensorList.get(i);
                if (sensor.getLuid().getSensorSubTypeId() != this.data.getLuid().getSensorSubTypeId()) continue;
                this.cmbModel.select(i);
                break;
            }
        }
    }

    public void saveData() {
        if (this.dbhExitThreshBase.getValue() < this.dbhEnterThresh.getValue()) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Invalid Threshold Values");
            messageBox.setMessage("The exit threshold base's value cannot be less than the enter threshold's value.");
            messageBox.open();
            return;
        }
        if (this.dbhExitThreshMax.getValue() < this.dbhExitThreshBase.getValue()) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Invalid Threshold Values");
            messageBox.setMessage("The exit threshold max's value cannot be less than the exit threshold base's value.");
            messageBox.open();
            return;
        }
        boolean isAdd = false;
        if (this.data == null) {
            this.data = new OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload(this.payload);
            isAdd = true;
        }
        this.data.setEnterThresh(this.dbhEnterThresh.getValue());
        this.data.setExitThreshBase(this.dbhExitThreshBase.getValue());
        this.data.setExitThreshMax(this.dbhExitThreshMax.getValue());
        this.data.setStepFactor(this.dbhStepFactor.getValue());
        this.data.setEnterHysteresis(Short.valueOf(this.spnEnterHysteresis.getText()));
        this.data.setExitHysteresis(Short.valueOf(this.spnExitHysteresis.getText()));
        ArrayList sensorList = (ArrayList)this.cmbModel.getData("IDList");
        int index = this.cmbModel.getSelectionIndex();
        if (index < sensorList.size()) {
            this.data.setLuid(((Sensor)sensorList.get(index)).getLuid());
        }
        if (isAdd) {
            this.parent.addAutoBomToTable(this.data);
        } else {
            this.parent.updateAutoBomToTable(this.data, this.autoBomIndex);
        }
        this.shell.close();
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shell = new Shell(65632);
        this.shell.setImage(SWTResourceManager.getImage(OnTableDetectionAutoBomModifier.class, "/resources/Intel.ico"));
        this.shell.setText("On Table Detection Calibration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shell, 1);
        Group grpReporter = GuiUtils.addGroupToComposite("Accelerometer", (Composite)this.shell, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Vendor", (Composite)grpReporter, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbVendor = GuiUtils.addComboToComposite((Composite)grpReporter, 8, 4, 4, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Model", (Composite)grpReporter, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbModel = GuiUtils.addComboToComposite((Composite)grpReporter, 8, 4, 4, true, false, 1, 1);
        this.grpThreshold = GuiUtils.addGroupToComposite("Threshold Configuration", (Composite)this.shell, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Enther Threshold:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhEnterThresh = GuiUtils.addDoubleHolderToComposite(0, 100, 4, this.shell, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Threshold Base:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhExitThreshBase = GuiUtils.addDoubleHolderToComposite(0, 200, 4, this.shell, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Threshold Max:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhExitThreshMax = GuiUtils.addDoubleHolderToComposite(0, 200, 4, this.shell, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Step Factor:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhStepFactor = GuiUtils.addDoubleHolderToComposite(0, 1, 4, this.shell, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Enter Hysteresis:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnEnterHysteresis = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shell, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Hysteresis:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnExitHysteresis = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shell, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        this.spnEnterHysteresis.setMinimum(0);
        this.spnExitHysteresis.setMinimum(0);
        this.dbhEnterThresh.setMinClosedInterval(false);
        this.dbhExitThreshBase.setMinClosedInterval(false);
        this.dbhExitThreshMax.setMinClosedInterval(false);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shell, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        this.btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnSave.setEnabled(false);
        this.cmbVendor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (OnTableDetectionAutoBomModifier.this.cmbVendor.getSelectionIndex() < 0) {
                    return;
                }
                ArrayList vendorIdList = (ArrayList)OnTableDetectionAutoBomModifier.this.cmbVendor.getData("IDList");
                int vendorId = (Integer)vendorIdList.get(OnTableDetectionAutoBomModifier.this.cmbVendor.getSelectionIndex());
                OnTableDetectionAutoBomModifier.this.cmbModel.removeAll();
                if (OnTableDetectionAutoBomModifier.this.vendorAndModelMap.containsKey(vendorId)) {
                    List sensorList = (List)OnTableDetectionAutoBomModifier.this.vendorAndModelMap.get(vendorId);
                    OnTableDetectionAutoBomModifier.this.cmbModel.setData("IDList", (Object)sensorList);
                    for (Sensor sensor : sensorList) {
                        try {
                            OnTableDetectionAutoBomModifier.this.cmbModel.add(InformationStore.getInstance().getModelName(true, 115, vendorId, sensor.getLuid().getSensorSubTypeId()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                OnTableDetectionAutoBomModifier.this.updateButtonStatus();
            }
        });
        this.cmbModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionAutoBomModifier.this.updateButtonStatus();
            }
        });
        this.btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionAutoBomModifier.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionAutoBomModifier.this.shell.close();
            }
        });
        ((GridData)this.dbhEnterThresh.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shell) * 1.5);
        ((GridData)this.dbhExitThreshBase.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhExitThreshMax.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhStepFactor.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnEnterHysteresis.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnExitHysteresis.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    private void updateButtonStatus() {
        if (this.cmbVendor.getSelectionIndex() >= 0 && this.cmbModel.getSelectionIndex() >= 0) {
            this.btnSave.setEnabled(true);
        } else {
            this.btnSave.setEnabled(false);
        }
    }
}

