/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.DataStore;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Issue;
import pdtEditor.validation.Validator;

public class OnTableDetectionCalibrationPayload
extends CalibrationPayload {
    public static final int CALIBRATION_TYPE = 5;
    public static final int LATEST_FORMAT_ID = 4;
    public static final double ENTER_THRESHOLD_DEFAULT_VALUE = 1.5;
    public static final double EXIT_THRESHOLD_BASE_DEFAULT_VALUE = 5.0;
    public static final double EXIT_THRESHOLD_MAX_DEFAULT_VALUE = 15.0;
    public static final double STEP_FACTOR_DEFAULT_VALUE = 0.002;
    public static final short ENTER_HYSTERESIS_DEFAULT_VALUE = 20;
    public static final short EXIT_HYSTERESIS_DEFAULT_VALUE = 0;
    public static final int FLAG_ENABLE_ON_CS_MODE = 0;
    public static final int FLAG_DISABLE_ON_CS_MODE_VALUE = 1;
    public static final int FLAG_HORIZONTAL_ENABLE_VALUE = 2;
    public static final int PLM_MODE_ID_NOT_AVAILABLE_VALUE = -1;
    public static final String CALIBRATION_FORMAT_STRING = "On Table Detection Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    private static final double EPSILON = 1.0E-6;
    private double _enterThresh = 1.5;
    private double _exitThreshBase = 5.0;
    private double _exitThreshMax = 15.0;
    private double _stepFactor = 0.002;
    private short _enterHysteresis = (short)20;
    private short _exitHysteresis = 0;
    private int _formatID = 4;
    private int _version = 0;
    private int _flag = 0;
    private int horizontalTolerance = 0;
    private int horizontalValidPlmMode = 0;
    private static final int[] formatIdArray = new int[]{1, 2, 3, 4};
    private List<AutoBomCalibrationPayload> autoBomCalibrationList = new ArrayList<AutoBomCalibrationPayload>();

    public void addAutoBomCalibrationPayload(AutoBomCalibrationPayload addPayload) {
        this.autoBomCalibrationList.add(addPayload);
    }

    public void removeAutoBomCalibrationPayload(int index) {
        this.autoBomCalibrationList.remove(index);
    }

    public void removeAllAutoBomCalibrationPayload() {
        this.autoBomCalibrationList.clear();
    }

    public AutoBomCalibrationPayload getAutoBomCalibrationPayload(int index) {
        return this.autoBomCalibrationList.get(index);
    }

    public int getAutoBomCalibrationPayloadTotalCount() {
        return this.autoBomCalibrationList.size();
    }

    public static int[] getAllSupportFormatId() {
        return formatIdArray;
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int _formatID) {
        this._formatID = _formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int _version) {
        this._version = _version;
    }

    public double getEnterThresh() {
        return this._enterThresh;
    }

    public void setEnterThresh(double _enterThresh) {
        this._enterThresh = _enterThresh;
    }

    public double getExitThreshBase() {
        return this._exitThreshBase;
    }

    public void setExitThreshBase(double _exitThreshBase) {
        this._exitThreshBase = _exitThreshBase;
    }

    public double getExitThreshMax() {
        return this._exitThreshMax;
    }

    public void setExitThreshMax(double _exitThreshMax) {
        this._exitThreshMax = _exitThreshMax;
    }

    public double getStepFactor() {
        return this._stepFactor;
    }

    public void setStepFactor(double _stepFactor) {
        this._stepFactor = _stepFactor;
    }

    public short getEnterHysteresis() {
        return this._enterHysteresis;
    }

    public void setEnterHysteresis(short _enterHysteresis) {
        this._enterHysteresis = _enterHysteresis;
    }

    public short getExitHysteresis() {
        return this._exitHysteresis;
    }

    public void setExitHysteresis(short _exitHysteresis) {
        this._exitHysteresis = _exitHysteresis;
    }

    public void setFlag(int flag) {
        this._flag = flag;
    }

    public int getFlag() {
        return this._flag;
    }

    public int getHorizontalTolerance() {
        return this.horizontalTolerance;
    }

    public void setHorizontalTolerance(int horizontalTolerance) {
        this.horizontalTolerance = horizontalTolerance;
    }

    public int getHorizontalValidPlmMode() {
        return this.horizontalValidPlmMode;
    }

    public void setHorizontalValidPlmMode(int horizontalValidPlmMode) {
        this.horizontalValidPlmMode = horizontalValidPlmMode;
    }

    public OnTableDetectionCalibrationPayload() {
    }

    public OnTableDetectionCalibrationPayload(OnTableDetectionCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._enterThresh = other._enterThresh;
        this._exitThreshBase = other._exitThreshBase;
        this._exitThreshMax = other._exitThreshMax;
        this._stepFactor = other._stepFactor;
        this._enterHysteresis = other._enterHysteresis;
        this._exitHysteresis = other._exitHysteresis;
        this._flag = other._flag;
        this.horizontalTolerance = other.horizontalTolerance;
        this.horizontalValidPlmMode = other.horizontalValidPlmMode;
        for (AutoBomCalibrationPayload payload : other.autoBomCalibrationList) {
            this.autoBomCalibrationList.add(new AutoBomCalibrationPayload(payload));
        }
    }

    public OnTableDetectionCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > formatIdArray[formatIdArray.length - 1]) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configuration = reader.readNewField((String)"OnTableDetectionConfiguration", (Node)payloadXmlNode).xmlElement;
        if (this._formatID <= 2) {
            this._enterThresh = (double)reader.readNewField((String)"EnterThresh", (int)4, (boolean)false, (Node)configuration).value / 10000.0;
            this._exitThreshBase = (double)reader.readNewField((String)"ExitThreshBase", (int)4, (boolean)false, (Node)configuration).value / 10000.0;
            this._exitThreshMax = (double)reader.readNewField((String)"ExitThreshMax", (int)4, (boolean)false, (Node)configuration).value / 10000.0;
            this._stepFactor = (double)reader.readNewField((String)"StepFactor", (int)4, (boolean)false, (Node)configuration).value / 10000.0;
            this._enterHysteresis = (short)reader.readNewField((String)"EnterHysteresis", (int)2, (boolean)false, (Node)configuration).value;
            this._exitHysteresis = (short)reader.readNewField((String)"ExitHysteresis", (int)2, (boolean)false, (Node)configuration).value;
        }
        if (this._formatID >= 2) {
            this._flag = (short)reader.readNewField((String)"Flag", (int)1, (boolean)false, (Node)configuration).value;
        }
        if (this._formatID >= 4) {
            this.horizontalTolerance = (short)reader.readNewField((String)"HorizontalTolerance", (int)2, (boolean)true, (Node)configuration).value;
            this.horizontalValidPlmMode = reader.readNewField((String)"horizontalValidPlmMode", (int)4, (boolean)true, (Node)configuration).value;
        }
        if (this._formatID >= 3) {
            int bomCount = reader.readNewField((String)"BomCount", (int)1, (boolean)true, (Node)configuration).value;
            Element calibrationRoot = reader.readNewField((String)"OnTableDetectionCalibration", (Node)payloadXmlNode).xmlElement;
            for (int i = 0; i < bomCount; ++i) {
                AutoBomCalibrationPayload payload = new AutoBomCalibrationPayload();
                Element calibrationElement = reader.readNewField((String)"Calibration", (Node)calibrationRoot).xmlElement;
                Element luidElement = reader.readNewField((String)"Luid", (Node)calibrationElement).xmlElement;
                Common.Field sensorTypeField = reader.readNewField("SensorType", 2, false, luidElement);
                Common.Field SensorVendorField = reader.readNewField("SensorVendorId", 2, false, luidElement);
                Common.Field SensorModelField = reader.readNewField("SensorSubType", 2, false, luidElement);
                Common.Field sensorInstanceField = reader.readNewField("InstanceID", 1, false, luidElement);
                Common.Field sensorFlagsField = reader.readNewField("Flags", 1, false, luidElement);
                Luid luid = new Luid(sensorTypeField.value, SensorModelField.value, SensorVendorField.value, sensorInstanceField.value, sensorFlagsField.value);
                payload.setLuid(luid);
                payload.enterThresh = (double)reader.readNewField((String)"EnterThresh", (int)4, (boolean)false, (Node)calibrationElement).value / 10000.0;
                payload.exitThreshBase = (double)reader.readNewField((String)"ExitThreshBase", (int)4, (boolean)false, (Node)calibrationElement).value / 10000.0;
                payload.exitThreshMax = (double)reader.readNewField((String)"ExitThreshMax", (int)4, (boolean)false, (Node)calibrationElement).value / 10000.0;
                payload.stepFactor = (double)reader.readNewField((String)"StepFactor", (int)4, (boolean)false, (Node)calibrationElement).value / 10000.0;
                payload.enterHysteresis = (short)reader.readNewField((String)"EnterHysteresis", (int)2, (boolean)false, (Node)calibrationElement).value;
                payload.exitHysteresis = (short)reader.readNewField((String)"ExitHysteresis", (int)2, (boolean)false, (Node)calibrationElement).value;
                this.autoBomCalibrationList.add(payload);
            }
        }
    }

    @Override
    public OnTableDetectionCalibrationPayload clone() {
        return new OnTableDetectionCalibrationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configuration = writer.writeNewField((String)"OnTableDetectionConfiguration", (Node)parent).xmlElement;
        if (this._formatID < 3) {
            writer.writeNewField("EnterThresh", 4, (int)Math.ceil(this._enterThresh * 10000.0 - 1.0E-4), (Node)configuration);
            writer.writeNewField("ExitThreshBase", 4, (int)Math.ceil(this._exitThreshBase * 10000.0 - 1.0E-4), (Node)configuration);
            writer.writeNewField("ExitThreshMax", 4, (int)Math.ceil(this._exitThreshMax * 10000.0 - 1.0E-4), (Node)configuration);
            writer.writeNewField("StepFactor", 4, (int)Math.ceil(this._stepFactor * 10000.0 - 1.0E-4), (Node)configuration);
            writer.writeNewField("EnterHysteresis", 2, this._enterHysteresis, (Node)configuration);
            writer.writeNewField("ExitHysteresis", 2, this._exitHysteresis, (Node)configuration);
        }
        if (this._formatID >= 2) {
            writer.writeNewField("Flag", 1, this._flag, (Node)configuration);
        }
        if (this._formatID >= 4) {
            writer.writeNewField("HorizontalTolerance", 2, this.horizontalTolerance, (Node)configuration);
            writer.writeNewField("horizontalValidPlmMode", 4, this.horizontalValidPlmMode, (Node)configuration);
        }
        if (this._formatID >= 3) {
            writer.writeNewField("BomCount", 1, this.autoBomCalibrationList.size(), (Node)configuration);
            Element calibrationRoot = writer.writeNewField((String)"OnTableDetectionCalibration", (Node)configuration).xmlElement;
            for (AutoBomCalibrationPayload payload : this.autoBomCalibrationList) {
                Element calibrationElement = writer.writeNewField((String)"Calibration", (Node)calibrationRoot).xmlElement;
                Element luidElement = writer.writeNewField((String)"Luid", (Node)calibrationElement).xmlElement;
                writer.writeNewField("SensorType", 2, payload.getLuid().getSensorTypeId(), (Node)luidElement);
                writer.writeNewField("SensorVendorId", 2, payload.getLuid().getVendorId(), (Node)luidElement);
                writer.writeNewField("SensorSubType", 2, payload.getLuid().getSensorSubTypeId(), (Node)luidElement);
                writer.writeNewField("InstanceID", 1, payload.getLuid().getInstanceId(), (Node)luidElement);
                writer.writeNewField("Flags", 1, payload.getLuid().getFlags(), (Node)luidElement);
                writer.writeNewField("EnterThresh", 4, (int)Math.ceil(payload.enterThresh * 10000.0 - 1.0E-4), (Node)calibrationElement);
                writer.writeNewField("ExitThreshBase", 4, (int)Math.ceil(payload.exitThreshBase * 10000.0 - 1.0E-4), (Node)calibrationElement);
                writer.writeNewField("ExitThreshMax", 4, (int)Math.ceil(payload.exitThreshMax * 10000.0 - 1.0E-4), (Node)calibrationElement);
                writer.writeNewField("StepFactor", 4, (int)Math.ceil(payload.stepFactor * 10000.0 - 1.0E-4), (Node)calibrationElement);
                writer.writeNewField("EnterHysteresis", 2, payload.enterHysteresis, (Node)calibrationElement);
                writer.writeNewField("ExitHysteresis", 2, payload.exitHysteresis, (Node)calibrationElement);
            }
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    public void setDataFromXalibrationXML(Element calibrationData) {
        this._enterThresh = Double.valueOf(DataStore.getChildNodeByName(calibrationData, "EnterThresh").getTextContent()) / 10000.0;
        this._exitThreshBase = Double.valueOf(DataStore.getChildNodeByName(calibrationData, "ExitThreshBase").getTextContent()) / 10000.0;
        this._exitThreshMax = Double.valueOf(DataStore.getChildNodeByName(calibrationData, "ExitThreshMax").getTextContent()) / 10000.0;
        this._stepFactor = Double.valueOf(DataStore.getChildNodeByName(calibrationData, "StepFactor").getTextContent()) / 10000.0;
        this._enterHysteresis = Integer.valueOf(DataStore.getChildNodeByName(calibrationData, "EnterHysteresis").getTextContent()).shortValue();
        this._exitHysteresis = Integer.valueOf(DataStore.getChildNodeByName(calibrationData, "ExitHysteresis").getTextContent()).shortValue();
        if (this._formatID >= 2) {
            this._flag = Integer.valueOf(DataStore.getChildNodeByName(calibrationData, "Flag").getTextContent()).shortValue();
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof OnTableDetectionCalibrationPayload)) {
            return false;
        }
        OnTableDetectionCalibrationPayload other = (OnTableDetectionCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && Math.abs(this._enterThresh - other._enterThresh) < 1.0E-6 && Math.abs(this._exitThreshBase - other._exitThreshBase) < 1.0E-6 && Math.abs(this._exitThreshMax - other._exitThreshMax) < 1.0E-6 && Math.abs(this._stepFactor - other._stepFactor) < 1.0E-6 && this._enterHysteresis == other._enterHysteresis && this._exitHysteresis == other._exitHysteresis && this._flag == other._flag && this.horizontalTolerance == other.horizontalTolerance && this.horizontalValidPlmMode == other.horizontalValidPlmMode;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
        Issue issue;
        int missingCount = 0;
        int instanceUnmatchCount = 0;
        Luid emptyLuid = new Luid(0, 0, 0, 0, 0);
        for (AutoBomCalibrationPayload payload : this.autoBomCalibrationList) {
            if (!emptyLuid.equals(payload.luid) && !DataStore.getInstance().isSensorExists(payload.luid)) {
                ++missingCount;
            }
            if (emptyLuid.equals(payload.luid) || payload.luid.getInstanceId() == sensor.getLuid().getInstanceId()) continue;
            ++instanceUnmatchCount;
        }
        if (missingCount > 0) {
            issue = new Issue(Issue.IssueType.CRITICAL, sensor);
            if (missingCount == 1) {
                issue.setMessage("There is a missing accelerometer sensor from auto-BOM calibration.");
                issue.description = "You must add this accelerometer sensor or specify another accelerometer sensor.";
            } else {
                issue.setMessage("There are " + missingCount + " missing accelerometer sensors from auto-BOM calibration.");
                issue.description = "You must add these accelerometer sensors or specify other accelerometer sensors.";
            }
            validator.addIssue(issue);
        }
        if (instanceUnmatchCount > 0) {
            issue = new Issue(Issue.IssueType.CRITICAL, sensor);
            issue.setMessage("The instance of accelerometer sensors are different.");
            issue.description = "You must add accelerometer sensor with the same instance or change the instance id of on-table detection sensor.";
            validator.addIssue(issue);
        }
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public class AutoBomCalibrationPayload {
        private Luid luid;
        private double enterThresh = 1.5;
        private double exitThreshBase = 5.0;
        private double exitThreshMax = 15.0;
        private double stepFactor = 0.002;
        private short enterHysteresis = (short)20;
        private short exitHysteresis = 0;

        public AutoBomCalibrationPayload() {
            this.luid = new Luid(0, 0, 0, 0, 0);
        }

        public AutoBomCalibrationPayload(AutoBomCalibrationPayload other) {
            this.luid = new Luid(other.luid);
            this.enterThresh = other.enterThresh;
            this.exitThreshBase = other.exitThreshBase;
            this.exitThreshMax = other.exitThreshMax;
            this.stepFactor = other.stepFactor;
            this.enterHysteresis = other.enterHysteresis;
            this.exitHysteresis = other.exitHysteresis;
        }

        public Luid getLuid() {
            return this.luid;
        }

        public void setLuid(Luid luid) {
            this.luid = luid;
        }

        public double getEnterThresh() {
            return this.enterThresh;
        }

        public void setEnterThresh(double enterThresh) {
            this.enterThresh = enterThresh;
        }

        public double getExitThreshBase() {
            return this.exitThreshBase;
        }

        public void setExitThreshBase(double exitThreshBase) {
            this.exitThreshBase = exitThreshBase;
        }

        public double getExitThreshMax() {
            return this.exitThreshMax;
        }

        public void setExitThreshMax(double exitThreshMax) {
            this.exitThreshMax = exitThreshMax;
        }

        public double getStepFactor() {
            return this.stepFactor;
        }

        public void setStepFactor(double stepFactor) {
            this.stepFactor = stepFactor;
        }

        public short getEnterHysteresis() {
            return this.enterHysteresis;
        }

        public void setEnterHysteresis(short enterHysteresis) {
            this.enterHysteresis = enterHysteresis;
        }

        public short getExitHysteresis() {
            return this.exitHysteresis;
        }

        public void setExitHysteresis(short exitHysteresis) {
            this.exitHysteresis = exitHysteresis;
        }
    }
}

