/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.abstractData;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TVersion
implements Comparable<TVersion> {
    private final int major;
    private final int minor;
    private final int hotfix;
    public static final String SEPARATOR = ".";
    public static final TVersion emptyVersion = new TVersion(0, 0, 0);
    public static final TVersion debugVersion = new TVersion(1, 0, 0);
    public static final int emptySingleVersion = 0;

    public TVersion(int major, int minor, int hotfix, int build) {
        this.major = major;
        this.minor = minor;
        this.hotfix = hotfix;
        this.validate();
    }

    public TVersion(int major, int minor, int hotfix) {
        this(major, minor, hotfix, 0);
    }

    public TVersion(String version) {
        if (version == null) {
            version = "0.0.0";
        }
        int maj = 0;
        int min = 0;
        int hotf = 0;
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            maj = TVersion.parseInt(st.nextToken(), version);
            if (st.hasMoreTokens()) {
                st.nextToken();
                min = TVersion.parseInt(st.nextToken(), version);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    hotf = TVersion.parseInt(st.nextToken(), version);
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("invalid version \"" + version + "\": invalid format");
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": invalid format");
            iae.initCause(e);
            throw iae;
        }
        this.major = maj;
        this.minor = min;
        this.hotfix = hotf;
        this.validate();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getHotfix() {
        return this.hotfix;
    }

    public static TVersion parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        return TVersion.valueOf(version);
    }

    public static TVersion valueOf(String version) {
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new TVersion(version);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.hotfix);
        return result.toString();
    }

    public int hashCode() {
        return this.major * 100 + this.minor * 10 + this.hotfix * 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TVersion)) {
            return false;
        }
        TVersion other = (TVersion)object;
        return this.major == other.major && this.minor == other.minor && this.hotfix == other.hotfix;
    }

    @Override
    public int compareTo(TVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.hotfix - other.hotfix;
        return result;
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": non-numeric \"" + value + "\"");
            iae.initCause(e);
            throw iae;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.minor + "\"");
        }
        if (this.hotfix < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.hotfix + "\"");
        }
    }
}

