/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.project;

import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.ModuleDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;

public class UserModulesManager {
    private List<ModuleEntity> userModules;
    private String fProjectPath;
    private IProject fProject;

    public UserModulesManager(IProject project) {
        this.fProjectPath = project.getLocation().toOSString();
        this.fProject = project;
        this.userModules = new ArrayList<ModuleEntity>();
    }

    public void init() {
        this.clear();
        this.parseModule(this.fProject);
    }

    private void parseModule(IProject project) {
        String modulePath = String.valueOf(this.fProjectPath) + File.separator + "modules";
        Path path = Path.of(modulePath, new String[0]);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<Path> paths = Files.walk(path, 2, new FileVisitOption[0]);){
                List moduleStrList = paths.filter(file -> file.toFile().exists() && file.toFile().isDirectory() && file.resolve("module.json").toFile().exists()).map(file -> file.resolve("module.json").toAbsolutePath().toString()).collect(Collectors.toList());
                ModuleDao _moduleDao = DaoFactory.getDao(ModuleDao.class);
                for (String jsonPath : moduleStrList) {
                    ModuleEntity entity = _moduleDao.getEntityByFilePath(jsonPath);
                    if (entity == null) continue;
                    this.userModules.add(entity);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ISSLogger.e((Exception)e);
        }
    }

    public void clear() {
        this.userModules.clear();
    }

    public void addModule(ModuleEntity newModule) {
        if (!this.userModules.contains(newModule)) {
            this.userModules.add(newModule);
        }
    }

    public void removeModule(ModuleEntity module) {
        if (this.userModules.contains(module)) {
            this.userModules.remove(module);
        }
    }

    public List<SensorDataEntity> getUserSensors() {
        List<SensorDataEntity> ret = this.userModules.stream().filter(module -> module.getSensorBundle() != null).flatMap(module -> module.getSensorBundle().getSensors().stream()).collect(Collectors.toList());
        return ret;
    }

    public List<ModuleEntity> getUserModules() {
        return this.userModules;
    }

    public List<ModuleEntity> getUserLibraries() {
        List<ModuleEntity> ret = this.userModules.stream().filter(module -> module.isLibrary()).collect(Collectors.toList());
        return ret;
    }

    public List<SelectedItemsDataEntity> getUserSelectableItems() {
        ArrayList<SelectedItemsDataEntity> ret = new ArrayList<SelectedItemsDataEntity>();
        ret.addAll(this.getUserSensors());
        ret.addAll(this.getUserLibraries());
        return ret;
    }

    public void updateModule(ModuleEntity toUpdateModule) {
        ModuleEntity originModule = this.userModules.stream().filter(module -> module.getName().equals(toUpdateModule.getName())).findFirst().orElse(null);
        String path = originModule.getJsonFilePath();
        ModuleDao moduleDao = DaoFactory.getDao(ModuleDao.class);
        originModule = moduleDao.getEntityByFilePath(path);
    }

    public ModuleEntity getModuleByName(String name) {
        return this.userModules.stream().filter(me -> me.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

