/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2019 - 2023 Intel Corporation */

#ifndef IG3RDMA_REGS_AVF_H
#define IG3RDMA_REGS_AVF_H

#include "irdma.h"

#define IG3_AVF_CCQPEXTSTATUS 0x8C04
#define IG3_AVF_CCQPEXTSTATUS_RSVD_S 16
#define IG3_AVF_CCQPEXTSTATUS_RSVD GENMASK_ULL(16, 31)
#define IG3_AVF_CCQPEXTSTATUS_DBPT_INDEX_S 0
#define IG3_AVF_CCQPEXTSTATUS_DBPT_INDEX GENMASK_ULL(0, 15)
#define IG3_AVF_CCQPHIGH 0x8C0C
#define IG3_AVF_CCQPHIGH_PECCQPHIGH_S 0
#define IG3_AVF_CCQPHIGH_PECCQPHIGH GENMASK_ULL(0, 31)
#define IG3_AVF_CCQPLOW 0x8C08
#define IG3_AVF_CCQPLOW_PECCQPLOW_S 0
#define IG3_AVF_CCQPLOW_PECCQPLOW GENMASK_ULL(0, 31)
#define IG3_AVF_CCQPSTATUS 0x8C00
#define IG3_AVF_CCQPSTATUS_CCQP_ERR_S 31
#define IG3_AVF_CCQPSTATUS_CCQP_ERR BIT_ULL(31)
#define IG3_AVF_CCQPSTATUS_RSVD2_S 28
#define IG3_AVF_CCQPSTATUS_RSVD2 GENMASK_ULL(28, 30)
#define IG3_AVF_CCQPSTATUS_RDMA_EN_VFS_S 16
#define IG3_AVF_CCQPSTATUS_RDMA_EN_VFS GENMASK_ULL(16, 27)
#define IG3_AVF_CCQPSTATUS_RSVD1_S 7
#define IG3_AVF_CCQPSTATUS_RSVD1 GENMASK_ULL(7, 15)
#define IG3_AVF_CCQPSTATUS_HMC_PROFILE_S 4
#define IG3_AVF_CCQPSTATUS_HMC_PROFILE GENMASK_ULL(4, 6)
#define IG3_AVF_CCQPSTATUS_RSVD0_S 1
#define IG3_AVF_CCQPSTATUS_RSVD0 GENMASK_ULL(1, 3)
#define IG3_AVF_CCQPSTATUS_CCQP_DONE_S 0
#define IG3_AVF_CCQPSTATUS_CCQP_DONE BIT_ULL(31)
#define IG3_AVF_CQPDB 0x8C14
#define IG3_AVF_CQPDB_RSVD_S 11
#define IG3_AVF_CQPDB_RSVD GENMASK_ULL(11, 31)
#define IG3_AVF_CQPDB_WQHEAD_S 0
#define IG3_AVF_CQPDB_WQHEAD GENMASK_ULL(0, 10)
#define IG3_AVF_CQPERRCODES 0x8C10
#define IG3_AVF_CQPERRCODES_CQP_MAJOR_CODE_S 16
#define IG3_AVF_CQPERRCODES_CQP_MAJOR_CODE GENMASK_ULL(16, 31)
#define IG3_AVF_CQPERRCODES_CQP_MINOR_CODE_S 0
#define IG3_AVF_CQPERRCODES_CQP_MINOR_CODE GENMASK_ULL(0, 15)
#define IG3_AVF_CQPTAIL 0x8C18
#define IG3_AVF_CQPTAIL_CQP_OP_ERR_S 31
#define IG3_AVF_CQPTAIL_CQP_OP_ERR BIT_ULL(31)
#define IG3_AVF_CQPTAIL_RSVD_S 11
#define IG3_AVF_CQPTAIL_RSVD GENMASK_ULL(11, 30)
#define IG3_AVF_CQPTAIL_WQTAIL_S 0
#define IG3_AVF_CQPTAIL_WQTAIL GENMASK_ULL(0, 10)
#define IG3_AVF_IPCONFIG0 0x8C20
#define IG3_AVF_IPCONFIG0_RSVD_S 18
#define IG3_AVF_IPCONFIG0_RSVD GENMASK_ULL(18, 31)
#define IG3_AVF_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S 17
#define IG3_AVF_IPCONFIG0_UDP_SRC_PORT_MASK_EN BIT_ULL(31)
#define IG3_AVF_IPCONFIG0_USEENTIREIDRANGE_S 16
#define IG3_AVF_IPCONFIG0_USEENTIREIDRANGE BIT_ULL(31)
#define IG3_AVF_IPCONFIG0_PEIPID_S 0
#define IG3_AVF_IPCONFIG0_PEIPID GENMASK_ULL(0, 15)
#define IG3_AVF_TCPNOWTIMER 0x8C1C
#define IG3_AVF_TCPNOWTIMER_TCP_NOW_S 0
#define IG3_AVF_TCPNOWTIMER_TCP_NOW GENMASK_ULL(0, 31)
#define IG3_AVF_DBL_AEQALLOC 0x100C0
#define IG3_AVF_DBL_AEQALLOC_AECOUNT_S 0
#define IG3_AVF_DBL_AEQALLOC_AECOUNT GENMASK_ULL(0, 31)
#define IG3_AVF_DBL_AEQITRMASK 0x10C00
#define IG3_AVF_DBL_AEQITRMASK_RESERVED_S 1
#define IG3_AVF_DBL_AEQITRMASK_RESERVED GENMASK_ULL(1, 31)
#define IG3_AVF_DBL_AEQITRMASK_AEQ_ITR_MASK_S 0
#define IG3_AVF_DBL_AEQITRMASK_AEQ_ITR_MASK BIT_ULL(31)
#define IG3_AVF_DBL_CEQITRMASK 0x10800
#define IG3_AVF_DBL_CEQITRMASK_CEQ_ITR_MASK_S 31
#define IG3_AVF_DBL_CEQITRMASK_CEQ_ITR_MASK BIT_ULL(31)
#define IG3_AVF_DBL_CEQITRMASK_RESERVED2_S 12
#define IG3_AVF_DBL_CEQITRMASK_RESERVED2 GENMASK_ULL(12, 30)
#define IG3_AVF_DBL_CEQITRMASK_CEQINDEX_S 0
#define IG3_AVF_DBL_CEQITRMASK_CEQINDEX GENMASK_ULL(0, 11)
#define IG3_AVF_DBL_CQACK 0x10400
#define IG3_AVF_DBL_CQACK_RSVD_S 25
#define IG3_AVF_DBL_CQACK_RSVD GENMASK_ULL(25, 31)
#define IG3_AVF_DBL_CQACK_PECQID_S 0
#define IG3_AVF_DBL_CQACK_PECQID GENMASK_ULL(0, 24)
#define IG3_AVF_DBL_CQARM 0x10040
#define IG3_AVF_DBL_CQARM_RSVD_S 25
#define IG3_AVF_DBL_CQARM_RSVD GENMASK_ULL(25, 31)
#define IG3_AVF_DBL_CQARM_PECQID_S 0
#define IG3_AVF_DBL_CQARM_PECQID GENMASK_ULL(0, 24)
#define IG3_AVF_DBL_CQPDB 0x10100
#define IG3_AVF_DBL_CQPDB_RSVD_S 11
#define IG3_AVF_DBL_CQPDB_RSVD GENMASK_ULL(11, 31)
#define IG3_AVF_DBL_CQPDB_CQPHEAD_S 0
#define IG3_AVF_DBL_CQPDB_CQPHEAD GENMASK_ULL(0, 10)
#define IG3_AVF_DBL_WQEALLOC 0x10000
#define IG3_AVF_DBL_WQEALLOC_WQE_DESC_INDEX_S 20
#define IG3_AVF_DBL_WQEALLOC_WQE_DESC_INDEX GENMASK_ULL(20, 31)
#define IG3_AVF_DBL_WQEALLOC_PEQPID_S 0
#define IG3_AVF_DBL_WQEALLOC_PEQPID GENMASK_ULL(0, 19)

#endif /* IG3RDMA_REGS_AVF_H */
