%define driver iavf
Name:    %driver-kmp
Summary: Intel(R) Ethernet Adaptive Virtual Function Driver
Version: 4.13.20
Release: 1.sles15sp7
Source0: %{name}-%{version}.tar.bz2
Source1: kmp.filelist
License: GPL-2.0
Vendor: Intel Corporation
Group: System/Kernel
URL: http://support.intel.com
BuildRequires: %kernel_module_package_buildreqs pciutils-ids dracut
Requires: pciutils-ids
BuildRoot: %{_tmppath}/%{name}-%{version}-build

%define debug_package %{nil}
%global __strip /bin/true

%kernel_module_package -x rt -n %driver -f %SOURCE1 -b

%description
This package contains the Intel(R) Ethernet Adaptive Virtual Function Driver.

%prep
%setup -q
gzip %driver.7
set -- *
mkdir source
mv "$@" source/.
echo "iavf.ko external" > source/Module.supported
mkdir obj

%build
for flavor in %flavors_to_build; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	make -C %{kernel_source $flavor} modules M=$PWD/obj/$flavor/src -j55
done

%install
install -D -m 0644 source/*7.gz -t $RPM_BUILD_ROOT/%{_mandir}/man7
install -D -m 0644 source/pci.updates \
	$RPM_BUILD_ROOT/usr/share/pci.ids.d/pci.ids.%{name}-%{version}

export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
	make -C %{kernel_source $flavor} modules_install M=$PWD/obj/$flavor/src
done
if [ -d %{buildroot}/usr/lib/modules ]; then
	lib_modules=%{buildroot}/usr/lib/modules
else
	lib_modules=%{buildroot}/lib/modules
fi
for flavor in %flavors_to_build; do
	export _ksrc=%{kernel_source $flavor}
	cd $lib_modules/%(uname -r | cut -d- -f-2)-$flavor
	# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile ${_ksrc}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=${_ksrc} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif
done
%{expand:%(
for flavor in %flavors_to_build; do
echo "%triggerin -n %{name}-$flavor -- %{name}-$flavor"
echo "/usr/bin/merge-pciids"
done
)}
