/* hwInterface.h */

/***********************************************************************
*                    Copyright Aquantia Corporation
*                                Freeware
*
* $File: //depot/icm/proj/Atlantic/rev1.0/software/Software/Test/MBU-dependencies/hwInterface/include/hwInterface.h $
*
* $Revision: #4 $
*
* $DateTime: 2016/10/19 12:45:44 $
*
* $Author: epomozov $
*
* $Label:  $
*
***********************************************************************/


/*! \file
    This file contains the function prototypes for interfacing with system hardware boards.  It defines the two MDIO
    read and write functions (AQ1001_API_MDIO_Write() and AQ1001_API_MDIO_Read()). This is an abstraction layer which
    requires that the functions defined here be filled in for the specified systems.
    
*/




#ifndef HW_INTERFACE_TOKEN
#define HW_INTERFACE_TOKEN
#ifdef WIN32
#include <windows.h>
#endif
/*#include "simpleControl.h"*/
#ifndef NOPYTHON
  #include <Python.h>
#endif
#include <stdint.h>
#include <string.h>
#include <stdlib.h>

#ifdef __APPLE__ // OSX-specific
#include <strings.h>
#endif // __APPLE__

#ifndef DLLEXPORT
#ifdef WIN32
#define DLLEXPORT __declspec(dllexport)
#else
#define DLLEXPORT
#endif
#endif

#ifdef __cplusplus
  extern "C" {
#endif

/*! \defgroup HW_Interface HW Interface
This module contains the function prototypes for interfacing with system hardware
 @{*/



/*! This function performs the initialization of the system to determine the list of devices.  Successful
    initialization returns 1, and failure (more than 16 devices) returns 0 */
DLLEXPORT uint32_t HW_Initialize(void);

/*! This function set the callback to call critical hardware exception */
#ifndef NOPYTHON
DLLEXPORT void HW_SetExceptionObject( PyObject * exceptionObject );
#endif

/*! This function returns the number of boards in the system */
DLLEXPORT uint32_t HW_NumberOfDevices(void);

/*! This function returns the list of board names in the system */
DLLEXPORT char** HW_DeviceList (void);

/*! This function returns an internal adapter name from the list of adapters in the system */
DLLEXPORT char* HW_Device
(
const uint32_t adapterNumber    /*!< The number of the adapter */
);

/*! This function returns an NAL adapter name from the list of adapters in the system */
DLLEXPORT char* HW_Device_FullName
(
const uint32_t adapterNumber    /*!< The number of the adapter */
);

/*! This function returns an Revision of adapter from the list of adapters in the system */
DLLEXPORT char* HW_Device_Revision
(
const uint32_t adapterNumber    /*!< The number of the adapter */
);
/*! This function opens the interface to the named board.  If the board's name is the NULL string, the first board
    in the list is opened. A return value of 1 signifies success, and 0 signifies failure. */
DLLEXPORT uint32_t HW_Open
(
  const char* boardName          /*!< The name of the board to open.  A NULL string opens the first board in the list. */
);

/*! This function closes the interface to the board */
DLLEXPORT void HW_Close (void);

/*! This function set the device specific parameters. */
DLLEXPORT void HW_SetDeviceParameters( uint32_t adapterNumber, uint32_t param, uint32_t value );

/*! This function set the device specific register address for define hot unplug. */
DLLEXPORT uint32_t HW_GetDeviceParameters( uint32_t adapterNumber, uint32_t param );
/*@}*/

enum GlobalParameters
{
  /*! The maximum number of block read requests that can be issued before execution of the block read */
  MAX_BLOCK_OPERATION_SIZE = 1024,
};
      
#ifdef __cplusplus
  }
#endif

#endif
