/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.common.utils.WinRegistry;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CUtils {
    private static final Pattern IP_Pattern = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static String _fdkBuildVersion = "";
    private static IWorkbenchPart activePart;
    private static IWorkbenchPage activePage;
    private static IWorkbenchWindow activeWindow;
    private static IEditorPart activeEditor;
    private static int buttonWidth;

    static {
        buttonWidth = 0;
    }

    public static boolean isValidIP(String ip) {
        return IP_Pattern.matcher(ip).matches();
    }

    public static boolean isHexadecimal(String text) {
        if (text.trim().isEmpty()) {
            return false;
        }
        try {
            int num = Integer.parseInt(text, 16);
            return num >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getEnvVar(String varName) {
        String envVar = "";
        try {
            envVar = WinRegistry.readString(-2147483647, "Environment", varName);
            if (envVar == null) {
                envVar = WinRegistry.readString(-2147483646, "Environment", varName);
            }
            if (envVar == null) {
                envVar = System.getenv(varName);
            }
        }
        catch (Exception e) {
            ISSLogger.e(e);
        }
        return envVar;
    }

    public static String getArgValueFromArgs(String[] args, String argName, boolean hasValue) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (hasValue) {
                if (arg.toLowerCase().startsWith("-" + argName.toLowerCase() + "=")) {
                    return arg.substring(arg.indexOf("=") + 1);
                }
            } else if (arg.toLowerCase().startsWith("-" + argName.toLowerCase())) {
                return Boolean.TRUE.toString().toLowerCase();
            }
            ++n2;
        }
        if (hasValue) {
            return "";
        }
        return Boolean.FALSE.toString().toLowerCase();
    }

    private static String getVersionFieldFromDefaultVersionsFile(String field) throws IOException, Exception {
        String line;
        File f = new File(String.valueOf(ManagerFileUtils.getFDKDir()) + File.separator + ManagerFileUtils.VERSIONS_FILE());
        BufferedReader buf = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(f))));
        String versionField = "";
        while ((line = buf.readLine()) != null) {
            if (!line.contains(String.valueOf(field) + ":")) continue;
            versionField = line.replace(String.valueOf(field) + ":", "").trim();
            break;
        }
        buf.close();
        return versionField;
    }

    public static String getDefaultBuildFdkVersion() throws IOException, Exception {
        if (_fdkBuildVersion.isEmpty()) {
            _fdkBuildVersion = CUtils.getVersionFieldFromDefaultVersionsFile("Release version");
        }
        return _fdkBuildVersion;
    }

    public static String getFdkVersion() throws IOException, Exception {
        return CUtils.getVersionFieldFromDefaultVersionsFile("Release version");
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int index = string.lastIndexOf(toReplace);
        if (index < 0) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replacement + string.substring(index + toReplace.length());
    }

    public static ManagerEnums.NAMING_ERROR isLegalIdentifierString(String str, boolean enableSpace) {
        String[] badWords;
        if (str == null || str.length() == 0) {
            return ManagerEnums.NAMING_ERROR.IDENTIFIER_IS_EMPTY;
        }
        if (Character.isDigit(str.charAt(0))) {
            return ManagerEnums.NAMING_ERROR.IDENTIFIER_STARTS_WITH_DIGIT;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return ManagerEnums.NAMING_ERROR.IDENTIFIER_STARTS_WITH_ILLEGAL_CHAR;
        }
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_' && (!enableSpace || ch != ' ') || Character.getType(ch) == 4 || Character.getType(ch) == 5) {
                return ManagerEnums.NAMING_ERROR.IDENTIFIER_CONTAINS_NOT_LETTER_DIGIT;
            }
            ++i;
        }
        String[] stringArray = badWords = new String[]{"auto", "break", "case", "char", "continue", "default", "do", "double", "else", "entry", "extern", "float", "for", "goto", "if", "int", "long", "register", "return", "short", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "while", "enum", "void", "const", "signed", "volatile", "_Packed"};
        int n = badWords.length;
        int n2 = 0;
        while (n2 < n) {
            String badWord = stringArray[n2];
            if (str.equals(badWord)) {
                return ManagerEnums.NAMING_ERROR.IDENTIFIER_IS_RESERVED_WORD;
            }
            ++n2;
        }
        return ManagerEnums.NAMING_ERROR.OK;
    }

    public static String readStreamAsText(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer(8192);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        br.close();
        return sb.toString();
    }

    public static String[] convertStringsListToStringsArray(ArrayList<String> stringsList, boolean sortTheArrary) {
        if (stringsList != null) {
            int index = 0;
            Object[] stringsArray = new String[stringsList.size()];
            for (String str : stringsList) {
                stringsArray[index++] = str;
            }
            if (sortTheArrary) {
                Arrays.sort(stringsArray);
            }
            return stringsArray;
        }
        return null;
    }

    private static int countOccurrenceInString(String stringToSearch, String wholeString) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = wholeString.indexOf(stringToSearch, lastIndex)) == -1) continue;
            ++count;
            lastIndex += stringToSearch.length();
        }
        return count;
    }

    public static boolean isComment(String stringToSearch, String wholeString) {
        String[] lines = wholeString.split("\r\n|\r|\n");
        ArrayList<String> comments = new ArrayList<String>();
        Pattern pattern = Pattern.compile("//.*");
        Matcher matcher = pattern.matcher(wholeString);
        while (matcher.find()) {
            comments.add(matcher.group());
            wholeString = wholeString.replace(matcher.group(), "");
        }
        pattern = Pattern.compile("/\\*.*?\\*/", 40);
        matcher = pattern.matcher(wholeString);
        while (matcher.find()) {
            comments.add(matcher.group());
        }
        int countInOrigional = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains(stringToSearch)) {
                countInOrigional += CUtils.countOccurrenceInString(stringToSearch, line);
            }
            ++n2;
        }
        int countInComments = 0;
        for (String comment : comments) {
            if (!comment.contains(stringToSearch)) continue;
            countInComments += CUtils.countOccurrenceInString(stringToSearch, comment);
        }
        return countInOrigional <= countInComments;
    }

    public static int isLegalModelID(String str) {
        Integer id;
        try {
            id = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (id < 0 || str.startsWith("+")) {
            return -1;
        }
        if (id < 256) {
            return -2;
        }
        if (id > 65535) {
            return -3;
        }
        return 0;
    }

    public static int isLegalVersion(String str) {
        Integer id;
        try {
            id = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (id < 0 || str.startsWith("+")) {
            return -1;
        }
        return 0;
    }

    public static int isLegalSpeed(String str) {
        Integer id;
        try {
            id = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (id <= 0 || str.startsWith("+")) {
            return -1;
        }
        if (id > 20000000) {
            return -1;
        }
        return 0;
    }

    public static boolean isInteger(String text) {
        if (text.trim().isEmpty()) {
            return false;
        }
        if (text.contains("+")) {
            return false;
        }
        try {
            Integer.parseInt(text, 10);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String checkDuplicate(Table tbl, String input, int index, boolean toRemove0xPrefixAndLeadingZerosBeforeCheck) {
        TableItem[] tiArr;
        String ret = null;
        TableItem[] tableItemArray = tiArr = tbl.getItems();
        int n = tiArr.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem element = tableItemArray[n2];
            String existingValue = toRemove0xPrefixAndLeadingZerosBeforeCheck ? element.getText(index).substring(2).replaceFirst("^0+(?!$)", "") : element.getText(index);
            if (existingValue.equalsIgnoreCase(input)) {
                return "Please select a unique ";
            }
            ++n2;
        }
        return ret;
    }

    public static boolean uintCheck(String str, boolean toAllowZero) {
        int num;
        block7: {
            if (str.trim().isEmpty()) {
                return false;
            }
            if (str.contains("+")) {
                return false;
            }
            try {
                num = Integer.parseInt(str);
                if (toAllowZero) break block7;
                if (num < 1) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (num < 0) {
            return false;
        }
        return true;
    }

    public static IPath GetWorkspaceLocation() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getLocation();
    }

    public static void focusProject() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                activeWindow = workbench.getActiveWorkbenchWindow();
                if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                    activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                }
            }
        });
        if (activePart != null) {
            activePart.setFocus();
        }
    }

    public static IProject getCurrentSelectedProject() throws ISSException {
        IEditorInput input;
        ISelection selection;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length == 1) {
            return projects[0];
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                activeWindow = workbench.getActiveWorkbenchWindow();
                if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                    activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                }
            }
        });
        if (activePart == null) {
            throw new ISSException("You must select an ISS project.");
        }
        IProject proj = null;
        if (activePart.getTitle().equals("Project Explorer")) {
            selection = activeWindow.getSelectionService().getSelection();
            proj = CUtils.getProjectFromActivePart(activeWindow, selection);
        } else if (activePart.getTitle().equals("Navigator")) {
            selection = activeWindow.getSelectionService().getSelection("org.eclipse.ui.views.ResourceNavigator");
            proj = CUtils.getProjectFromActivePart(activeWindow, selection);
        }
        if (proj != null) {
            return proj;
        }
        activeEditor = activePage.getActiveEditor();
        if (activeEditor != null && (input = activeEditor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProject();
        }
        throw new ISSException("You must select an ISS project.");
    }

    public static IProject getProjectFromActivePart(IWorkbenchWindow activeWindow, ISelection selection) {
        Object element;
        if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null) {
            if (element instanceof IResource) {
                return ((IResource)element).getProject();
            }
            if (element instanceof CContainer) {
                return ((CContainer)element).getCProject().getProject();
            }
            if (element instanceof TranslationUnit) {
                return ((TranslationUnit)element).getCProject().getProject();
            }
            if (element instanceof IncludeRefContainer) {
                return ((IncludeRefContainer)element).getCProject().getProject();
            }
        }
        return null;
    }

    public static int ShowMessage(String hdr, String msg, int style) {
        Shell shell = new Shell(Display.getCurrent());
        return ExceptionHandler.ShowMessage(shell, hdr, msg, style);
    }

    public static int getButtonWidth(Drawable d) {
        if (buttonWidth == 0) {
            GC gc = new GC(d);
            gc.setFont(JFaceResources.getDialogFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            buttonWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        }
        return buttonWidth;
    }

    public static void sortTableByInteger(Table table) {
        TableItem[] tableItems = table.getItems();
        if (tableItems.length >= 2) {
            int i = 0;
            while (i < tableItems.length - 1) {
                if (Integer.parseInt(tableItems[i].getText()) < Integer.parseInt(tableItems[i + 1].getText())) {
                    String tmp = tableItems[i].getText();
                    tableItems[i].setText(tableItems[i + 1].getText());
                    tableItems[i + 1].setText(tmp);
                }
                ++i;
            }
        }
    }

    public static void sortTableByString(Table table) {
        TableItem[] tableItems = table.getItems();
        if (tableItems.length >= 2) {
            int i = 0;
            while (i < tableItems.length - 1) {
                int j = 1;
                while (j < tableItems.length) {
                    if (tableItems[j - 1].getText(0).compareToIgnoreCase(tableItems[j].getText(0)) > 0) {
                        String tmp = tableItems[j - 1].getText();
                        tableItems[j - 1].setText(tableItems[j].getText());
                        tableItems[j].setText(tmp);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static String getRelativePath(String child, String parent) {
        File pFile = new File(parent);
        File pChild = new File(child);
        String rPath = pFile.toURI().relativize(pChild.toURI()).getPath();
        return rPath;
    }

    public static void refreshProjectTree(IProject project) {
        try {
            project.refreshLocal(2, null);
        }
        catch (Exception exception) {
            ISSLogger.e("Failed to refresh project tree");
        }
    }

    public static boolean isProjectExist(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().toUpperCase().equals(name.toUpperCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void refreshWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (Exception exception) {
            ISSLogger.log(Level.WARNING, "Failed to refresh workspace");
        }
    }

    public static IProject getProjectByName(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().toUpperCase().equals(name.toUpperCase())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isProjectExistInWorkspace(String projectName) {
        String relativePath = "\\" + projectName;
        IPath projectPath = Path.fromOSString((String)relativePath);
        boolean existed = ResourcesPlugin.getWorkspace().getRoot().exists(projectPath);
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath fullPath = workspacePath.append(projectName);
        File file = fullPath.toFile();
        return existed |= file.exists();
    }

    public static void selectProject(ExecutionEvent event, IProject proj) throws PartInitException {
        if (!(HandlerUtil.getCurrentSelection((ExecutionEvent)event) instanceof IStructuredSelection)) {
            CUtils.selectProject(proj);
        }
    }

    public static void selectProject(IProject project) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        String viewId = window.getActivePage().getActivePartReference().getId();
        if (!viewId.equals("org.eclipse.ui.navigator.ProjectExplorer") && !viewId.equals("org.eclipse.ui.views.ResourceNavigator")) {
            viewId = "org.eclipse.ui.navigator.ProjectExplorer";
        }
        ArrayList<IProject> openProjects = new ArrayList<IProject>();
        openProjects.add(project);
        Object[] projectsToSelect = openProjects.toArray();
        IViewPart view = window.getActivePage().showView(viewId);
        view.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(projectsToSelect));
    }

    public static void selectProjectInSeperateThread(final IProject project) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CUtils.selectProject(project);
                }
                catch (PartInitException e) {
                    ISSLogger.w((Exception)((Object)e));
                }
            }
        });
    }
}

