/*
 * Decompiled with CFR 0.152.
 */
package manager.pack.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import manager.pack.data.Dependency;
import manager.pack.data.PackageInfo;
import manager.pack.data.Resource;
import manager.pack.data.SensorInfo;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import manager.utils.ManagerFileUtils;

public class ISSPackage {
    private PackageInfo packageInfo;
    private int state;
    public static final int STATE_INSTALLED = 1;
    public static final int STATE_AVAILABLE = 2;
    public static final int STATE_UNAVAILABLE = -3;
    public static final int STATE_UNINSTALLED = -2;
    public static final int STATE_ALL = 3;
    public static final int STATE_UNKNOW = 0;
    public static final int STATE_ERROR = -1;

    public ISSPackage(PackageInfo pi) {
        this.packageInfo = pi;
        this.state = 0;
    }

    public ISSPackage() {
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public List<SensorInfo> getSensors() {
        if (this.packageInfo.getSensors() == null) {
            return new ArrayList<SensorInfo>();
        }
        return this.packageInfo.getSensors();
    }

    public void setSensors(ArrayList<SensorData> sensors, boolean bind) {
        ArrayList<SensorInfo> sList = new ArrayList<SensorInfo>();
        for (SensorData sd : sensors) {
            SensorInfo sensor = new SensorInfo();
            sensor.setSensorName(sd.getName());
            sensor.setSensorTypeId(sd.getTypeId());
            sensor.setModelId(sd.getModelId());
            sensor.setModelName(sd.getModelName());
            sensor.setISSVersion(Double.toString(sd.getPlatform().getValue()));
            sensor.setBuildNumber(sd.getBuildVersion().toString());
            sensor.setVendorId(sd.getVendorId());
            sensor.setFlags(sd.getFlagsAsInteger());
            sensor.setObjectType(sd.getObjectType().getFriendlyName());
            sensor.setApiVersion(sd.getSensorCoreAPIVersion());
            sensor.setFriendlyName(sd.getFriendlyName());
            if (sd.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY && sd.getInitFunction() == null) {
                sensor.setInitFunction(String.valueOf(sd.getName()) + "_init");
            } else {
                sensor.setInitFunction(sd.getInitFunction());
            }
            sList.add(sensor);
        }
        this.packageInfo.setSensors(sList, bind);
    }

    public String getPackageName() {
        return this.packageInfo.getDefinedPackageName();
    }

    public String getCompressedPackageName() {
        return String.valueOf(this.packageInfo.getDefinedPackageName()) + ".zip";
    }

    public List<Resource> getResources() {
        return this.packageInfo.getResourceList();
    }

    public String getCheckSum() {
        return this.packageInfo.getProperties().getCheckSum();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int st) {
        this.state = st > 0 ? (this.state | st) & 3 : this.state & st & 3;
    }

    public boolean isInstalled() {
        return (this.state & 1) > 0;
    }

    public SensorInfo getSensor(String name) {
        List<SensorInfo> sensors = this.packageInfo.getSensors();
        for (SensorInfo s : sensors) {
            if (!s.getSensorName().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public boolean isAvailabe() {
        return (this.state & 2) > 0;
    }

    public String getInstalledPath(String specificPath) {
        if (this.isInstalled()) {
            if (specificPath != null && !specificPath.isEmpty()) {
                return String.valueOf(specificPath) + File.separator + this.packageInfo.getDefinedPackageName();
            }
            return String.valueOf(ManagerFileUtils.getPackageInstallLocation()) + File.separator + this.packageInfo.getDefinedPackageName();
        }
        return null;
    }

    public String getInstalledPath() {
        return this.getInstalledPath(null);
    }

    public String getInstalledLibraryPath(String fileName, String specificPath) {
        SensorInfo si = this.getSensor(fileName);
        if (si != null) {
            return si.getInstalledSensorLibFile(this.getInstalledPath(specificPath));
        }
        return null;
    }

    public String getInstalledLibraryPath(String fileName) {
        return this.getInstalledLibraryPath(fileName, null);
    }

    public List<Dependency> getResourcesBySensorLibName(String fileName) {
        for (Resource res : this.packageInfo.getResourceList()) {
            if (!res.getResName().equalsIgnoreCase(fileName)) continue;
            return res.getDependences();
        }
        return null;
    }

    public boolean hasLicenseFile() {
        if (this.getPackageInfo() != null) {
            return this.getPackageInfo().hasLicenseFile();
        }
        return false;
    }

    public String getLicenseFilePath() {
        if (this.getPackageInfo() != null) {
            return this.getPackageInfo().getLicenseFilePath();
        }
        return null;
    }
}

