/*
 * Decompiled with CFR 0.152.
 */
package manager.pack.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import manager.pack.data.Dependency;
import manager.sensor.Sensor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Resource {
    @XmlAttribute(name="source")
    private String source;
    @XmlAttribute(name="destination")
    private String destination;
    @XmlAttribute(name="type")
    private String type;
    @XmlAttribute(name="component")
    private String component;
    @XmlAttribute(name="description")
    private String desc;
    @XmlElementWrapper(name="dependencies")
    @XmlElement(name="dependency")
    private List<Dependency> dependences;
    @XmlTransient
    private String localSrc;
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_FILE = "file";
    public static final String COMP_SRC = "src";
    public static final String COMP_LIB = "library";
    public static final String COMP_DOC = "document";
    public static final String COMP_PROJECT = "project";
    public static final String COMP_LICENSE = "license";
    public static final String COMP_OTHER = "other";

    public String getLocalSrc() {
        return this.localSrc;
    }

    public void setLocalSrc(String localSrc) {
        this.localSrc = localSrc;
    }

    public Resource() {
    }

    public Resource(String source, String destination, String type, String component, String desc) {
        this.source = source;
        this.destination = destination;
        this.type = type;
        this.component = component;
        this.desc = desc;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getResName() {
        return this.source.substring(this.component.length() + 1);
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isComponent(String comp) {
        return this.getComponent().equalsIgnoreCase(comp);
    }

    public List<Dependency> getDependences() {
        return this.dependences;
    }

    public void setDependences(List<Dependency> dependences) {
        this.dependences = dependences;
    }

    public static Resource generateSensorRes(Sensor sensor, String sensorComponent) {
        String src;
        String fileName = sensor.getSensorData().getFileName();
        String dest = src = String.valueOf(sensorComponent) + File.separator + fileName;
        return new Resource(src, dest, TYPE_FOLDER, sensorComponent, "sensor desc place");
    }

    public static enum ComponentValues {
        SRC(0, "src", "Source Code"),
        LIB(1, "library", "Sensor Binary"),
        DOC(2, "document", "Document"),
        PROJECT(3, "project", "Sample Project"),
        LICENSE(4, "license", "License File"),
        OTHER(5, "other", "Other");

        private int value;
        private String tagName;
        private String friendlyName;

        private ComponentValues(int value, String tagName, String friendlyName) {
            this.value = value;
            this.tagName = tagName;
            this.friendlyName = friendlyName;
        }

        public int getValue() {
            return this.value;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public static ComponentValues getValueByTagName(String tagName) {
            ComponentValues[] componentValuesArray = ComponentValues.values();
            int n = componentValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentValues cv = componentValuesArray[n2];
                if (cv.tagName.toLowerCase().equals(tagName.toLowerCase())) {
                    return cv;
                }
                ++n2;
            }
            return null;
        }

        public static ComponentValues getValueByFriendlyName(String friendlyName) {
            ComponentValues[] componentValuesArray = ComponentValues.values();
            int n = componentValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentValues cv = componentValuesArray[n2];
                if (cv.friendlyName.toLowerCase().equals(friendlyName.toLowerCase())) {
                    return cv;
                }
                ++n2;
            }
            return null;
        }

        public static String[] getFriendlyNames() {
            ArrayList<String> names = new ArrayList<String>();
            ComponentValues[] componentValuesArray = ComponentValues.values();
            int n = componentValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentValues cv = componentValuesArray[n2];
                names.add(cv.getFriendlyName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }

        public static String[] getTagNames() {
            ArrayList<String> names = new ArrayList<String>();
            ComponentValues[] componentValuesArray = ComponentValues.values();
            int n = componentValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentValues cv = componentValuesArray[n2];
                names.add(cv.getTagName());
                ++n2;
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

