/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanListPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.BeanSetPropertyDecorator;

public class BeanValuePropertyDecorator
extends ValueProperty
implements IBeanValueProperty {
    private final IValueProperty delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanValuePropertyDecorator(IValueProperty delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    protected Object doGetValue(Object source) {
        return this.delegate.getValue(source);
    }

    protected void doSetValue(Object source, Object value) {
        this.delegate.setValue(source, value);
    }

    public IBeanValueProperty value(String propertyName) {
        return this.value(propertyName, null);
    }

    public IBeanValueProperty value(String propertyName, Class valueType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.value(BeanProperties.value(beanClass, propertyName, valueType));
    }

    public IBeanValueProperty value(IBeanValueProperty property) {
        return new BeanValuePropertyDecorator(super.value((IValueProperty)property), property.getPropertyDescriptor());
    }

    public IBeanListProperty list(String propertyName) {
        return this.list(propertyName, null);
    }

    public IBeanListProperty list(String propertyName, Class elementType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.list(BeanProperties.list(beanClass, propertyName, elementType));
    }

    public IBeanListProperty list(IBeanListProperty property) {
        return new BeanListPropertyDecorator(super.list((IListProperty)property), property.getPropertyDescriptor());
    }

    public IBeanSetProperty set(String propertyName) {
        return this.set(propertyName, null);
    }

    public IBeanSetProperty set(String propertyName, Class elementType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.set(BeanProperties.set(beanClass, propertyName, elementType));
    }

    public IBeanSetProperty set(IBeanSetProperty property) {
        return new BeanSetPropertyDecorator(super.set((ISetProperty)property), property.getPropertyDescriptor());
    }

    public IBeanMapProperty map(String propertyName) {
        return this.map(propertyName, null, null);
    }

    public IBeanMapProperty map(String propertyName, Class keyType, Class valueType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.map(BeanProperties.map(beanClass, propertyName, keyType, valueType));
    }

    public IBeanMapProperty map(IBeanMapProperty property) {
        return new BeanMapPropertyDecorator(super.map((IMapProperty)property), property.getPropertyDescriptor());
    }

    public IObservableValue observe(Object source) {
        return new BeanObservableValueDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableValue observe(Realm realm, Object source) {
        return new BeanObservableValueDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public IObservableValue observeDetail(IObservableValue master) {
        return new BeanObservableValueDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public IObservableList observeDetail(IObservableList master) {
        return new BeanObservableListDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public IObservableMap observeDetail(IObservableSet master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public IObservableMap observeDetail(IObservableMap master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

