/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;
import pdtEditor.exceptions.FeatureNotSupportedYetException;

public class PdtPropertiesTable
extends BoardDescriptionTable {
    public static final int BDT_TYPE = 3;
    private static final int LATEST_FORMAT_ID = 0;
    private static final String DEFAULT_PDT_DESCRIPTION = "";
    public static final int PDT_DESCRIPTION_SIZE_FIELD_SIZE = 1;
    public static final int PDT_DESCRIPTION_MAX_LENGTH = 50;
    private int _formatId = 0;
    private String _pdtDescription = "";

    public PdtPropertiesTable() {
        this.setType(3);
    }

    public PdtPropertiesTable(BinReader reader, Element payloadXmlNode) throws FeatureNotSupportedYetException {
        this.setType(3);
        this._formatId = reader.readNewField((String)"Format", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        if (this._formatId > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        Element pdtPropertiesElement = reader.readNewField((String)"PdtProperties", (Node)payloadXmlNode).xmlElement;
        int descriptionSize = reader.readNewField((String)"PdtDescriptionSize", (int)1, (boolean)false, (Node)pdtPropertiesElement).value;
        this._pdtDescription = reader.readString((String)"PdtDescription", (int)descriptionSize, (Node)pdtPropertiesElement).strValue;
        this._formatId = 0;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element bdtElement) {
        writer.writeNewField("Type", 1, this.getType(), (Node)bdtElement);
        Common.Field lengthField = writer.writeNewField("Length", 2, 0, (Node)bdtElement);
        writer.addSizeCounter(lengthField);
        writer.writeNewField("Format", 1, this._formatId, (Node)bdtElement);
        Element pdtPropertiesElement = writer.writeNewField((String)"PdtProperties", (Node)bdtElement).xmlElement;
        writer.writeNewField("PdtDescriptionSize", 1, this._pdtDescription.length(), (Node)pdtPropertiesElement);
        writer.writeNewField("PdtDescription", this._pdtDescription.length(), this._pdtDescription, (Node)pdtPropertiesElement);
        writer.removeSizeCounter(lengthField);
    }

    public String getPdtDescription() {
        return this._pdtDescription;
    }

    public void setPdtDescription(String pdtDescription) {
        this._pdtDescription = pdtDescription;
    }
}

