/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.configuration.DevicePostureConfiguration;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.configurations.DevicePostureConfigurationPayload;
import resources.CustomSpinner;

public class DevicePostureConfigurationModifier {
    protected Shell shell;
    private Display display;
    private DevicePostureConfiguration parent;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private Group grpPlmModeId;
    private Group grpPrimarySdo;
    private Group grpSecondarySdo;
    private Group grpTabletModeSdo;
    private CustomSpinner modeId;
    private Button chkPrimarySdo;
    private Button chkSecondarySdo;
    private Button chkTabletModeSdo;
    private Button chkPlmModeIdGroup;
    private TableItem _currentItem = null;
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 6;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;
    private static final int MIN_MODE_VALUE = 1;
    private static final int MAX_MODE_VALUE = 31;

    public static void main(String[] args) {
        try {
            DevicePostureConfigurationModifier window = new DevicePostureConfigurationModifier(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DevicePostureConfigurationModifier(DevicePostureConfiguration parentWindow, ArrayList<Integer> plmModeIds, TableItem item) {
        this.parent = parentWindow;
        this.modeIdList = plmModeIds;
        this._currentItem = item;
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }

    public String getChildrenCheckboxSelectedText(Composite parentControl) {
        Control[] neighborControls;
        StringBuffer text = new StringBuffer();
        boolean isNeedGetChildrenText = true;
        Control[] child = parentControl.getChildren();
        for (Control control : neighborControls = parentControl.getParent().getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 || ((Button)control).getSelection()) continue;
            text.append("Not Available").append(",");
            isNeedGetChildrenText = false;
            break;
        }
        if (isNeedGetChildrenText) {
            for (Control control : child) {
                if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
                text.append(((Button)control).getText()).append(",");
            }
        }
        if (text.length() > 0) {
            return text.substring(0, text.length() - 1);
        }
        return text.toString();
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        return ret;
    }

    public void save() {
        DevicePostureConfigurationPayload.ConditionTable condition;
        String[] data = new String[]{this.modeId.getText(), this.getChildrenCheckboxSelectedText((Composite)this.grpPlmModeId), this.getChildrenCheckboxSelectedText((Composite)this.grpPrimarySdo), this.getChildrenCheckboxSelectedText((Composite)this.grpSecondarySdo), this.getChildrenCheckboxSelectedText((Composite)this.grpTabletModeSdo)};
        try {
            this.parent.checkNewConfiguration(data);
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Invalid Configuration");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        if (this._currentItem == null) {
            condition = new DevicePostureConfigurationPayload.ConditionTable();
            this.parent.addConfigurationRow(data, condition);
        } else {
            condition = (DevicePostureConfigurationPayload.ConditionTable)this._currentItem.getData();
            this._currentItem.setText(data);
        }
        condition.postureId = Integer.valueOf(this.modeId.getText());
        condition.plmModeId = !this.chkPlmModeIdGroup.getSelection() ? -1 : this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId);
        condition.sdoStatePrimary = !this.chkPrimarySdo.getSelection() ? 255 : this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPrimarySdo);
        condition.sdoStateSecondary = !this.chkSecondarySdo.getSelection() ? 255 : this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpSecondarySdo);
        condition.tabletMode = !this.chkTabletModeSdo.getSelection() ? 255 : this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpTabletModeSdo);
        this.parent.setModified();
        this.shell.close();
    }

    public void fillData() {
        if (this._currentItem == null) {
            return;
        }
        int currentModeId = 0;
        try {
            currentModeId = Integer.parseInt(this._currentItem.getText(0));
        }
        catch (NumberFormatException e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Invalid Mode Id");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
        }
        this.modeId.setSelection(currentModeId);
        this.fillCheckbox((Composite)this.grpPlmModeId, this._currentItem.getText(1));
        this.fillCheckbox((Composite)this.grpPrimarySdo, this._currentItem.getText(2));
        this.fillCheckbox((Composite)this.grpSecondarySdo, this._currentItem.getText(3));
        this.fillCheckbox((Composite)this.grpTabletModeSdo, this._currentItem.getText(4));
    }

    public void fillCheckbox(Composite parentControl, String itemText) {
        if (itemText.compareTo("Not Available") == 0) {
            Control[] neighborControls;
            for (Control control : neighborControls = parentControl.getParent().getChildren()) {
                if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0) continue;
                ((Button)control).setSelection(false);
                this.setChildrenEnable(parentControl, false);
                break;
            }
        } else {
            Control[] child;
            String[] checkValues = itemText.split(",");
            block1: for (Control control : child = parentControl.getChildren()) {
                if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
                ((Button)control).setSelection(false);
                for (String value : checkValues) {
                    if (((Button)control).getText().compareTo(value) != 0) continue;
                    ((Button)control).setSelection(true);
                    continue block1;
                }
            }
        }
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Device Posture Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite cmpModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpModeIdLayout = new FormLayout();
        cmpModeIdLayout.marginWidth = 5;
        cmpModeIdLayout.marginHeight = 5;
        cmpModelId.setLayout((Layout)cmpModeIdLayout);
        cmpModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite cmpModelIdContainer = new Composite(cmpModelId, 4);
        FormData frmDataModelIdContainer = new FormData();
        GridLayout cmpModelIdContainerLayout = new GridLayout(3, false);
        cmpModelIdContainerLayout.verticalSpacing = 15;
        cmpModelIdContainerLayout.horizontalSpacing = 20;
        cmpModelIdContainer.setLayout((Layout)cmpModelIdContainerLayout);
        cmpModelIdContainer.setLayoutData((Object)frmDataModelIdContainer);
        Label lblModeId = new Label(cmpModelIdContainer, 0);
        lblModeId.setText("Mode ID:");
        this.modeId = new CustomSpinner(cmpModelIdContainer, 2048, this.shell);
        this.modeId.setMinimum(1);
        this.modeId.setMaximum(31);
        GridData gd_mode = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_mode.widthHint = GuiUtils.getButtonWidth((Control)this.shell) * 3 / 2;
        this.modeId.setLayoutData(gd_mode);
        Composite cmpPlmModelId = new Composite((Composite)this.shell, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModeIdLayout.marginWidth = 5;
        cmpPlmModeIdLayout.marginHeight = 5;
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(6, false);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DevicePostureConfigurationModifier.this.chkPlmModeIdGroup.getSelection()) {
                    DevicePostureConfigurationModifier.this.setSubCheckboxSelection((Composite)DevicePostureConfigurationModifier.this.grpPlmModeId, false);
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpPlmModeId, false);
                } else {
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpPlmModeId, true);
                }
            }
        });
        Composite cmpPrimarySdo = new Composite((Composite)this.shell, 4);
        FormLayout cmpPrimarySdoLayout = new FormLayout();
        cmpPrimarySdoLayout.marginWidth = 5;
        cmpPrimarySdoLayout.marginHeight = 5;
        cmpPrimarySdo.setLayout((Layout)cmpPrimarySdoLayout);
        this.chkPrimarySdo = new Button(cmpPrimarySdo, 32);
        this.chkPrimarySdo.setText("Primary SDO");
        this.chkPrimarySdo.setSelection(true);
        FormData frmChkDataPrimarySdo = new FormData();
        this.chkPrimarySdo.setLayoutData((Object)frmChkDataPrimarySdo);
        frmChkDataPrimarySdo.left = new FormAttachment();
        frmChkDataPrimarySdo.left.offset = 8;
        this.chkPrimarySdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DevicePostureConfigurationModifier.this.chkPrimarySdo.getSelection()) {
                    DevicePostureConfigurationModifier.this.setSubCheckboxSelection((Composite)DevicePostureConfigurationModifier.this.grpPrimarySdo, false);
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpPrimarySdo, false);
                } else {
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpPrimarySdo, true);
                }
            }
        });
        this.grpPrimarySdo = new Group(cmpPrimarySdo, 4);
        FormData frmDataGrpPrimarySdo = new FormData();
        GridLayout grpPrimarySdoLayout = new GridLayout(3, false);
        grpPrimarySdoLayout.verticalSpacing = 15;
        grpPrimarySdoLayout.horizontalSpacing = 20;
        this.grpPrimarySdo.setLayout((Layout)grpPrimarySdoLayout);
        this.grpPrimarySdo.setLayoutData((Object)frmDataGrpPrimarySdo);
        Button addBtn = new Button((Composite)this.grpPrimarySdo, 32);
        addBtn.setText("Not Rotated");
        addBtn.setData((Object)1);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpPrimarySdo, 32);
        addBtn.setText("Rotated 90");
        addBtn.setData((Object)2);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpPrimarySdo, 32);
        addBtn.setText("Rotated 180");
        addBtn.setData((Object)4);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpPrimarySdo, 32);
        addBtn.setText("Rotated 270");
        addBtn.setData((Object)8);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpPrimarySdo, 32);
        addBtn.setText("Face up");
        addBtn.setData((Object)16);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpPrimarySdo, 32);
        addBtn.setText("Face down");
        addBtn.setData((Object)32);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Composite cmpSecondarySdo = new Composite((Composite)this.shell, 4);
        FormLayout cmpSecondarySdoLayout = new FormLayout();
        cmpSecondarySdoLayout.marginWidth = 5;
        cmpSecondarySdoLayout.marginHeight = 5;
        cmpSecondarySdo.setLayout((Layout)cmpSecondarySdoLayout);
        this.chkSecondarySdo = new Button(cmpSecondarySdo, 32);
        this.chkSecondarySdo.setText("Secondary SDO");
        this.chkSecondarySdo.setSelection(true);
        FormData frmChkDataSecondarySdo = new FormData();
        this.chkSecondarySdo.setLayoutData((Object)frmChkDataSecondarySdo);
        frmChkDataSecondarySdo.left = new FormAttachment();
        frmChkDataSecondarySdo.left.offset = 8;
        this.chkSecondarySdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DevicePostureConfigurationModifier.this.chkSecondarySdo.getSelection()) {
                    DevicePostureConfigurationModifier.this.setSubCheckboxSelection((Composite)DevicePostureConfigurationModifier.this.grpSecondarySdo, false);
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpSecondarySdo, false);
                } else {
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpSecondarySdo, true);
                }
            }
        });
        this.grpSecondarySdo = new Group(cmpSecondarySdo, 4);
        FormData frmDataGrpSecondarySdo = new FormData();
        GridLayout grpSecondarySdoLayout = new GridLayout(3, false);
        grpSecondarySdoLayout.verticalSpacing = 15;
        grpSecondarySdoLayout.horizontalSpacing = 20;
        this.grpSecondarySdo.setLayout((Layout)grpSecondarySdoLayout);
        this.grpSecondarySdo.setLayoutData((Object)frmDataGrpSecondarySdo);
        addBtn = new Button((Composite)this.grpSecondarySdo, 32);
        addBtn.setText("Not Rotated");
        addBtn.setData((Object)1);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpSecondarySdo, 32);
        addBtn.setText("Rotated 90");
        addBtn.setData((Object)2);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpSecondarySdo, 32);
        addBtn.setText("Rotated 180");
        addBtn.setData((Object)4);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpSecondarySdo, 32);
        addBtn.setText("Rotated 270");
        addBtn.setData((Object)8);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpSecondarySdo, 32);
        addBtn.setText("Face up");
        addBtn.setData((Object)16);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpSecondarySdo, 32);
        addBtn.setText("Face down");
        addBtn.setData((Object)32);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Composite cmpTabletModeSdo = new Composite((Composite)this.shell, 4);
        FormLayout cmpTabletModeSdoLayout = new FormLayout();
        cmpTabletModeSdoLayout.marginWidth = 5;
        cmpTabletModeSdoLayout.marginHeight = 5;
        cmpTabletModeSdo.setLayout((Layout)cmpTabletModeSdoLayout);
        this.chkTabletModeSdo = new Button(cmpTabletModeSdo, 32);
        this.chkTabletModeSdo.setText("Tablet Mode");
        this.chkTabletModeSdo.setSelection(true);
        FormData frmChkDataTabletModeSdo = new FormData();
        this.chkTabletModeSdo.setLayoutData((Object)frmChkDataTabletModeSdo);
        frmChkDataTabletModeSdo.left = new FormAttachment();
        frmChkDataTabletModeSdo.left.offset = 8;
        this.chkTabletModeSdo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DevicePostureConfigurationModifier.this.chkTabletModeSdo.getSelection()) {
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpTabletModeSdo, false);
                } else {
                    DevicePostureConfigurationModifier.this.setChildrenEnable((Composite)DevicePostureConfigurationModifier.this.grpTabletModeSdo, true);
                }
            }
        });
        this.grpTabletModeSdo = new Group(cmpTabletModeSdo, 4);
        FormData frmDataGrpTabletModeSdo = new FormData();
        GridLayout grpTabletModeSdoLayout = new GridLayout(4, false);
        grpTabletModeSdoLayout.verticalSpacing = 15;
        grpTabletModeSdoLayout.horizontalSpacing = 20;
        this.grpTabletModeSdo.setLayout((Layout)grpTabletModeSdoLayout);
        this.grpTabletModeSdo.setLayoutData((Object)frmDataGrpTabletModeSdo);
        addBtn = new Button((Composite)this.grpTabletModeSdo, 16);
        addBtn.setText("Yes");
        addBtn.setData((Object)1);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn = new Button((Composite)this.grpTabletModeSdo, 16);
        addBtn.setText("No");
        addBtn.setData((Object)0);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addBtn.setSelection(true);
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DevicePostureConfigurationModifier.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DevicePostureConfigurationModifier.this.shell.close();
            }
        });
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }
}

