/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class SdoConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 103;
    public static final String CALIBRATION_FORMAT_STRING = "Simple Device Orientation Configuration";
    private static final int LATEST_FORMAT_ID = 0;
    private int _formatID = 0;
    private int _version = 0;

    public SdoConfigurationPayload() {
    }

    public SdoConfigurationPayload(SdoConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
    }

    public SdoConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof SdoConfigurationPayload)) {
            return false;
        }
        SdoConfigurationPayload other = (SdoConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version;
    }

    @Override
    public SdoConfigurationPayload clone() {
        return new SdoConfigurationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return true;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

