/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import Jama.Matrix;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.payloads.calibrations.GeneralCalibrationPayload;
import resources.CustomSpinner;
import resources.DoubleHolder;

public class GeneralCalibrationEditor
implements CalibrationEditor {
    private static final int DOUBLE_PRECISION = 4;
    protected Shell shlEditCalibration;
    private Text formatID;
    private Display display;
    private ArrayList<Byte> _tempVendorData = null;
    private CalibrationEditorOpener _parent = null;
    private Sensor _sensor = null;
    private boolean _modified = false;
    private GeneralCalibrationPayload _data = null;
    private DoubleHolder mat33;
    private DoubleHolder mat23;
    private DoubleHolder mat13;
    private DoubleHolder mat12;
    private DoubleHolder mat22;
    private DoubleHolder mat32;
    private DoubleHolder mat31;
    private DoubleHolder mat21;
    private DoubleHolder mat11;
    private CustomSpinner offsetX;
    private CustomSpinner offsetY;
    private CustomSpinner offsetZ;
    private CustomSpinner zx;
    private CustomSpinner zy;
    private CustomSpinner zz;
    private CustomSpinner yz;
    private CustomSpinner yy;
    private CustomSpinner yx;
    private CustomSpinner xx;
    private CustomSpinner xy;
    private CustomSpinner xz;
    private Button btnVenDataBrowse;
    private Button btnVenDataExport;
    private Label lblDataStatus;
    private Button btnClear;
    private Label lblX_1;
    private Label lblY;
    private Label lblZ;
    private Label lblX_2;
    private Label lblY_1;
    private Label lblZ_1;

    public static void main(String[] args) {
        try {
            GeneralCalibrationEditor window = new GeneralCalibrationEditor(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GeneralCalibrationEditor(CalibrationEditorOpener parent, GeneralCalibrationPayload data, Sensor sensor) {
        this._parent = parent;
        this._data = data;
        this._sensor = sensor;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditCalibration.open();
        this.shlEditCalibration.layout();
        while (!this.shlEditCalibration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void exportVendorData() {
        if (this._tempVendorData == null || this._tempVendorData.size() == 0) {
            return;
        }
        FileDialog fd = new FileDialog(this.shlEditCalibration, 8192);
        fd.setText("Export Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        byte[] toWrite = new byte[this._tempVendorData.size()];
        for (int i = 0; i < toWrite.length; ++i) {
            toWrite[i] = this._tempVendorData.get(i);
        }
        try {
            Files.write(Paths.get(path, new String[0]), toWrite, new OpenOption[0]);
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Exporting Vendor Data");
            messageBox.setMessage("Exporting The Vendor Data Failed");
            messageBox.open();
        }
    }

    @Override
    public String getCalibrationFormatName() {
        return "Intel 3D Motion Sensor Calibration";
    }

    public void browseVendorData() {
        if (this._tempVendorData != null && this._tempVendorData.size() > 0) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 296);
            messageBox.setText("Loading New Vendor Defined Data");
            messageBox.setMessage("Loading new data will override the old one. Do you want to continue?");
            if (messageBox.open() != 32) {
                return;
            }
        }
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        } else {
            this._tempVendorData.clear();
        }
        this._tempVendorData.clear();
        FileDialog fd = new FileDialog(this.shlEditCalibration, 4096);
        fd.setText("Import Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            byte[] binaryData = Files.readAllBytes(Paths.get(path, new String[0]));
            for (int i = 0; i < binaryData.length; ++i) {
                this._tempVendorData.add(binaryData[i]);
            }
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Loading Failed");
            messageBox.setMessage("The loading of the new data failed");
        }
        this.updateVendorDataComponents();
        this._modified = true;
    }

    public void updateVendorDataComponents() {
        if (this._tempVendorData != null && this._tempVendorData.size() > 0) {
            this.lblDataStatus.setText("Contains Data");
            this.btnVenDataExport.setEnabled(true);
            this.btnClear.setEnabled(true);
        } else {
            this.lblDataStatus.setText("No Data");
            this.btnVenDataExport.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    public void checkInput() {
        if (this.mat11.getValue() == 0.0 && this.mat12.getValue() == 0.0 && this.mat13.getValue() == 0.0 || this.mat21.getValue() == 0.0 && this.mat22.getValue() == 0.0 && this.mat23.getValue() == 0.0 || this.mat31.getValue() == 0.0 && this.mat32.getValue() == 0.0 && this.mat33.getValue() == 0.0) {
            throw new RuntimeException("The scaling matrix cannot hold a line of zeros");
        }
        if (this.xx.getSelection() == 0 && this.xy.getSelection() == 0 && this.xz.getSelection() == 0 || this.yx.getSelection() == 0 && this.yy.getSelection() == 0 && this.yz.getSelection() == 0 || this.zx.getSelection() == 0 && this.zy.getSelection() == 0 && this.zz.getSelection() == 0) {
            throw new RuntimeException("The axis mapping matrix cannot hold a line of zeros");
        }
    }

    public void saveData() {
        double[][] axisMappingMatrix;
        boolean newCalibration = false;
        try {
            this.checkInput();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Invalid Input");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        GeneralCalibrationPayload data = this._data;
        if (data == null) {
            data = new GeneralCalibrationPayload();
            newCalibration = true;
        }
        data.setFormatID(Integer.valueOf(this.formatID.getText()));
        double[][] matrix = new double[][]{{this.mat11.getValue(), this.mat12.getValue(), this.mat13.getValue()}, {this.mat21.getValue(), this.mat22.getValue(), this.mat23.getValue()}, {this.mat31.getValue(), this.mat32.getValue(), this.mat33.getValue()}};
        if (!GeneralCalibrationPayload.isValidScalingMatrix(new Matrix((double[][])matrix))) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 296);
            messageBox.setText("Bad Scaling and Rotation Matrix Values");
            messageBox.setMessage("The values you entered in the Scaling and Rotation Matrix could not have been outputted by Intel's Calibration Tool. An invalid matrix will result in data loss.\n\nWe recommend that you click Cancel and double-check the values.");
            if (messageBox.open() != 32) {
                return;
            }
        }
        if (!GeneralCalibrationPayload.isValidAxisMapping(new Matrix((double[][])(axisMappingMatrix = new double[][]{{this.xx.getSelection(), this.xy.getSelection(), this.xz.getSelection()}, {this.yx.getSelection(), this.yy.getSelection(), this.yz.getSelection()}, {this.zx.getSelection(), this.zy.getSelection(), this.zz.getSelection()}})))) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 296);
            messageBox.setText("Bad Axis Mapping Values");
            messageBox.setMessage("The values you entered in the axis mapping matrix are invalid and will result in data loss. Each row and column in the matrix must contain two elements equal to 0 and one element equal to 1 or -1.\n\nClick Cancel to return to the window and fix the issue.");
            if (messageBox.open() != 32) {
                return;
            }
        }
        HashMap<String, Double> matrixValues = new HashMap<String, Double>();
        matrixValues.put("Mat11", this.mat11.getValue());
        matrixValues.put("Mat12", this.mat12.getValue());
        matrixValues.put("Mat13", this.mat13.getValue());
        matrixValues.put("Mat21", this.mat21.getValue());
        matrixValues.put("Mat22", this.mat22.getValue());
        matrixValues.put("Mat23", this.mat23.getValue());
        matrixValues.put("Mat31", this.mat31.getValue());
        matrixValues.put("Mat32", this.mat32.getValue());
        matrixValues.put("Mat33", this.mat33.getValue());
        data.setFractionalMatrix(matrixValues);
        data.getOffset().put("OffsetX", this.offsetX.getSelection());
        data.getOffset().put("OffsetY", this.offsetY.getSelection());
        data.getOffset().put("OffsetZ", this.offsetZ.getSelection());
        HashMap<String, Integer> axisMapping = new HashMap<String, Integer>();
        axisMapping.put("XX", this.xx.getSelection());
        axisMapping.put("XY", this.xy.getSelection());
        axisMapping.put("XZ", this.xz.getSelection());
        axisMapping.put("YX", this.yx.getSelection());
        axisMapping.put("YY", this.yy.getSelection());
        axisMapping.put("YZ", this.yz.getSelection());
        axisMapping.put("ZX", this.zx.getSelection());
        axisMapping.put("ZY", this.zy.getSelection());
        axisMapping.put("ZZ", this.zz.getSelection());
        try {
            data.setAxisMapping(axisMapping);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        }
        data.setVendorDefinedData(this._tempVendorData);
        if (this._parent != null) {
            if (newCalibration) {
                this._parent.addNewCalibration(this._sensor, data);
            }
            this._parent.refreshCalibrationData();
            this._parent.setModified();
        }
        this._data = data;
        this._modified = false;
        this.shlEditCalibration.close();
    }

    public void fillData() {
        if (this._data == null) {
            this.formatID.setText("0");
            this.mat11.setValue(1.0);
            this.mat12.setValue(0.0);
            this.mat13.setValue(0.0);
            this.mat21.setValue(0.0);
            this.mat22.setValue(1.0);
            this.mat23.setValue(0.0);
            this.mat31.setValue(0.0);
            this.mat32.setValue(0.0);
            this.mat33.setValue(1.0);
            this.offsetX.setSelection(0);
            this.offsetY.setSelection(0);
            this.offsetZ.setSelection(0);
            this.xx.setSelection(1);
            this.xy.setSelection(0);
            this.xz.setSelection(0);
            this.yx.setSelection(0);
            this.yy.setSelection(1);
            this.yz.setSelection(0);
            this.zx.setSelection(0);
            this.zy.setSelection(0);
            this.zz.setSelection(1);
            this._modified = false;
            return;
        }
        this.formatID.setText(String.valueOf(this._data.getFormatID()));
        this.mat11.setValue(this._data.getFractionalMatrix().getOrDefault("Mat11", 0.0));
        this.mat12.setValue(this._data.getFractionalMatrix().getOrDefault("Mat12", 0.0));
        this.mat13.setValue(this._data.getFractionalMatrix().getOrDefault("Mat13", 0.0));
        this.mat21.setValue(this._data.getFractionalMatrix().getOrDefault("Mat21", 0.0));
        this.mat22.setValue(this._data.getFractionalMatrix().getOrDefault("Mat22", 0.0));
        this.mat23.setValue(this._data.getFractionalMatrix().getOrDefault("Mat23", 0.0));
        this.mat31.setValue(this._data.getFractionalMatrix().getOrDefault("Mat31", 0.0));
        this.mat32.setValue(this._data.getFractionalMatrix().getOrDefault("Mat32", 0.0));
        this.mat33.setValue(this._data.getFractionalMatrix().getOrDefault("Mat33", 0.0));
        this.offsetX.setSelection(this._data.getOffset().getOrDefault("OffsetX", 0));
        this.offsetY.setSelection(this._data.getOffset().getOrDefault("OffsetY", 0));
        this.offsetZ.setSelection(this._data.getOffset().getOrDefault("OffsetZ", 0));
        this.xx.setSelection(this._data.getAxisMappingTable().getOrDefault("XX", 0));
        this.xy.setSelection(this._data.getAxisMappingTable().getOrDefault("XY", 0));
        this.xz.setSelection(this._data.getAxisMappingTable().getOrDefault("XZ", 0));
        this.yx.setSelection(this._data.getAxisMappingTable().getOrDefault("YX", 0));
        this.yy.setSelection(this._data.getAxisMappingTable().getOrDefault("YY", 0));
        this.yz.setSelection(this._data.getAxisMappingTable().getOrDefault("YZ", 0));
        this.zx.setSelection(this._data.getAxisMappingTable().getOrDefault("ZX", 0));
        this.zy.setSelection(this._data.getAxisMappingTable().getOrDefault("ZY", 0));
        this.zz.setSelection(this._data.getAxisMappingTable().getOrDefault("ZZ", 0));
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        }
        this._tempVendorData.clear();
        if (this._data.getVendorDefinedData() != null) {
            for (Byte oneByte : this._data.getVendorDefinedData()) {
                this._tempVendorData.add(oneByte);
            }
        }
        this.updateVendorDataComponents();
        this._modified = false;
    }

    public String getOffsetUnits() {
        if (this._sensor == null) {
            return "";
        }
        switch (this._sensor.getLuid().getSensorTypeId()) {
            case 115: {
                return "microg\u2080";
            }
            case 118: {
                return "10^-5 dps";
            }
            case 527: {
                return "microGauss";
            }
        }
        return "";
    }

    protected void createContents() {
        this.shlEditCalibration = new Shell(65760);
        this.shlEditCalibration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (GeneralCalibrationEditor.this._modified) {
                    MessageBox messageBox = new MessageBox(GeneralCalibrationEditor.this.shlEditCalibration, 296);
                    messageBox.setText("Closing The 'Edit Calibration' Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the 'Calibration Modifier' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditCalibration.setImage(SWTResourceManager.getImage(GeneralCalibrationEditor.class, "/resources/Intel.ico"));
        this.shlEditCalibration.setText("Calibration Modifier");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditCalibration, 1);
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shlEditCalibration, 0, 4, 4, true, false, 1, 1, 2);
        Label lblCalibrationFormatId = GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.formatID = GuiUtils.addTextToComposite((Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpScaling = GuiUtils.addGroupToComposite("Scaling and Rotation", (Composite)this.shlEditCalibration, 0, 4, 4, true, false, 1, 1, 3);
        Group grpMatrix = GuiUtils.addGroupToComposite("Matrix", (Composite)grpScaling, 0, 4, 4, true, false, 1, 1, 3);
        this.mat11 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat12 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat13 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat21 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat22 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat23 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat31 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat32 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        this.mat33 = GuiUtils.addDoubleHolderToComposite(-10, 10, 4, this.shlEditCalibration, (Composite)grpMatrix, 2048, 16384, 0x1000000, false, false, 1, 1);
        Label label = GuiUtils.addLabelToComposite("+", (Composite)grpScaling, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        Group grpOffset = GuiUtils.addGroupToComposite("Offset" + (this.getOffsetUnits().length() > 0 ? " (" + this.getOffsetUnits() + ")" : ""), (Composite)grpScaling, 0, 4, 4, true, false, 1, 1, 1);
        this.offsetX = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shlEditCalibration, (Composite)grpOffset, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.offsetY = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shlEditCalibration, (Composite)grpOffset, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.offsetZ = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shlEditCalibration, (Composite)grpOffset, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpAxisMapping = GuiUtils.addGroupToComposite("Axis Mapping", (Composite)this.shlEditCalibration, 0, 4, 0x1000000, true, false, 1, 1, 1);
        Composite composite = GuiUtils.addCompositeToComposite((Composite)grpAxisMapping, 0, 0x1000000, 0x1000000, true, true, 1, 3, 4);
        GuiUtils.addLabelToComposite("", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.lblX_2 = GuiUtils.addLabelToComposite("X", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.lblY_1 = GuiUtils.addLabelToComposite("Y", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.lblZ_1 = GuiUtils.addLabelToComposite("Z", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.lblX_1 = GuiUtils.addLabelToComposite("X =", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.xx = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.xy = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.xz = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.lblY = GuiUtils.addLabelToComposite("Y =", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.yx = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.yy = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.yz = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.lblZ = GuiUtils.addLabelToComposite("Z =", composite, 0, 0x1000000, 0x1000000, false, false, 1, 1);
        this.zx = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.zy = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.zz = GuiUtils.addCustomSpinnerToComposite(1, this.shlEditCalibration, composite, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpVendorDefinedData = GuiUtils.addGroupToComposite("Vendor-Defined Data", (Composite)this.shlEditCalibration, 0, 4, 0x1000000, true, false, 1, 1, 1);
        this.lblDataStatus = GuiUtils.addLabelToComposite("No Data", (Composite)grpVendorDefinedData, 0, 16384, 0x1000000, false, false, 3, 1);
        Composite compositeVendorDefined = GuiUtils.addCompositeToComposite((Composite)grpVendorDefinedData, 0, 16384, 0x1000000, true, true, 1, 3, 3);
        this.btnVenDataBrowse = GuiUtils.addButtonToComposite("Browse", "", compositeVendorDefined, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnVenDataExport = GuiUtils.addButtonToComposite("Export", "", compositeVendorDefined, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnClear = GuiUtils.addButtonToComposite("Clear", "", compositeVendorDefined, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditCalibration, 0, 131072, 0x1000000, true, true, 1, 3, 3);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeButton, 0, 16384, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeButton, 0, 16384, 0x1000000, true, false, 1, 1);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralCalibrationEditor.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralCalibrationEditor.this.shlEditCalibration.close();
            }
        });
        this.btnVenDataBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralCalibrationEditor.this.browseVendorData();
            }
        });
        this.btnVenDataExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralCalibrationEditor.this.exportVendorData();
            }
        });
        this.btnVenDataExport.setEnabled(false);
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralCalibrationEditor.this._tempVendorData != null && GeneralCalibrationEditor.this._tempVendorData.size() > 0) {
                    MessageBox messageBox = new MessageBox(GeneralCalibrationEditor.this.shlEditCalibration, 296);
                    messageBox.setText("Clearing The Vendor Defined Data");
                    messageBox.setMessage("You are about to clear the vendor defined data. Do you want to continue?");
                    if (messageBox.open() != 32) {
                        return;
                    }
                    GeneralCalibrationEditor.this._tempVendorData.clear();
                    GeneralCalibrationEditor.this.updateVendorDataComponents();
                }
            }
        });
        this.btnClear.setEnabled(false);
        this.xx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.xy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.xz.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.yx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.yy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.yz.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.zx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.zy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.zz.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.offsetX.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.offsetY.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.offsetZ.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat31.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat32.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat33.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat21.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat22.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat23.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat11.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat12.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.mat13.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.formatID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GeneralCalibrationEditor.this._modified = true;
            }
        });
        this.formatID.setEnabled(false);
        this.mat11.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat12.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat13.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        label.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat23.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat22.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.xx.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.xy.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.xz.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.yx.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.yy.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.yz.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.zx.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.zy.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.zz.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.offsetX.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.offsetY.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.offsetZ.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat31.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat32.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat33.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.mat21.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.xx.setMinimum(-1);
        this.xy.setMinimum(-1);
        this.xz.setMinimum(-1);
        this.yx.setMinimum(-1);
        this.yy.setMinimum(-1);
        this.yz.setMinimum(-1);
        this.zx.setMinimum(-1);
        this.zy.setMinimum(-1);
        this.zz.setMinimum(-1);
        this.offsetX.setMinimum(Integer.MIN_VALUE);
        this.offsetY.setMinimum(Integer.MIN_VALUE);
        this.offsetZ.setMinimum(Integer.MIN_VALUE);
        lblCalibrationFormatId.setEnabled(false);
        ((GridLayout)compositeVendorDefined.getLayout()).marginWidth = 0;
        ((GridLayout)compositeVendorDefined.getLayout()).marginHeight = 0;
        ((GridLayout)compositeButton.getLayout()).marginWidth = 0;
        ((GridLayout)compositeButton.getLayout()).marginHeight = 0;
        int spinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 0.5);
        int textMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.8);
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.5);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        ((GridData)this.xx.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.xy.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.xz.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.yx.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.yy.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.yz.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.zx.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.zy.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.zz.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.btnVenDataBrowse.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnVenDataExport.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnClear.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)btnSave.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.formatID.getLayoutData()).minimumWidth = textMinWidth;
        this.shlEditCalibration.setSize(this.shlEditCalibration.computeSize(-1, -1));
        this.shlEditCalibration.setLocation(GuiUtils.getMiddleLocation(this.shlEditCalibration, this.display));
    }
}

