/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.payloads.configurations.AngleRegulatorConfigurationPayload;
import resources.CustomSpinner;

public class AngleRegulatorConfiguration
implements ConfigurationEditor {
    protected Shell shlEditConfiguration;
    private Display display;
    private boolean _modified = false;
    private SensorModifier _parent = null;
    private Sensor _sensor = null;
    private AngleRegulatorConfigurationPayload _data = null;
    private Group grpData;
    private Label lblLidAngle;
    private CustomSpinner lidClosedAngle;
    private Button btnLidClosed;
    private Button btnTabletMode;
    private Button btnKickstandClosed;
    private Label lblTabletAngle;
    private Label lblKickstandAngle;
    private CustomSpinner tabletAngle;
    private CustomSpinner kickstandAngle;
    private Label lblValidAngleRange;
    private CustomSpinner validAngleRangeMin;
    private Label lblValidAngleRangeSeparator;
    private CustomSpinner validAngleRangeMax;
    private boolean updatingValidAngleRange = false;
    private Label lblDefaultAngle;
    private CustomSpinner defaultAngle;
    private Label lblTimeHyst;
    private CustomSpinner timeHyst;
    private Label lblAngleRange;
    private CustomSpinner angleRange;
    private Group grpOutputOverrides;

    public static void main(String[] args) {
        try {
            AngleRegulatorConfiguration window = new AngleRegulatorConfiguration(new SensorModifier(null, null, null, false), new Sensor(new Luid(0, 0, 0, 0, 0)));
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AngleRegulatorConfiguration(SensorModifier parent, AngleRegulatorConfigurationPayload data, Sensor sensor) {
        this._data = data;
        this._sensor = sensor;
        this._parent = parent;
    }

    public AngleRegulatorConfiguration(SensorModifier parent, Sensor sensor) {
        this._parent = parent;
        this._sensor = sensor;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditConfiguration.open();
        this.shlEditConfiguration.layout();
        while (!this.shlEditConfiguration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void saveData() {
        boolean newConfiguration = false;
        AngleRegulatorConfigurationPayload data = this._data;
        if (data == null) {
            data = new AngleRegulatorConfigurationPayload();
            newConfiguration = true;
        }
        data.setLidClosed(this.btnLidClosed.getSelection());
        if (this.btnLidClosed.getSelection()) {
            data.setLidClosedAngle(this.lidClosedAngle.getSelection());
        }
        data.setTabletMode(this.btnTabletMode.getSelection());
        if (this.btnTabletMode.getSelection()) {
            data.setTabletModeAngle(this.tabletAngle.getSelection());
        }
        data.setKickstandClosed(this.btnKickstandClosed.getSelection());
        if (this.btnKickstandClosed.getSelection()) {
            data.setKickstandClosedAngle(this.kickstandAngle.getSelection());
        }
        data.setValidAngleRangeMin(this.validAngleRangeMin.getSelection());
        data.setValidAngleRangeMax(this.validAngleRangeMax.getSelection());
        data.setDefaultAngle(this.defaultAngle.getSelection());
        data.setTimeHysteresis(this.timeHyst.getSelection());
        data.setAngleRange(this.angleRange.getSelection());
        if (newConfiguration) {
            this._parent.addNewConfiguration(data);
        }
        this._data = data;
        this._modified = false;
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditConfiguration.close();
    }

    public void fillData() {
        if (this._data == null) {
            this._modified = false;
            return;
        }
        this.btnLidClosed.setSelection(this._data.isLidClosed());
        if (this.btnLidClosed.getSelection()) {
            this.lidClosedAngle.setSelection(this._data.getLidClosedAngle());
        }
        this.btnTabletMode.setSelection(this._data.isTabletMode());
        if (this.btnTabletMode.getSelection()) {
            this.tabletAngle.setSelection(this._data.getTabletModeAngle());
        }
        this.btnKickstandClosed.setSelection(this._data.isKickstandClosed());
        if (this.btnKickstandClosed.getSelection()) {
            this.kickstandAngle.setSelection(this._data.getKickstandClosedAngle());
        }
        this.validAngleRangeMin.setSelection(this._data.getValidAngleRangeMin());
        this.validAngleRangeMax.setSelection(this._data.getValidAngleRangeMax());
        this.defaultAngle.setSelection(this._data.getDefaultAngle());
        this.timeHyst.setSelection(this._data.getTimeHysteresis());
        this.angleRange.setSelection(this._data.getAngleRange());
        this.setFieldsAvalibility();
        this._modified = false;
    }

    public void setFieldsAvalibility() {
        this.lidClosedAngle.setEnabled(this.btnLidClosed.getSelection());
        this.lblLidAngle.setEnabled(this.btnLidClosed.getSelection());
        this.lblTabletAngle.setEnabled(this.btnTabletMode.getSelection());
        this.tabletAngle.setEnabled(this.btnTabletMode.getSelection());
        this.lblKickstandAngle.setEnabled(this.btnKickstandClosed.getSelection());
        this.kickstandAngle.setEnabled(this.btnKickstandClosed.getSelection());
    }

    protected void createContents() {
        this.shlEditConfiguration = new Shell(65632);
        this.shlEditConfiguration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (AngleRegulatorConfiguration.this._modified) {
                    MessageBox messageBox = new MessageBox(AngleRegulatorConfiguration.this.shlEditConfiguration, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditConfiguration.setImage(SWTResourceManager.getImage(AngleRegulatorConfiguration.class, "/resources/Intel.ico"));
        this.shlEditConfiguration.setText("Angle Regulator Configuration");
        GridLayout gridLayoutshlEditConfiguration = new GridLayout(2, false);
        gridLayoutshlEditConfiguration.marginWidth = 10;
        gridLayoutshlEditConfiguration.marginHeight = 10;
        gridLayoutshlEditConfiguration.horizontalSpacing = 10;
        gridLayoutshlEditConfiguration.verticalSpacing = 10;
        this.shlEditConfiguration.setLayout((Layout)gridLayoutshlEditConfiguration);
        this.grpOutputOverrides = new Group((Composite)this.shlEditConfiguration, 0);
        this.grpOutputOverrides.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.grpOutputOverrides.setText("Output Overrides");
        GridLayout gridLayoutgrpOutputOverrides = new GridLayout(3, false);
        gridLayoutgrpOutputOverrides.marginWidth = 10;
        gridLayoutgrpOutputOverrides.marginHeight = 10;
        gridLayoutgrpOutputOverrides.horizontalSpacing = 10;
        gridLayoutgrpOutputOverrides.verticalSpacing = 10;
        this.grpOutputOverrides.setLayout((Layout)gridLayoutgrpOutputOverrides);
        this.btnLidClosed = new Button((Composite)this.grpOutputOverrides, 32);
        this.btnLidClosed.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnLidClosed.setText("Lid Closed event");
        this.btnLidClosed.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                AngleRegulatorConfiguration.this.setFieldsAvalibility();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                AngleRegulatorConfiguration.this.setFieldsAvalibility();
            }
        });
        this.lblLidAngle = new Label((Composite)this.grpOutputOverrides, 0);
        this.lblLidAngle.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblLidAngle.setEnabled(false);
        this.lblLidAngle.setText("Angle (degrees):");
        this.lidClosedAngle = new CustomSpinner((Composite)this.grpOutputOverrides, 2048, this.shlEditConfiguration);
        this.lidClosedAngle.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lidClosedAngle.setEnabled(false);
        this.lidClosedAngle.setMaximum(360);
        this.lidClosedAngle.setMinimum(0);
        this.lidClosedAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
            }
        });
        this.btnTabletMode = new Button((Composite)this.grpOutputOverrides, 32);
        this.btnTabletMode.setText("Tablet Mode event");
        this.btnTabletMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                AngleRegulatorConfiguration.this.setFieldsAvalibility();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                AngleRegulatorConfiguration.this.setFieldsAvalibility();
            }
        });
        this.lblTabletAngle = new Label((Composite)this.grpOutputOverrides, 0);
        this.lblTabletAngle.setEnabled(false);
        this.lblTabletAngle.setText("Angle (degrees):");
        this.tabletAngle = new CustomSpinner((Composite)this.grpOutputOverrides, 2048, this.shlEditConfiguration);
        this.tabletAngle.setEnabled(false);
        this.tabletAngle.setMaximum(360);
        this.tabletAngle.setMinimum(0);
        this.tabletAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
            }
        });
        this.btnKickstandClosed = new Button((Composite)this.grpOutputOverrides, 32);
        this.btnKickstandClosed.setText("Kickstand Closed event");
        this.btnKickstandClosed.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                AngleRegulatorConfiguration.this.setFieldsAvalibility();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                AngleRegulatorConfiguration.this.setFieldsAvalibility();
            }
        });
        this.lblKickstandAngle = new Label((Composite)this.grpOutputOverrides, 0);
        this.lblKickstandAngle.setEnabled(false);
        this.lblKickstandAngle.setText("Angle (degrees):");
        this.kickstandAngle = new CustomSpinner((Composite)this.grpOutputOverrides, 2048, this.shlEditConfiguration);
        this.kickstandAngle.setEnabled(false);
        this.kickstandAngle.setMaximum(360);
        this.kickstandAngle.setMinimum(0);
        this.kickstandAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
            }
        });
        this.grpData = new Group((Composite)this.shlEditConfiguration, 0);
        this.grpData.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.grpData.setText("Data");
        GridLayout gridLayoutgrpData = new GridLayout(4, false);
        gridLayoutgrpData.marginWidth = 10;
        gridLayoutgrpData.marginHeight = 10;
        gridLayoutgrpData.horizontalSpacing = 10;
        gridLayoutgrpData.verticalSpacing = 10;
        this.grpData.setLayout((Layout)gridLayoutgrpData);
        this.lblValidAngleRange = new Label((Composite)this.grpData, 0);
        this.lblValidAngleRange.setText("Angle range (degrees):");
        this.lblValidAngleRange.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.validAngleRangeMin = new CustomSpinner((Composite)this.grpData, 2048, this.shlEditConfiguration);
        this.validAngleRangeMin.setMaximum(360);
        this.validAngleRangeMin.setMinimum(0);
        this.validAngleRangeMin.setSelection(0);
        this.validAngleRangeMin.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 1));
        this.validAngleRangeMin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                if (!AngleRegulatorConfiguration.this.updatingValidAngleRange) {
                    AngleRegulatorConfiguration.this.updatingValidAngleRange = true;
                    if (AngleRegulatorConfiguration.this.validAngleRangeMin.getSelection() > AngleRegulatorConfiguration.this.validAngleRangeMax.getSelection()) {
                        AngleRegulatorConfiguration.this.validAngleRangeMax.setSelection(AngleRegulatorConfiguration.this.validAngleRangeMin.getSelection());
                    }
                    AngleRegulatorConfiguration.this.updatingValidAngleRange = false;
                }
            }
        });
        this.lblValidAngleRangeSeparator = new Label((Composite)this.grpData, 0);
        this.lblValidAngleRangeSeparator.setText("-");
        this.lblValidAngleRangeSeparator.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.validAngleRangeMax = new CustomSpinner((Composite)this.grpData, 2048, this.shlEditConfiguration);
        this.validAngleRangeMax.setMaximum(360);
        this.validAngleRangeMax.setMinimum(0);
        this.validAngleRangeMax.setSelection(360);
        this.validAngleRangeMax.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 1));
        this.validAngleRangeMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
                if (!AngleRegulatorConfiguration.this.updatingValidAngleRange) {
                    AngleRegulatorConfiguration.this.updatingValidAngleRange = true;
                    if (AngleRegulatorConfiguration.this.validAngleRangeMin.getSelection() > AngleRegulatorConfiguration.this.validAngleRangeMax.getSelection()) {
                        AngleRegulatorConfiguration.this.validAngleRangeMin.setSelection(AngleRegulatorConfiguration.this.validAngleRangeMax.getSelection());
                    }
                    AngleRegulatorConfiguration.this.updatingValidAngleRange = false;
                }
            }
        });
        this.lblDefaultAngle = new Label((Composite)this.grpData, 0);
        this.lblDefaultAngle.setText("Angle if out of range (degrees):");
        this.lblDefaultAngle.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.defaultAngle = new CustomSpinner((Composite)this.grpData, 2048, this.shlEditConfiguration);
        this.defaultAngle.setMaximum(360);
        this.defaultAngle.setMinimum(0);
        this.defaultAngle.setSelection(0);
        this.defaultAngle.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 1));
        this.defaultAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
            }
        });
        this.lblTimeHyst = new Label((Composite)this.grpData, 0);
        this.lblTimeHyst.setText("Time hysteresis (ms):");
        this.lblTimeHyst.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.timeHyst = new CustomSpinner((Composite)this.grpData, 2048, this.shlEditConfiguration);
        this.timeHyst.setMaximum(800);
        this.timeHyst.setMinimum(200);
        this.timeHyst.setSelection(250);
        this.timeHyst.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.timeHyst.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
            }
        });
        this.lblAngleRange = new Label((Composite)this.grpData, 0);
        this.lblAngleRange.setText("Angle hysteresis (degrees):");
        this.lblAngleRange.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Label lblAngleHystPlusMinus = new Label((Composite)this.grpData, 0);
        lblAngleHystPlusMinus.setText("\u00b1");
        lblAngleHystPlusMinus.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.angleRange = new CustomSpinner((Composite)this.grpData, 2048, this.shlEditConfiguration);
        this.angleRange.setMaximum(360);
        this.angleRange.setMinimum(0);
        this.angleRange.setSelection(2);
        this.angleRange.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.angleRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AngleRegulatorConfiguration.this._modified = true;
            }
        });
        Button btnSave = new Button((Composite)this.shlEditConfiguration, 0);
        GridData gd_btnSave = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_btnSave.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfiguration);
        btnSave.setLayoutData((Object)gd_btnSave);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AngleRegulatorConfiguration.this.saveData();
            }
        });
        btnSave.setText("Save and Close");
        Button btnCancel = new Button((Composite)this.shlEditConfiguration, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfiguration);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AngleRegulatorConfiguration.this.shlEditConfiguration.close();
            }
        });
        btnCancel.setText("Cancel");
        this.shlEditConfiguration.setSize(this.shlEditConfiguration.computeSize(-1, -1));
        this.shlEditConfiguration.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfiguration, this.display));
    }

    @Override
    public String getConfigurationFormatName() {
        return "Angle Regulator Configuration";
    }
}

