<?php
//bga page displayer
abstract class BGAPageDisplayer extends PageDisplayer
{
	protected $cmdPara;
	protected $bgaType;
	protected $status;
	protected function initPage()
	{
		if(!getSessionPara('isAdmin'))
		{
			$this->displayDefaultPage(Target::LdListPage);
			return;
		}
		
		$this->setInfo();
		
		$smarty = $this->smarty;
		
		$type = getRequestPara('type');
		$jobID = getRequestPara('jobID');
		$pageID = getRequestPara('pageID');
		$VDID = getRequestPara('ID');
		$startTime= getRequestPara('startTime');
		$repeatType= getRequestPara('repeatType');
		$repeatParam1= getRequestPara('repeatParam1');
		$repeatParam2= getRequestPara('repeatParam2');
		
		$this->bgaType = getRequestPara('bgaType');
		$this->cmdPara = getRequestPara('cmdPara');
		
		if ($type == 'saveModify' && $this->cmdPara == null) {
			
			$da = new BGAJobDataAccess();
			$job = $da->getBGAJobByID($jobID);
			
			if ($job) {
				//get job info
				$this->cmdPara = $job->getCmdPara();
				$this->bgaType = $job->getBgaType();
				$this->status = $job->getStatus();
				
				$VDID = $job->getVDID();
				$startTime = $job->getSettingTime();
				$repeatParam1 = $job->getSettingDate();
				$repeatParam2 = $job->getSettingDateSupplement();
				$repeatType = $job->getSettingType();
				
				//format display
				$startTime = substr($startTime,0,2) . ':' . substr($startTime,2,2);
				if ($repeatType == ScheduleSettingType::No_REPEAT) {
					$time  = strtotime($repeatParam1);
					$repeatParam1 = date('m/d/Y',$time);
				}
			}
			else
			{
				$this->displayDefaultPage(Target::BgaSchedulePage);
			}
			
		}
		
		$smarty->assign('type',$type);
		$smarty->assign('pageID',$pageID);
		$smarty->assign('jobID',$jobID);
		$smarty->assign('ID',$VDID);
		$smarty->assign('startTime',$startTime);
		$smarty->assign('repeatType',$repeatType);
		$smarty->assign('repeatParam1',$repeatParam1);
		$smarty->assign('repeatParam2',$repeatParam2);
		
		$smarty->assign('cmdPara',$this->cmdPara);
		$smarty->assign('bgaType',$this->bgaType);
		$smarty->assign('status',$this->status);
		
		$this->setDisplayInfo();
	}
	
	protected abstract function setInfo();
	protected abstract function setDisplayInfo();
}
?>