<?php

class DiskInfo {
    private $diskNumber;
    private $model;
    private $serial;

    public function setDiskNumber($diskNumber) {
        $this->diskNumber = $diskNumber;
    }

    public function setModel($model) {
        $this->model = $model;
    }

    public function setSerial($serial) {
        $this->serial = $serial;
    }

    public function getDiskNumber() {
        return $this->diskNumber;
    }

    public function getModel() {
        return $this->model;
    }

    public function getSerial() {
        return $this->serial;
    }

}

class Partition {
    private $ID = 0;
    private $start;   //start LBA on plato
    private $size;
    private $sector_hyper;
    private $type;
    private $hyperSSD_status;
    private $bga_percentage; //for hyperssd rebuild
    private $hyper_policy;
    private $cache_policy;
    private $attributes;
    private $part_func_map;
    private $diskInfo;

    public function __construct() {
    }

    public function getID() {
        return $this->ID;
    }

    public function getStart() {
        return $this->start;
    }

    public function getSizeTotal() {
        return $this->size;
    }

    public function getSizeHyper() {
        return SectorSizeToKB($this->sector_hyper);
    }

    public function getType() {
        return $this->type;
    }

    public function getCachePolicy() {
        return $this->cache_policy;
    }

    public function getHyperPolicy() {
        return $this->hyper_policy;
    }

    public function getHyperSSDStatus() {
        return $this->hyperSSD_status;
    }
    
    public function getBgaPercentage() {
        return $this->bga_percentage;
    }

    public function getAttributes() {
        return $this->attributes;
    }

    public function getPart_func_map() {
        return $this->part_func_map;
    }

    public function getAssociatedDisk()
    {
        return $this->diskInfo;
    }

    public function isHyperSSD() {
        return $this->type & SSDPartitionType::HYPER_SSD;
    }

    public function isHyperSSDRebuilding() {
        return ( ($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_DISK_BIND)
                && ($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_REBUILDING) );
    }

    public function isHyperSSDNeedReboot() {
        return ( ($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_DISK_BIND)
                && ($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_NON_REBUILT) );
    }

    public function isHyperSSDMissing() {
        return ($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_DISK_MISSING);
    }

    public function isHyperSSDNoneBind() {
        return !($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_DISK_BIND)
                && !($this->hyperSSD_status & HyperSSDStatus::HYPERSSD_STATUS_DISK_MISSING);
    }

    public function setPartitionInfo($Info) {
        if (isset ($Info->id)) {
            $this->ID = trim($Info->id);
        }
        if (isset ($Info->start)) {
            $this->start = trim($Info->start);
        }
        if (isset ($Info->type)) {
            $this->type = trim($Info->type);
        }
        if (isset ($Info->size)) {
            $this->size = trim($Info->size);
        }
        if (isset ($Info->sector_hyper)) {
            $this->sector_hyper = trim($Info->sector_hyper);
        }
        if (isset ($Info->hyperSSD_status)) {
            $this->hyperSSD_status = trim($Info->hyperSSD_status);
        }
        if (isset ($Info->cache_policy)) {
            $this->cache_policy = trim($Info->cache_policy);
        }
        if (isset ($Info->hyper_policy)) {
            $this->hyper_policy = trim($Info->hyper_policy);
        }
        if (isset ($Info->bga_percentage)) {
            $this->bga_percentage = trim($Info->bga_percentage);
        }
        if (isset ($Info->attributes)) {
            $this->attributes = trim($Info->attributes);
        }
        if (isset ($Info->part_func_map)) {
            $this->part_func_map = trim($Info->part_func_map);
        }

    }

    public function setPartitionLink($Link) {
        if (isset ($Link->id)) {
            $this->ID = trim($Link->id);
        }
    }

    public function setDiskInfo($diskInfo) {
        $this->diskInfo = new DiskInfo();
        $this->diskInfo->setDiskNumber($diskInfo->diskNumber);
        $this->diskInfo->setModel($diskInfo->model);
        $this->diskInfo->setSerial($diskInfo->serial);
    }

}

?>
