function Slider(oInput,oFrame,iMin,iMax,tMin,tMax,iNum) {

	if (!oInput) return;
	if (!oFrame) return;

	if (iMin < iMax)
	{
	    this._min = iMin;
	    this._max = iMax;
	}
    else if (iMin == iMax)
    {
        this._min = iMin;
	    this._max = iMax + 1;
    }
    else
    {
        this._min = iMax;
	    this._max = iMin;
    }

	this._value = this._min;
	this._beforevalue = this._value;
	this._unitIncrement = 1;

	this.parentFrame = document.getElementById(oFrame);
	this.parentFrame.slider = this;

	// create min
	if (tMin != undefined)
	{
	    this.parentFrame.appendChild(document.createTextNode(tMin));
	}
    else
    {
        this.parentFrame.appendChild(document.createTextNode(iMin));
    }
	this.parentFrame.appendChild(document.createTextNode(String.fromCharCode(160)));

	// create line
	this.line = document.createElement("input");
	this.line.type="text";
	this.line.className = "line";
	this.line.unselectable = "on";
	this.line.readOnly = true;
	this.line.slider = this;
	this.parentFrame.appendChild(this.line);

    // create handle
	this.handle = document.createElement("DIV");
	this.handle.className = "handleDiv";
	this.handle.unselectable = "on";
	this.handle.slider = this;

	this.handleInput = document.createElement("input");
	this.handleInput.className = "handleInput";
	this.handleInput.readOnly=true;
	this.handleInput.slider = this;
	this.handle.appendChild(this.handleInput);
    this.handle.style.textIndent="0px";
	
	this.parentFrame.appendChild(this.handle);

	//create graduation
	this.iNum = (iNum > 1)?iNum:2;
	this.graduation = new Array();
    for (var i=0;i<iNum;i++)
    {
        this.graduation[i] = document.createElement("DIV");
	    this.graduation[i].className = "graduation";
	    this.graduation[i].unselectable = "on";
	    this.graduation[i].slider = this;
	    this.parentFrame.appendChild(this.graduation[i]);
    }

	// create max
	//this.parentFrame.appendChild(document.createTextNode(String.fromCharCode(160)));
	if (tMax != undefined)
	{
	    this.parentFrame.appendChild(document.createTextNode(tMax));
	}
    else
    {
        this.parentFrame.appendChild(document.createTextNode(iMax));
    }

	//this.parentFrame.appendChild(document.createTextNode(String.fromCharCode(160)));

	this.valueInput = document.createElement("input");
	this.valueInput.className="transInput";
	this.valueInput.readOnly=true;
	this.valueInput.style.width=43;
	this.parentFrame.appendChild(this.valueInput);

	this.input = document.getElementById(oInput);
	this.input.readOnly = true;
	this.input.slider = this;
	
	// events
	this.handle.onfocus	= Slider.eventHandlers.onfocus;
	this.handle.onblur		= Slider.eventHandlers.onblur;

	this.handle.onmousedown	    = Slider.eventHandlers.onmousedown;
	this.handle.onkeyup		= Slider.eventHandlers.onkeypress;
	this.handle.onmousewheel	= Slider.eventHandlers.onmousewheel;
	this.handle.onselectstart	= this.parentFrame.onselectstart	= function () { return false; };
	this.input.onkeyup		    = Slider.eventHandlers.ontextinput;
	this.input.onblur		    =  Slider.eventHandlers.syncvalue;
	this.input.onmouseout       =  Slider.eventHandlers.syncvalue;
    this.line.onclick        = Slider.eventHandlers.onquickmove;

	//replace windows.resize
	if (window.onresize  != Slider.eventHandlers.onresize)
	{
	    this._oldwinresize=window.onresize;
	    try{
            window.onresize  = Slider.eventHandlers.onresize;
        }
        catch(ex){}
	}

    var oThis = this;
    Slider.prototype.sliders[Slider.prototype.sliders.length]=oThis;
 
	oThis.updateView();
}

Slider.eventHandlers = {

	// helpers to make events a bit easier
	getEvent:	function (ev) {
		if (!ev) {
				ev = window.event;
		}
		if (!ev.srcElement) {
			var t = ev.target;
			while (t != null && t.nodeType != 1)
				t = t.parentNode;
			ev.srcElement = t;
		}
		if (typeof ev.offsetX == "undefined") {
			ev.offsetX = ev.layerX;
			ev.offsetY = ev.layerY;
		}
		return ev;
	},

	getSlider:	function (ev) {
	    if (this.slider==null)
	    {
	        var oBack = ev.srcElement;
	        while (!oBack.slider && oBack!=document)
	        {
	            oBack = oBack.parent;
	        }
	        if (oBack!=document)
	        {
	            return oBack.slider;
	        }
	        else
	        {
	            return this;
	        }
	    }
	    else
	    {
		    return this.slider;
		}
	},
	// end helpers

   	onfocus:	function (ev) {
		ev=Slider.eventHandlers.getEvent(ev);
        var s = Slider.eventHandlers.getSlider(ev);
		s._focused = true;
	},

	onblur:	function (ev) {
		ev=Slider.eventHandlers.getEvent(ev);
        var s = Slider.eventHandlers.getSlider(ev);
		s._focused = false;
	},

	onmousedown:	function (ev) {
	    ev=Slider.eventHandlers.getEvent(ev);
        var s = Slider.eventHandlers.getSlider(ev);
        s.slider = this;

		if (document.addEventListener) {
			document.addEventListener("mousemove", Slider.eventHandlers.onmousemove, true);
			document.addEventListener("mouseup", Slider.eventHandlers.onmouseup, true);
		}
		else if (document.attachEvent) {
			document.attachEvent("onmousemove", Slider.eventHandlers.onmousemove);
			document.attachEvent("onmouseup", Slider.eventHandlers.onmouseup);
			document.attachEvent("onlosecapture", Slider.eventHandlers.onmouseup);
		}

		if (ev) {	// start drag
			s._eventStartPostion = {
				eventX:	ev.screenX,
				eventY:	ev.screenY
			};
		}
		else {
			s._eventStartPostion = {
				eventX:	s.getLine().offsetLeft,
				eventY:	s.getLine().offsetTop
			};
		}
		s.setStartValue();
	},

	onmousemove:	function (ev) {
		ev = Slider.eventHandlers.getEvent(ev);
		var s = Slider.eventHandlers.getSlider(ev);

		if (s._eventStartPostion) {	// drag
			var boundSize = s.getMaximum() - s.getMinimum();
			var size, pos;

			size = s.getLine().offsetWidth - s.getHandle().offsetWidth;
			pos = ev.screenX - s._eventStartPostion.eventX;
			s.setValue(s.getStartValue() + boundSize * pos / size);
			return false;
		}
	},

	onmouseup:	function (e) {
	    e = Slider.eventHandlers.getEvent(e);
		var s = Slider.eventHandlers.getSlider(e);
		if (document.removeEventListener) {
			document.removeEventListener("mousemove", Slider.eventHandlers.onmousemove, true);
			document.removeEventListener("mouseup", Slider.eventHandlers.onmouseup, true);
		}
		else if (document.detachEvent) {
			document.detachEvent("onmousemove", Slider.eventHandlers.onmousemove);
			document.detachEvent("onmouseup", Slider.eventHandlers.onmouseup);
			document.detachEvent("onlosecapture", Slider.eventHandlers.onmouseup);
		}
        s.slider = null;
		if (s._eventStartPostion) {	// end drag
			s._eventStartPostion = null;
		}
	},

	onkeypress:	function (e) {
		e = Slider.eventHandlers.getEvent(e);
        var s = Slider.eventHandlers.getSlider(e);
		var kc = e.keyCode;
		switch (kc) {
			case 33:	// page up
				s.setValue(s.getValue() + s.getBlockIncrement());
				break;
			case 34:	// page down
				s.setValue(s.getValue() - s.getBlockIncrement());
				break;
			case 35:	// end
				s.setValue(s.getMaximum());
				break;
			case 36:	// home
				s.setValue(s.getMinimum());
				break;
			case 38:	// up
			case 37:	// left
				s.setValue(s.getValue() + s.getUnitIncrement());
				break;

			case 39:	// right
			case 40:	// down
				s.setValue(s.getValue() - s.getUnitIncrement());
				break;
		}

		if (kc >= 33 && kc <= 40) {
			return false;
		}
	},

    syncvalue:function(ev) {
        ev = Slider.eventHandlers.getEvent(ev);
        var s = Slider.eventHandlers.getSlider(ev);
		s.syncTextValue();
   },

   ontextinput:function(e) {
        e = Slider.eventHandlers.getEvent(e);
	    var s = Slider.eventHandlers.getSlider(e);
		var kc = e.keyCode;
		switch (kc) {
			case 13:	// enter
				s.syncTextValue();
				break;
		}

		if (kc != 13) {
			return false;
		}
   },

   onmousewheel:	function (e) {
		e = Slider.eventHandlers.getEvent(e);
		var s = Slider.eventHandlers.getSlider(e);
		if (s._focused) {
			s.setValue(s.getValue() + e.wheelDelta / 120 * s.getUnitIncrement());
			return false;
		}
   },

   onquickmove: function(ev) {
        ev = Slider.eventHandlers.getEvent(ev);
		var s = Slider.eventHandlers.getSlider(ev);
		var va = (s.getMaximum() - s.getMinimum())*(ev.clientX - s.getLine().offsetLeft-s.getHandle().offsetWidth*1.5)/(s.getLine().offsetWidth - s.getHandle().offsetWidth);
		s.setValue(va);
   },
   
   onresize:function(ev) {
        Slider.prototype.runOldResize();
        var i = 0;
        for (i=0;i<Slider.prototype.sliders.length;i++)
		    Slider.prototype.sliders[i].updateView();
   }
};

Slider.prototype.slider=null;
Slider.prototype.sliders=new Array();

Slider.prototype.setValue = function (v) {
	if (v<=this._max && v>=this._min) {this._value=parseInt(v);}
    else if (v>this._max) {this._value=this._max;}
    else {this._value=this._min;}
    var oThis =this;
	oThis.updateView();
	if (this.input.setValue) {this.input.setValue(this._value)}
	if (oThis.onValueChange) {oThis.onValueChange.call()}
};

Slider.prototype.syncTextValue = function () {
	if (this.input.iValue)
	{
	    this.setValue(parseInt(this.input.iValue));
	}
    else
    {
	    this.setValue(parseInt(this.input.value));
	}
};

Slider.prototype.getValue = function () {
	if (this._value > this._max) this._value = this._max;
	if (this._value < this._min) this._value = this._min;
	return this._value;
};

Slider.prototype.getStartValue = function () {
	return this._beforevalue;
};

Slider.prototype.setStartValue = function () {
	this._beforevalue = this._value;
};

Slider.prototype.setUnitIncrement = function (v) {
	this._unitIncrement = v;
};

Slider.prototype.getMinimum = function () {
	return this._min;
};

Slider.prototype.getMaximum = function () {
	return this._max;
};

Slider.prototype.getLine = function () {
	return this.line;
};

Slider.prototype.getHandle = function () {
	return this.handle;
};

Slider.prototype.runOldResize= function () {
	if (this._oldwinresize)
	{
	    this._oldwinresize.call();
	}
};

Slider.prototype.updateView = function() {
	var hh = this.handle.offsetHeight;
	var lh = this.line.offsetHeight;

	// this assumes a border-box layout
	if (window.ActiveXObject)
	{
	    this.handle.style.top = "4px";
	    this.line.style.top = "-2px";
	}
    else
    {
	    //this.handle.style.top = "20px";
    }
    
    // create graduation
	if (this.iNum != undefined)
	{
	    var graduationTop=0;
	    var step = this.line.offsetWidth / (this.iNum-1);
	    var start = 0;

	    if (window.ActiveXObject)
	    {
	        graduationTop = "4px";
	    }
        else
        {
	        graduationTop = - ((this.graduation[0].offsetHeight - lh) + 2) + "px";
        }

	    for (var i=0;i<(this.iNum);i++)
	    {
	        this.graduation[i].style.top = graduationTop;
	        this.graduation[i].style.left = - this.handle.offsetWidth - this.line.offsetWidth - (i * this.graduation[0].offsetWidth) + start + "px";
	        start += step;
	    }
	}
	var i = (this._value/250)*100;
	this.valueInput.value = Math.floor(i) + "%";

	var oThis = this;
    oThis.draw();
};

Slider.prototype.draw = function() {
	var lw  = this.line.offsetWidth;
	var hw = this.handle.offsetWidth;

    if (this.input.setValue) {this.input.setValue(this._value);} else {this.input.value=this.getValue();}
    this.handle.style.left = ((-lw+hw) * (this.getMaximum()- this.getValue())/(this.getMaximum() - this.getMinimum()) -hw) + "px";
};

Slider.prototype.onValueChange=null;
Slider.prototype._focused = false;
Slider.prototype._eventStartPostion = null;