<?php
//include_once("PageDisplayer.class.php");

class PgCreate1Displayer extends PageDisplayer
{
	protected function initPage()
	{
		if(!getSessionPara('isAdmin'))
		{
			$this->displayDefaultPage(Target::LdListPage);
			return;
		}
		
		$smarty = $this->smarty;
		//get request para
		$RaidMode = getRequestPara('RaidMode');
		$QuickRaidMode = getRequestPara('QuickRaidMode');
		if (isset($QuickRaidMode))
		{
			$RaidMode = $QuickRaidMode;
		}

		$subRaidMode = getRequestPara('subRaidMode');
		//set default raid mode
		if ($RaidMode == null) {
			$RaidMode = RAIDMode::LD_MODE_RAID1 ;
		}
		$HDs = getRequestPara('HDs');
		if ($HDs == null) {
			$HDIDs = array();
		}
		else {
			//check HDs
			
			//
			$HDIDs = explode(" ",$HDs);
			foreach ($HDIDs as $HD)
			{
				if (trim($HD) == "") {
					unset($HD);
				}
			}
		}
		
		$selectedHBAID = $this->getAdapterID();
		$LDName = trim(getRequestPara('LDName'));
		$LDSize = getRequestPara('LDSize');
		$InitType = getRequestPara('InitType');
		$ReadCache = getRequestPara('ReadCache');
		$WriteCache = getRequestPara('WriteCache');
		$DiskCache = getRequestPara('DiskCache');
		$GBRounding = getRequestPara('GBRounding');
		$SectorSize = getRequestPara('SectorSize');
		$StripeSize = getRequestPara('StripeSize');
		$ParityDisk = getRequestPara('NumOfParityDisk');
		$Prev = getRequestPara("Prev");
		$CancelAlert = gettext(AlertMsg::CREATE_CANCEL)."?";
		
		$HBAList = new HBAList();
		$HBAList->toGetHBAInfo();
		$HBAList->initData();
		
		$HBAs = $HBAList->getBaseClasses();
		
		$supportRaidHBAIDs = array();
		foreach ($HBAs as $HBA)
		{
			if ($HBA->supportRAID()) {
				$supportRaidHBAIDs[] = $HBA->getDeviceID();
			}
		}
			
		if (sizeof($supportRaidHBAIDs) == 0) {
			$this->displayDefaultPage(Target::LdListPage);
			return;
		}
		
		$smarty->assign("HBAIDs",$supportRaidHBAIDs);
		
		if ($selectedHBAID == null) {
			$selectedHBAID = $supportRaidHBAIDs[0];
		}
		
		$hba = HBAFactory::getInstance($selectedHBAID);
		//$hba = new HBA();
		$supportRaids = array();
		if ($hba->supportLDRaid0()) {
			$supportRaids[RAIDMode::LD_MODE_RAID0] = RAIDMode::RAID0;
		}
		if ($hba->supportLDRaid1()) {
			$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
		}
		if ($hba->supportLDRaid10()) {
			$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
		}
		if ($hba->supportLDRaid1E()) {
			$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
		}
		if ($hba->supportLDRaid5()) {
			$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
		}
		if ($hba->supportLDRaid50()) {
			$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
		}
		if ($hba->supportLDRaid6()) {
			$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
		}
		if ($hba->supportLDRaid60()) {
			$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
		}
		if ($hba->supportLDRaidJBOD()) {
			$supportRaids[RAIDMode::LD_MODE_JBOD] = RAIDMode::JBOD;
		}
		/*if ($hba->supportLDRaidHyperHDD()) {
			$supportRaids[RAIDMode::LD_MODE_HyperHDD] = RAIDMode::HyperHDD;
		}*/
		
		$hyperHddTypes = array();
		$hyperHddTypes[RAIDMode::LD_MODE_RAID_HDD_MIRROR] = RAIDMode::HDDMirror; //default mirror
		$hyperHddTypes[RAIDMode::LD_MODE_HyperHDD] = RAIDMode::HDDSPAN;
			
		$needParity = 1;
		if ($RaidMode == RAIDMode::LD_MODE_RAID6 ||$RaidMode == RAIDMode::LD_MODE_RAID60)
		{
			$needParity = 1;
		}
		$smarty->assign("needParity",$needParity);
		
		$smarty->assign("subRaidMode", $subRaidMode);	
		$smarty->assign("RaidMode", $RaidMode);
		//$smarty->assign("HDs", $HDs);
		$smarty->assign("HDIDArr", $HDIDs);
		
		$smarty->assign("hyperHddTypes", $hyperHddTypes);
		$smarty->assign("MaxPDPerVD",$hba->getMaxPDPerVD());
		$smarty->assign("LDName", $LDName);
		$smarty->assign("LDSize", $LDSize);
		$smarty->assign("InitType", $InitType);
		$smarty->assign("ReadCache", $ReadCache);
		$smarty->assign("WriteCache", $WriteCache);
		$smarty->assign("DiskCache", $DiskCache);
		$smarty->assign("GBRounding", $GBRounding);
		$smarty->assign("SectorSize", $SectorSize);
		$smarty->assign("StripeSize", $StripeSize);
		$smarty->assign("selectedHBAID", $selectedHBAID);
		$smarty->assign("HBAID", $selectedHBAID);
		$smarty->assign("supportRaids", $supportRaids);
		$smarty->assign("ParityDisk", $ParityDisk);
		$smarty->assign("CancelAlert", $CancelAlert);
		$smarty->assign("Prev", $Prev);
		
		//hd list
		$hdlist  = new CtnHdList();
		$hdlist->setAdapterID($selectedHBAID);
		$hdlist->toGetHDInfo();
		$hdlist->toGetValidSize();
		$hdlist->toGetSpareInfo();
		$hdlist->toGetHdFreeInfo();
                $hdlist->toGetConfig();
		$hdlist->setFilter(new HdCreateFilter());
		$hdlist->smartyAssign($smarty);
		$hdlist->initContainer();
		
		$this->setPageName(Target::CreatePage1 . ".tpl");
	}
}
?>