<?php
class HBAList extends HBABase 
{
	public function toGetHBACount()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_Adapter_GetCount);
		
		$this->XMLAPICommandList['setHBACount'] = $XMLApiCmd;
	}
	
	public function toGetHBAInfo()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_Adapter_GetInfo);
		$XMLApiCmd->setCommandPara("AdapterID",XMLAPICommand::ParaALL);
		
		$this->XMLAPICommandList['setHBAInfo'] = $XMLApiCmd;
	}
	
	public function toGetHBAConfig()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_Adapter_GetConfig);
		$XMLApiCmd->setCommandPara("AdapterID",XMLAPICommand::ParaALL);
		
		$this->XMLAPICommandList['setHBAConfig'] = $XMLApiCmd;
	}
	
	//should run after other toGetXXX()
	public function toGetSuspendMode()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_GetDriverMode);
		
		$this->XMLAPICommandList['setSuspendModeInfo'] = $XMLApiCmd;
	}
	
	protected function prepareAPICommands()
	{
		
	}
	
	protected function setSuspendModeInfo($data)
	{
		$XMLRoot = $data;
		
		if (isset($XMLRoot->Mode)) {
			foreach ($XMLRoot->Mode as $Mode)
			{
				foreach ($this->BaseClasses as $Adapter)
				{
					if (trim($Mode)) {
						$Adapter->setSuspendModeOn();
					}
				}
			}
		}
	}
	
	protected function setHBACount($data)
	{
		$XMLRoot = $data;
		
		if (isset($XMLRoot->RetVal) 
			&& ! isset($XMLRoot->AdapterInfo->DriverVersion)
			&& ! isset($XMLRoot->AdapterInfo->AlarmOn)) {
			if (! $this->BaseClasses) {
				$count = intval($XMLRoot->RetVal);
				for ($i = 0;$i < $count ;$i++)
				{
					$HBA = new HBA();
					$HBA->setDeviceID($i);
					$this->BaseClasses[] = $HBA;
				}
			}
		}
	}
	
	protected function setDataToBaseClass()
	{

	}
	
	public function loadTestData()
	{
		$Path = "../phpsrc/baseclass/testdata/hbalist/";
		$Files = array("MV_Adapter_GetCount","MV_Adapter_GetInfo", "MV_Adapter_GetConfig","MV_GetDriverMode");
		
		foreach ($Files as $File)
		{
			foreach ($this->XMLAPICommandList as $APICmd)
			{
				if (strpos($APICmd->getCommand(),$File)) {
					$data = simplexml_load_file($Path . $File . ".xml");
					$this->setHBACount($data);
					$this->setHBAInfo($data);
					$this->setHBAConfig($data);
					$this->setSuspendModeInfo($data);
				}
			}
		}
	}
}
?>