<?php
class LDAdapter
{
	public $AdapterID;
	public $HDs;
}

class Disk extends HDInfo
{
	public $ID;
	public $Type;
	public $Size;
	public $LDUsedSize;
	public $IsTarget = 0;
	
	public function setRebuildingFlag()
	{
		$this->IsTarget = 1;
	}
}

class LDInfo
{
	public $ID=0;
	public $Name=0;
	public $StatusString=0;
	public $StatusInt=0;
	public $Size=0;
	public $SizeGB = 0;
	public $MemberCount=0;
	public $StripSize=0;
	public $RaidMode=0;
	public $RaidModeInt = 0;
	public $Bga=0;
	public $BgaString = 0;
	public $BgaStatusString = 0;
	public $BgaPercentage=0;
	public $BgaStateInt=0;
	public $BgaStateString=0;
    public $BgaExt = 0;
	public $AutoRebuildOn = 0;
	public $WriteCache=0;
	public $ReadCache=0;
	public $SectorSize=0;
	//public $CacheEnable=1;
	public $setEnable=0;
	public $HypperWaterMark = 0;
	
	
	public $LDImg = "";
	public $LeftBGAStr = "";
	public $RightBGAStr = "";
	
	
	//details	
	public $Adapters;
	
	public $enableImport = 0;
	public $enableInit = 0;
	public $enableCheck = 0;
	public $enableRebuild = 0;
	public $enableMigrate = 0;
	public $enableDelete = 0;
	
	public $enableStop = 0;
	public $enableResume = 0;
	public $enablePause = 0;
	public $enableRestart = 0;
	
	public $TargetLDRaidMode;
	public $TargetLDRaidModeInt;
	public $TargetLDSize;
	public $TargetLDSizeGB;
	public $IsMigrating = 0;
	
	public $AdapterID;
	public $UseThorSizePolicy=0;
	public $isForeign=0;
	public $isImportable=0;
	public $isNotImportable=0;
	public $needReport = 0;
	public $ConflictVDsList = array();
	public $LastWriteTime;
	public $isHyperHDD = 0;
	public $isHypersafe = 0;
	public $isRunningMP = 0;
    public $VD_status;
	
	public function __construct()
	{
		$this->Adapters = array();
	}
	
	public function setMigrateTargetLD($TargetLD)
	{
		$this->IsMigrating = 1;
		$this->TargetLDRaidModeInt = $TargetLD->getRaid_Level();
		$this->TargetLDRaidMode = RAIDMode::GetRAIDModeStr($TargetLD->getRaid_Level());
		$this->TargetLDSize = ConvertSize($TargetLD->getSize(),$this->UseThorSizePolicy);
		$this->TargetLDSizeGB = FormatSize($TargetLD->getSize(),$this->UseThorSizePolicy);
		//$this->TargetLDImg = LDStatus::getLDImg($TargetLD->getStatus());
		//$this->TargetStatusString = gettext(LDStatus::getLDStatusStr($TargetLD->getStatus()));
	}
	
	public function setLDInfo($LD)
	{
		$this->ID = $LD->getID();
		$this->Name = htmlspecialchars(trim($LD->getName()),ENT_QUOTES);
		$this->StatusInt = $LD->getStatus();
		$this->needReport = ($this->StatusInt == LDStatus::LD_STATUS_CONFLICTED 
							|| $this->StatusInt == LDStatus::LD_STATUS_DEGRADE_PLUGIN)?1:0;
		$this->ConflictVDsList = $LD->getConflictVDsList();
		$this->LastWriteTime = $LD->getLastWriteTime();
		
		$this->isForeign = $LD->isForeign();
		$this->isImportable = $LD->isImportable();
		$this->isNotImportable = $LD->isNotImportable();
		$this->AdapterID = $LD->getAdapterID();
		
		//use 1024*1024*1024 if is Thor
		$sysFeature = AdapterFeature::getInstance($this->AdapterID);
		if ($sysFeature)
		    $this->UseThorSizePolicy = $sysFeature->isThor;
		
		$this->SizeGB = FormatSize($LD->getSize(),$this->UseThorSizePolicy);
		$this->Size = ConvertSize($LD->getSize(),$this->UseThorSizePolicy);
		
		$this->RaidModeInt = $LD->getRaid_Level();
		if ($this->RaidModeInt == RAIDMode::LD_MODE_RAID_HDD_MIRROR_HYBRID
			|| $this->RaidModeInt == RAIDMode::LD_MODE_RAID_HDD_MIRROR) {
			$this->isHypersafe = 1;
            }
		if ($this->RaidModeInt == RAIDMode::LD_MODE_HyperHDD 
			|| $this->RaidModeInt == RAIDMode::LD_MODE_RAID_HDD_MIRROR) {
			$this->isHyperHDD = 1;
			$this->RaidMode = RAIDMode::HyperHDD . ", " . RAIDMode::GetHyperHddSubModeStr($this->RaidModeInt);
		} else {
			$this->RaidMode = RAIDMode::GetRAIDModeStr($LD->getRaid_Level());
		}
		$this->BGAStatus = $LD->getBGAStatus();
		
		$this->Bga = $LD->getBga();
		$this->BgaPercentage = $LD->getBgaPercentage();
		$this->BgaStateInt = $LD->getBgaState();
        $this->BgaExt = $LD->getBgaExt();
		
		$this->LDImg = LDStatus::getLDImg($this->StatusInt,$this->BgaStateInt);	

        $this->VD_status = $LD->getVD_status();
		//add check for driver may return bad bga state or bga status
		$this->BgaCheck();
	
		//set bga strings
		$this->setBGAStrings();
		
		$this->setLDMember($LD);
	}
	
	private function setLDMember($LD)
	{
		//ld disks 
		$HDs = array();
		$Blks = $LD->getBlockList();
		foreach ($Blks as $Blk)
		{
			$HD = $Blk->belongHD();
			//var_dump($HD);
			if ($HD) {
				$notfound = true;
				foreach ($this->Adapters as $adpater)
				{
					if (intval($adpater->AdapterID) == $HD->getAdapterID()) {
						$disk = new Disk();
						if(($Blk->getFlag()) & (BlockFlag::BLOCK_FLAG_REBUILDING)){
							$disk->setRebuildingFlag();
						}
						$disk->setHDInfo($HD);
						$disk->setConnectInfo($HD);
						$disk->LDUsedSize = FormatSize($Blk->getSize(),$this->UseThorSizePolicy);
						$adpater->HDs[$HD->getDeviceID()] = $disk;
						$notfound = false;
					}
				}
				if ($notfound) {
					$adpater = new LDAdapter();
					$adpater->AdapterID = $HD->getAdapterID();
					$disk = new Disk();
					if(($Blk->getFlag()) & (BlockFlag::BLOCK_FLAG_REBUILDING)){
						$disk->setRebuildingFlag();
					}
					$disk->setHDInfo($HD);
					$disk->setConnectInfo($HD);
					$disk->LDUsedSize = FormatSize($Blk->getSize(),$this->UseThorSizePolicy);
					$adpater->HDs[$HD->getDeviceID()] = $disk;
					$this->Adapters[$adpater->AdapterID] = $adpater;
				}
			}
		}
		foreach ($this->Adapters as $adpater)
		{
			ksort($adpater->HDs);
		}
		ksort($this->Adapters);
	}
	
	public function setLDDtl($LD)
	{
		$this->StripSize = $LD->getStripeBlockSize() . " K";
		$this->SectorSize = $LD->getSectorSize() . " B";
		$this->MemberCount = $LD->getHDCount();
		
		$this->WriteCache = $LD->getWriteCache();
		$this->ReadCache = $LD->getReadCache();
		
		$this->AutoRebuildOn = $LD->isAutoRebuildOn();
		$this->HypperWaterMark = $LD->getHypperWaterMark();
		
		//enable buttons
		$this->enableButtons();
	}
	
	private function setBGAStrings()
	{
		$TmpStr = LDStatus::getLDStatusStr($this->StatusInt);
		
		if ($this->isHyperHDD || $this->isHypersafe) {
			if ($this->Bga != LdBgaStatus::LD_BGA_NONE) //
				$this->StatusString = gettext(LDStatus::getHyperHDDStatus($this->StatusInt));
			else
				$this->StatusString = gettext(LDStatus::getLDStatusStr($this->StatusInt));

			$this->BgaString = gettext(LdBgaStatus::getHyperHDDBgaStr($this->Bga));
			$this->BgaStatusString = gettext(LdBgaStatus::getHyperHDDBgaStatusStr($this->Bga));
		} else {
			$this->StatusString = gettext($TmpStr);
			
			$TmpStr = LdBgaStatus::getLdBgaString($this->Bga);
			$this->BgaString = gettext($TmpStr);
			
			$TmpStr = LdBgaStatus::getLdBgaStatusStr($this->Bga);
			$this->BgaStatusString = gettext($TmpStr);
		}
			
		if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING ||
			$this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE )
		{
			$this->BgaStateString = "";
		}
		else {
			$TmpStr = LdBgaState::getLdBgaStateStr($this->BgaStateInt);
			$this->BgaStateString = gettext($TmpStr);	
		}

        if ($this->BgaExt  & (LdBgaStatus::LD_BGA_MEDIA_PATROL >> 8)) {
            $this->isRunningMP = 1;
        }
	}
	
	private function BgaCheck()
	{
		if (($this->Bga == LdBgaStatus::LD_BGA_NONE) || ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE)) {
			$this->Bga = LdBgaStatus::LD_BGA_NONE ;
			$this->BgaStateInt = LdBgaState::LD_BGA_STATE_NONE ;
			$this->BgaPercentage = 0;
		}
	}
	
	private function bgaSupport($bgaStatusStr)
	{
		$adpFeature = AdapterFeature::getInstance($this->AdapterID);
		switch ($bgaStatusStr)
		{
			case LdBgaStatus::LD_BGA_CONSISTENCY_CHECK:
			case LdBgaStatus::LD_BGA_CONSISTENCY_FIX:
				if ($adpFeature->supportSyncronization)
					return true;
				else
					return false;
			case LdBgaStatus::LD_BGA_COPYBACK:
				if ($adpFeature->supportCopyback)
					return true;
				else
					return false;
			case LdBgaStatus::LD_BGA_INIT_BACK:
				if ($adpFeature->supportBackgroundInit)
					return true;
				else
					return false;
			case LdBgaStatus::LD_BGA_INIT_FORE:
				if ($adpFeature->supportForegroundInit)
					return true;
				else
					return false;
			case LdBgaStatus::LD_BGA_MIGRATION:
				if ($adpFeature->supportMigrate)
					return true;
				else
					return false;
			case LdBgaStatus::LD_BGA_REBUILD:
				if ($adpFeature->supportRebuild)
					return true;
				else
					return false;
		}
		
	}
	
	
	private function enableButtons()
	{
		$adpFeature = AdapterFeature::getInstance($this->AdapterID);
		$isAdmin = getSessionPara('isAdmin');
		if ($isAdmin) {
			if (($this->isImportable || $this->isForeign) && $this->Bga == LdBgaStatus::LD_BGA_NONE) {//foreign vd has bga can not import
				$this->enableImport = 1;
			}
			if ($this->StatusInt == LDStatus::LD_STATUS_DEGRADED 
				||$this->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL 
				|| $this->StatusInt == LDStatus::LD_STATUS_INITIALIZED
				//||$this->StatusInt == LDStatus::LD_STATUS_MIGRATION 
				||$this->StatusInt == LDStatus::LD_STATUS_PARTIALLYOPTIMAL 
				||$this->StatusInt == LDStatus::LD_STATUS_OFFLINE )  //default can not set config
			{
				$this->setEnable = 1;
			}
			
			$this->enableDelete = 1;
		
			//foreign VD can not do bga related
			if (!$this->isForeign && !$this->isHyperHDD) {
				if ($this->Bga == LdBgaStatus::LD_BGA_NONE) {	
					if ($this->RaidModeInt != RAIDMode::LD_MODE_RAID0 ) {
						//init button
						if ($this->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL || $this->StatusInt == LDStatus::LD_STATUS_INITIALIZED) {
							$this->enableInit = 1;	
						}
						//rebuild
						if ($this->StatusInt == LDStatus::LD_STATUS_DEGRADED || LDStatus::LD_STATUS_PARTIALLYOPTIMAL == $this->StatusInt) {
							$this->enableRebuild = 1;
						}
						//check button
						if ($this->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL || $this->StatusInt == LDStatus::LD_STATUS_INITIALIZED) {
							$this->enableCheck = 1;
						}
					}
					//migrate button
					if ($this->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL || $this->StatusInt == LDStatus::LD_STATUS_INITIALIZED
						//&& $this->RaidModeInt != RAIDMode::LD_MODE_RAID50    //remove for issue NS-8213:LRM "Migrate" is disabled for RAID50/R60
						//&& $this->RaidModeInt != RAIDMode::LD_MODE_RAID60
						//&& $this->RaidModeInt != RAIDMode::LD_MODE_JBOD
						//&& ($adpFeature->isSupportMigrate())//migration bit
						) {
						$this->enableMigrate = 1;
					}
				}
				
				if ($this->bgaSupport($this->Bga)){ //if bga not support, can not do any operation
				
					if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING) {
						if ($this->Bga != LdBgaStatus::LD_BGA_MIGRATION 
							&& $this->Bga != LdBgaStatus::LD_BGA_INIT_FORE) { //fore init can not stop
							$this->enableStop = 1;	
						}
						$this->enablePause = 1;
					}
					
					if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_PAUSED || $this->BgaStateInt == LdBgaState::LD_BGA_STATE_AUTOPAUSED ) {
						$this->enableResume = 1;
					}
					
					if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_ABORTED
						&& $this->Bga != LdBgaStatus::LD_BGA_INIT_FORE) { //fore init can not restart
						$this->enableRestart = 1;
					}
				}
			}
		}
	}
}

?>