<?php

class Pager
{
	private $pageSize = 12;
	private $dataList = array();
	private $pageID = 0;
	
	private $isLast;
	private $isFirst;
	
	public function setPageSize($pageSize)
	{
		$this->pageSize = $pageSize;
	}
	
	public function getPageSize()
	{
		return $this->pageSize;
	}
	
	public function setPageID($pageID)
	{
		if ($pageID < 0 || $this->pageCount() == 0) 
		{
			$pageID = 0;
		}
		else if ($pageID >= ($this->pageCount() -1) )
		{
			$pageID = $this->pageCount() -1;
		}
		
		$this->pageID = $pageID;
	}
	
	public function getPageID()
	{
		return $this->pageID;
	}
	
	public function setDataList($dataList)
	{
		$this->dataList = $dataList;
	}
	
	public function getDataList()
	{
		return $this->dataList;
	}
	
	public function pageCount()
	{
		return ceil(sizeof($this->dataList) / $this->pageSize);
	}
	
	public function isLast()
	{
		return ($this->pageCount() == 0 ) || ($this->pageID == $this->pageCount() -1);
	}
	
	public function isFirst()
	{
		return $this->pageID <= 0 ;
	}
	
	public function goFirstPage()
	{
		$this->pageID = 0;
		return array_slice($this->dataList,$this->pageID,$this->pageSize);
	}
	
	public function goLastPage()
	{
		if ($this->pageCount() > 0) {
			$this->pageID = $this->pageCount() - 1;
		}
		else {
			$this->pageID = 0;
		}
		
		return array_slice($this->dataList,$this->pageSize * ($this->pageID));
	}
	
	public function getPage()
	{
		return array_slice($this->dataList,$this->pageSize * $this->pageID,$this->pageSize);
	}
	
}

?>