<?php
abstract class DgXmlHandler extends XmlHandler
{
	
}

class DgInfoXmlHandler extends DgXmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->DG_Info) && !empty($XMLRoot->DG_Info))
		{
			foreach($XMLRoot->DG_Info as $info)
		 	{
		 		$id = intval($info->DGID);
				if ($factory->hasObj($id)) {
					$DG = $factory->getObj($id);
					$DG->setDgInfo($info);
				}
				else {
					$DG = $this->getFactory()->createObj($id);
					$DG->setDgInfo($info);
				}
		 	}
		}
	}
}

class DgConfigXmlHandler extends DgXmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->DG_Config))
		{
			foreach ($XMLRoot->DG_Config as $dgConfig)
	 		{
	 			$id = intval($dgConfig->DGID);
				if ($factory->hasObj($id)) {
					$DG = $factory->getObj($id);
					$DG->setDgConfig($dgConfig);
				}
				else {
					$DG = $this->getFactory()->createObj($id);
					$DG->setDgConfig($dgConfig);
				}		
	 		}
		}
	}
}

?>