<?php
class ActionCreateDG extends UserAction 
{
	private $DGName;
	private $RaidMode;
	private $SubVDCount;
	private $NumParityDisk;
	private $StripeSize;
	private $Size;
	private $BlockSize;
	private $InitType;
	private $HDCount;
	private $HDIDs;
	private $HBAID;
	
	//config
	private $DG_ID;
	private $WriteCacheOn;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HBAID = $this->getAdapterID();
		$this->DGName = getRequestPara("DGName");
		$this->RaidMode = getRequestPara("RaidMode");
		$this->SubVDCount = getRequestPara("SubVDCount");
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID6 || $this->RaidMode == RAIDMode::LD_MODE_RAID60) {
			$this->NumParityDisk = getRequestPara("NumOfParityDisk");
		}
//		$this->InitType = getRequestPara("InitType");
		$this->HDIDs = trim(getRequestPara("HDIDs"));
		$this->StripeSize = getRequestPara("StripeSize");
		$this->BlockSize = getRequestPara("BlockSize");
		$this->WriteCacheOn = getRequestPara("EnableCache");
	}
	
	private function doCreateDG()
	{	
		//get old dg list before create
	/*	$dglist = new DgList(); 
		$dglist->toGetDGInfo();
		$dglist->initData();
		$old_dglist = $dglist->getBaseClasses();	*/
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_DG_Create);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		$this->ApiCmd->setCommandPara("Name",$this->DGName);
		$this->ApiCmd->setCommandPara("RaidMode",$this->RaidMode);
		$this->ApiCmd->setCommandPara("SubVDCount","");
		$this->ApiCmd->setCommandPara("NumParityDisk",$this->NumParityDisk);
		$this->ApiCmd->setCommandPara("StripeBlockSize",$this->StripeSize);//* UNIT_K
		$this->ApiCmd->setCommandPara("Size",$this->Size);
		$this->ApiCmd->setCommandPara("BlockSize",$this->BlockSize);//* UNIT_K
		$this->ApiCmd->setCommandPara("InitializationOption",$this->InitType);
				
		//HDCount
		$hds = explode(" ",$this->HDIDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$this->HDCount ++;
			}
		}

		$this->ApiCmd->setCommandPara("PDCount",$this->HDCount);
		$this->ApiCmd->setCommandPara("PDIDs",$this->HDIDs);
		
		$this->ApiCmd->issueCommand();
		if ($this->ApiCmd->getResult()->RetVal . "") {
			//var_dump($this->ApiCmd);
			$this->setCreateDGFail();//create dg
			return ;
		}
		//get new dg list after create
	/*	$dglist = new DgList(); 
		$dglist->toGetDGInfo();
		$dglist->initData();
		$new_dglist = $dglist->getBaseClasses();	
		foreach ($new_dglist as $new_dg){
			$notfound = true;
			foreach ($old_dglist as $old_dg){
				if($old_dg->getID() == $new_dg->getID()){
					$notfound = false;//find the new dg in old_dglist
					break;
				}
			}
			if($notfound == true){
				$this->DG_ID = $new_dg->getID();//find the DG new created 
			}			
		}*/
		$this->DG_ID = $this->ApiCmd->getResult()->CreateOrModifyDGParam->DGID;

		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_DG_SetConfig);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		$this->ApiCmd->setCommandPara("DG_ID",$this->DG_ID);
		$this->ApiCmd->setCommandPara("DGID",$this->DG_ID);
		$this->ApiCmd->setCommandPara("Name",$this->DGName);
		$this->ApiCmd->setCommandPara("WriteCacheOn",$this->WriteCacheOn);
		$this->ApiCmd->issueCommand();//set dg initialized config
		//var_dump($this->ApiCmd);
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setConfigDGFail();
		}
		else {
			$this->setCreateDGCmdXmlRetSuccess();
		}
	}
	
	private function setConfigDGFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getArraySubPage . "&ID=" . $this->DG_ID . "&HBAID=" . $this->HBAID;
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	private function setCreateDGCmdXmlRetSuccess()
	{
		$cmdName = getRequestPara("cmdName");
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		if($cmdName == APICmd::createDGSubmit){
			$this->xmlRet->Url = getBaseURL() .
				PHPPageName::TargetPageName ."?Target=" . Target::getArraySubPage . "&ID=" . $this->DG_ID. "&HBAID=" . $this->HBAID;
		}
		elseif ($cmdName == APICmd::createDGNext){			
			$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::CreateVdOnDgPage;
		}
	}
	
	private function setCreateDGFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	private function setCreateDGCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
		$Err = ComError::ERR_NO_RESOURCE_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	private function setHDSpareCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
		$Err = ComError::ERR_HD_IS_SPARE_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	private function setRaid0HDCountCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
		$Err = ComError::ERR_INVALID_HD_COUNT_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	//check raid 0 can not creat with only one disk
	//return false if not at least 2 disks are used for creating RAID0 VD;
	private function checkRaid0HDCount()
	{
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID0 ) {
			$HDs = explode(' ',$this->HDIDs);
			if (sizeof($HDs) == 1) {
				return false;
			}
		}
		
		return true;
	}
	
	
	public function doCheckSpare()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");

		include_once("../phpsrc/baseclass/HdList.class.php");
		
		$HdList = new HdList();
		$HdList->setAdapterID($this->HBAID);
		$HdList->toGetHDRaidStatus();
		
		$HDs = $HdList->getBaseClasses();
		$hds = explode(" ",$this->HDIDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				unset($Hd);
			}
		}
		foreach ($HDs as $HD)
		{
			if ($HD->isSpare()) {
				$HDID = trim($HD->getDeviceID());
				foreach ($hds as $id)
				{
					if ($HDID == $id) {
						return false;
					}
				}
			}
		}
		
		return true;
	}
	
	protected function doAction()
	{
		/*if (! $this->checkRaid0HDCount()) {
			
			//echo "CheckRaid0HDCount error";
			//check raid 0 can not creat with only one disk
			$this->setRaid0HDCountCheckFailXMLRet();
			return ;
		}*/
		
		if (! $this->doCheckSpare()) {
			//echo "CheckSpare error";
			// the create want to create is larger than max create size 
			// report resource unvaliable error.
			$this->setHDSpareCheckFailXMLRet();
			return;
		}
		$this->doCreateDG();
	}
}
?>