<?php

class EncInfoXmlHandler extends XmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		if (isset($XMLRoot->Enclosure_Info)) {
			foreach ($XMLRoot->Enclosure_Info as $Enc_Info)
			{				
		 		$id = intval($Enc_Info->Link->Self->DevID);
				if ($factory->hasObj($id)) {
					$Encl = $factory->getObj($id);
					$Encl->setEnclInfo($Enc_Info);
				}
				else {
					$Encl = $this->getFactory()->createObj($id);
					$Encl->setEnclInfo($Enc_Info);
				}
			}
		}
	}
}

class EncElementInfoXmlHandler extends XmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->EncElementType_Info)) {
			foreach ($XMLRoot->EncElementType_Info as $Ele_Info)
			{
				foreach ($factory->getBaseClasses() as $EncInfo)
				{
					$ElementList = $EncInfo->getElementList();
					$notfound = true;
					foreach ($ElementList as $element)
					{
						if ($element->getID() == intval($Ele_Info->ElementID)
							&& $element->getType() == intval($Ele_Info->Type)
							&& $EncInfo->getDeviceID() == intval($Ele_Info->EnclosureID)) 
						{
							$element->setEnclElementInfo($Ele_Info);
							$notfound = false;
							break;
						}
					}
					if ($notfound)
					{
						$element = new EnclElement();
						$element->setEnclElementInfo($Ele_Info);
						$EncInfo->addElement($element);
					}
				}
			}
		}
	}
}

class EncElementCfgXmlHandler extends XmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
				
		if (isset($XMLRoot->EncElement_Config)) {
			foreach ($XMLRoot->EncElement_Config as $Ele_cfg)
			{
				foreach ($factory->getBaseClasses() as $EncInfo)
				{
					$ElementList = $EncInfo->getElementList();
					$notfound = true;
					foreach ($ElementList as $element)
					{
						if ($element->getID() == intval($Ele_cfg->ElementID)
							&& $element->getType() == intval($Ele_cfg->Type)
							&& $EncInfo->getDeviceID() == intval($Ele_cfg->EnclosureID)) 
						{
							$element->setEnclElementCfg($Ele_cfg);
							$notfound = false;
							break;
						}
					}
					if ($notfound)
					{
						$element = new EnclElement();
						$element->setEnclElementCfg($Ele_cfg);
						$EncInfo->addElement($element);
					}
				}
			}
		}
	}
}

?>