<?php

abstract class LdBase  extends BaseFactory
{
	public function toGetLDInfo()
	{
		$handler = new LdInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_LD_GetInfo, $handler);
	}
	
	public function toGetLDStatus()
	{
		$handler = new LdStatusXmlHandler();
		$this->runCommand(XMLAPICommand::MV_LD_GetStatus, $handler);		
	}	
	
	public function toGetLDConfig()
	{		
		$handler = new LdConfigXmlHandler();
		$this->runCommand(XMLAPICommand::MV_LD_GetConfig, $handler);
	}
	
	public function toGetBlockInfo()
	{
		$blkList = new BlockList();
		$blkList->setAdapterID($this->getAdapterID());
		$blkList->toGetBlkInfo();
		
		foreach ($this->BaseClasses as $LD)
		{
			$blkIds = $LD->getBlockIDList();
			foreach ($blkIds as $id)
			{
				$blk = $blkList->getObj($id);
				if ($blk) {
					$LD->addBlock($blk);
				}
			}
		}
	}
	
	public function toGetHDInfo()
	{
		$hdList = new HdList();
		$hdList->setAdapterID($this->getAdapterID());
		$hdList->toGetHDInfo();
		
		foreach ($this->BaseClasses as $LD)
		{
			$blks = $LD->getBlockList();
			
			foreach ($blks as $blk)
			{
				$hd = $hdList->getObj($blk->getHDID());
				if($hd) {
					$blk->linkHD($hd);
				}
			}
		}
	}
	
	protected function createObject()
	{
		return new LD();
	}
}

?>