<?php
class LdOnDgInfo
{
	public $ID=0;
	public $DGID=0;
	public $Name=0;
	public $StatusString=0;
	public $StatusInt=0;
	public $Size=0;
	public $SizeGB = 0;
	public $MemberCount=0;
	public $StripSize=0;
	public $RaidMode=0;
	public $RaidModeInt = 0;
	public $Bga=0;
	public $BgaString = 0;
	public $BgaStatusString = 0;
	public $BgaPercentage=0;
	public $BgaStateInt=0;
	public $BgaStateString=0;
//	public $AutoRebuildOn = 0;
	public $WriteCache=0;
	public $WriteCacheStatus=0;
	public $WriteCacheBit;
	public $WriteCacheStr = "";
	public $ReadCache=0;
	public $SectorSize=0;
	//public $CacheEnable=1;
	public $setEnable=0;
	
	
	public $LDImg = "";
	public $LeftBGAStr = "";
	public $RightBGAStr = "";
	
	
	//details	
	public $Adapters;
	
	public $enableInit = 0;
	public $enableCheck = 0;
	public $enableDelete = 0;
	
	
	public $enableStop = 0;
	public $enableResume = 0;
	public $enablePause = 0;
	public $enableRestart = 0;
	
	public $TargetLDRaidMode;
	public $TargetLDRaidModeInt;
	public $TargetLDSize;
	public $TargetLDSizeGB;
	public $IsMigrating = 0;
	
	public $needReport = 0;
	
	public $AdapterID;
	public $ConflictVDsList = array();
	public $LastWriteTime;
	
	public function __construct()
	{
		$this->Adapters = array();
	}
	
	public function setMigrateTargetLdOnDg($TargetLD)
	{
		$this->IsMigrating = 1;
		$this->TargetLDRaidModeInt = $TargetLD->getRaid_Level();
		$this->TargetLDRaidMode = RAIDMode::GetRAIDModeStr($TargetLD->getRaid_Level());
		$this->TargetLDSize = ConvertSize($TargetLD->getSize());
		$this->TargetLDSizeGB = FormatSize($TargetLD->getSize());
		//$this->TargetStatusString = gettext(LDStatus::getLDStatusStr($TargetLD->getStatus()));
	}
	
	public function setLdOnDgInfo($LD)
	{
		$this->ID = $LD->getID();
		$this->DGID = $LD->getDGID();
		$this->Name = htmlspecialchars(trim($LD->getName()),ENT_QUOTES);
		$this->StatusInt = $LD->getStatus();
		$this->needReport = ($this->StatusInt == LDStatus::LD_STATUS_CONFLICTED 
							|| $this->StatusInt == LDStatus::LD_STATUS_DEGRADE_PLUGIN)?1:0;
		$this->ConflictVDsList = $LD->getConflictVDsList();
		$this->LastWriteTime = $LD->getLastWriteTime();
		
		$this->AdapterID = $LD->getAdapterID();
		
		$this->SizeGB = FormatSize($LD->getSize());
		$this->Size = ConvertSize($LD->getSize());
		
		$this->RaidModeInt = $LD->getRaid_Level();
		$this->RaidMode = RAIDMode::GetRAIDModeStr($LD->getRaid_Level());
		$this->BGAStatus = $LD->getBGAStatus();
		
		$this->Bga = $LD->getBga();
		$this->BgaPercentage = $LD->getBgaPercentage();
		$this->BgaStateInt = $LD->getBgaState();
		
		$this->LDImg = LDStatus::getLDImg($this->StatusInt, $this->BgaStateInt);		
		if ($this->StatusInt == LDStatus::LD_STATUS_DEGRADED 
			||$this->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL 
			//||$this->StatusInt == LDStatus::LD_STATUS_MIGRATION 
			||$this->StatusInt == LDStatus::LD_STATUS_PARTIALLYOPTIMAL 
			||$this->StatusInt == LDStatus::LD_STATUS_OFFLINE )  //default can not set config
		{
			$this->setEnable = 1;
		}
		//add check for driver may return bad bga state or bga status
		$this->BgaCheck();
	
		//set bga strings
		$this->setBGAStrings();
		
		//enable buttons
		$isAdmin = getSessionPara('isAdmin');
		if ($isAdmin) {
			if ($this->RaidModeInt != RAIDMode::LD_MODE_RAID0 
				&& $this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE ) {
					//init button
				if ($this->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL) {
					$this->enableInit = 1;	
					$this->enableCheck = 1;
				}
			}
			$this->enableDelete = 1;
			//bga control btn	
			if ($this->Bga == LdBgaStatus::LD_BGA_INIT_BACK 
				|| $this->Bga == LdBgaStatus::LD_BGA_INIT_FORE 
				|| $this->Bga == LdBgaStatus::LD_BGA_CONSISTENCY_CHECK 
				|| $this->Bga == LdBgaStatus::LD_BGA_CONSISTENCY_FIX ) {
				if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING) {
					if ($this->Bga != LdBgaStatus::LD_BGA_INIT_FORE) //foreground init can not stop
						$this->enableStop = 1;	
					$this->enablePause = 1;
				}
				if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_PAUSED || $this->BgaStateInt == LdBgaState::LD_BGA_STATE_AUTOPAUSED ) {
					$this->enableResume = 1;					
				} 
				if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_ABORTED) {
					$this->enableRestart = 1;
				}
			}
		}
	}
	
	public function setLdOnDgDtl($LD)
	{
		$this->StripSize = $LD->getStripeBlockSize() . " K";
		$this->SectorSize = $LD->getSectorSize() . " B";
		$this->MemberCount = $LD->getHDCount();
		
		$this->WriteCache = $LD->getWriteCache();
		$this->WriteCacheStatus = $LD->getWriteCacheStatus();
		if ($this->WriteCache & LDCacheMode::AUTO_ENABLE) $this->WriteCacheBit = LDCacheMode::AUTO_ENABLE;
		else $this->WriteCacheBit = $this->WriteCache;
		$this->WriteCacheStr = LDCacheMode::getWriteCacheModeStr($this->WriteCacheStatus);
		
		$this->ReadCache = $LD->getReadCache();

		$this->AutoRebuildOn = $LD->isAutoRebuildOn();

		//ld disks 
		$HDs = array();
		$Blks = $LD->getBlockList();
		foreach ($Blks as $Blk)
		{
			$HD = $Blk->belongHD();
			//var_dump($HD);
			if ($HD) {
				$notfound = true;
				foreach ($this->Adapters as $adpater)
				{
					if (intval($adpater->AdapterID) == $HD->getAdapterID()) {
						$disk = new Disk();
						if(($Blk->getFlag()) & (BlockFlag::BLOCK_FLAG_REBUILDING)){
							$disk->setRebuildingFlag();
						}
						$disk->setDisk($HD);
						$disk->LDUsedSize = FormatSize($Blk->getSize());
						$adpater->HDs[$HD->getDeviceID()] = $disk;
						$notfound = false;
					}
				}
				if ($notfound) {
					$adpater = new LDAdapter();
					$adpater->AdapterID = $HD->getAdapterID();
					$disk = new Disk();
					if(($Blk->getFlag()) & (BlockFlag::BLOCK_FLAG_REBUILDING)){
						$disk->setRebuildingFlag();
					}
					$disk->setDisk($HD);
					$disk->LDUsedSize = FormatSize($Blk->getSize());
					$adpater->HDs[$HD->getDeviceID()] = $disk;
					$this->Adapters[$adpater->AdapterID] = $adpater;
				}
			}
		}
		foreach ($this->Adapters as $adpater)
		{
			ksort($adpater->HDs);
		}
		ksort($this->Adapters);
		
		//enable buttons
	//	$this->enableButtons();
	}
	
	private function setBGAStrings()
	{
		$TmpStr = LDStatus::getLDStatusStr($this->StatusInt);
		$this->StatusString = gettext($TmpStr);
		
		$TmpStr = LdBgaStatus::getLdBgaString($this->Bga);
		$this->BgaString = gettext($TmpStr);
		
		$TmpStr = LdBgaStatus::getLdBgaStatusStr($this->Bga);
		$this->BgaStatusString = gettext($TmpStr);
		
		if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING ||
			$this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE )
		{
			$this->BgaStateString = "";
		}
		else {
			$TmpStr = LdBgaState::getLdBgaStateStr($this->BgaStateInt);
			$this->BgaStateString = gettext($TmpStr);	
		}
	}
	
	private function BgaCheck()
	{
		if (($this->Bga == LdBgaStatus::LD_BGA_NONE) || ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE)) {
			$this->Bga = LdBgaStatus::LD_BGA_NONE ;
			$this->BgaStateInt = LdBgaState::LD_BGA_STATE_NONE ;
			$this->BgaPercentage = 0;
		}
	}

}

?>