<?php

class SystemSettingDataAccess extends XMLDataAccess 
{
	public function __construct($fileName=null)
	{
		$this->eleName = "System";
		$this->parentName = 'SystemSetting';
		if ($fileName) {
			$this->fileName = $fileName;	
		}
		else {
                        $this->fileName = realpath("../db/db.xml");
		}
		
		parent::__construct($this->fileName);
	}
	
	public function __destruct()
	{
		parent::__destruct();
	}
	
	public function getSystemSetting()
	{
		$dataArray = array('mykeys' => array());
		
		$sys = $this->query($dataArray);
		
		if ($sys) {
			return $sys[0];
		}
		
		return false;
	}
	
	public function updateEventReadIndex($EventReadIndex)
	{
		$dataArray = array('mykeys' => array(),'myvalues' => array('EventReadIndex' => $EventReadIndex));
		
		return $this->update($dataArray);
	}
	
	/*public function updateDefaultUserName($UserName)
	{
		$dataArray = array('mykeys' => array(),'myvalues' => array('LastLoginUser' => $UserName));
		
		return $this->update($dataArray);
	}
	
	public function getDefaultUserName()
	{
		$data = array('mykeys' => array());
		$setting = $this->query($data);
		if sizeof($setting)
		{
		    return $setting['LastLoginUser'];
	    }
	    else
	    {return '';}
	}*/
	
	public function updateMailSetting($userName,$passwd,$port,$serverAddr,$isSSL)
    {
        //encode password
        $XMLApiCmd = new XMLAPICommand();
        $XMLApiCmd->setCommand(XMLAPICommand::MV_StringEncode);
        $XMLApiCmd->setCommandPara("szsource", $passwd);
            
        $retVal = -1;
        if ($XMLApiCmd->issueCommand()) {
            $XMLRoot = $XMLApiCmd->getResult();
            $retVal = $XMLRoot->RetVal;
        }

        if (intval($retVal) == 0) {
            $passwd = $XMLRoot->sztarget;
        }
        //encode password

		$dataArray = array('mykeys' => array(),
			'myvalues' => array('userName' => $userName, 
						'passwd' => $passwd, 'port' => $port, 'serverAddr' => $serverAddr, 'isSSL'=>$isSSL));
		
		return $this->update($dataArray);;
	}
	
	protected function dataWrapper($element)
	{
		return SystemSetting::createFromXMLElement($element);
	}
}

?>
