
var DgTree = new Object();
DgTree.objTreeMenu = null;
DgTree.treeRoot = null;
DgTree.vdBranch = null;
DgTree.pdBranch = null;

DgTree.clickItem=function(item)
{
	//set node css
	if (item) {
		var otherItems = document.getElementsByTagName('span');
		for (i=0; i < otherItems.length; i++)
		{
			otherItems[i].className = '';
		}
		item.className = 'selectedTreeNode';
	}
}

DgTree.runDgInfoXML=function(id){
	DgInfo.DgID = id;
	DgInfo.run();
}

DgTree.runVdInfoXML=function(id){
	VdInfo.VdID = id;
	VdInfo.run();
}

DgTree.runPdInfoXML=function(id){
	PdInfo.PdID = id;
	PdInfo.run();
}

DgTree.setRoot=function(objTree, id, img){
	DgTree.treeRoot = objTree.addItem(new TreeNode('Array ' + id, img, '#', true, true, '', '', img));
	DgTree.treeRoot.setEvent('onmouseover', '');
	DgTree.treeRoot.setEvent('onmouseout', '');
	DgTree.treeRoot.setEvent('onclick', "DgTree.clickItem(this); DgTree.runDgInfoXML("+id+");");
	return DgTree.treeRoot;
}

DgTree.setVdBranch=function()
{
	return (DgTree.treeRoot.addItem(new TreeNode('Virtual Disks', null, '#', true, true, '', '', null)));
}

DgTree.setChildVD=function(parentNode, id, img){ //'RAID_online.gif'
	newNode = new TreeNode('Virtual disk ' + id, img, '#', true, true, '', '', img);
	childVD = parentNode.addItem(newNode);
	childVD.setEvent('onmouseover', '');
	childVD.setEvent('onmouseout', '');
	childVD.setEvent('onclick', "DgTree.clickItem(this);DgTree.runVdInfoXML("+id+");");
}

DgTree.setPdBranch=function()
{
	return (DgTree.treeRoot.addItem(new TreeNode('Physical Disks', null, '#', true, true, '', '', null)));
}

DgTree.setChildPD=function(parentNode, id, img){
	childPD = parentNode.addItem(new TreeNode('Physical disk ' + id, img, '#', true, true, '', '', img));
	childPD.setEvent('onmouseover', '');
	childPD.setEvent('onmouseout', '');
	childPD.setEvent('onclick', "DgTree.clickItem(this);DgTree.runPdInfoXML("+id+");");
}

DgTree.drawTree=function()
{
	var treePart = document.getElementById("treePart");
	DgTree.objTreeMenu.drawMenu();	
	treePart.innerHTML = DgTree.objTreeMenu.output;
	DgTree.objTreeMenu.resetBranches();
}

function buildDgTree()
{
	DgTree.objTreeMenu = new TreeMenu("images", "DgTree.objTreeMenu", "_self", "treeMenuDefault", true, false);
}

function destroyDgTree()
{
	DgTree.objTreeMenu = null;
}

addOnLoadListener(buildDgTree);
addUnLoad(destroyDgTree);