<?php
//include_once("PageDisplayer.class.php");

class PgMigrateDgDisplayer extends PgMigrateDisplayer
{
	protected function setDisplayInfo()
	{
		parent::setDisplayInfo();
		$this->smarty->assign("isDGBGA", 1);
		$this->smarty->assign("ScheduledBgaType",ScheduledBGAType::DG_BGA_MIGRATION);
	}
	
	protected function setInfo()
	{
		$smarty = $this->smarty;
		
		//$MigrateDG = 1;
		$ID = getRequestPara('ID');
		$HBAID = $this->getAdapterID();
		if ($ID == null) {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$container = new CtnDgDetail($HBAID);
		$container->setAdapterID($HBAID);
		$container->setDGID($ID);
		$container->toGetDGInfo();
		$container->toGetDGConfig();
		$container->toGetDgLDInfo();
		$container->toGetDgHDInfo();
		$container->smartyAssign($smarty);
		$container->initContainer();
		
		$dglist = $container->getBase()->getBaseClasses();
		if (!sizeof($dglist)) {
			//this DG not exist
			$DGnotExist = new DgInfo();
			$DGnotExist->ID = gettext('Not Exist');
			$DGnotExist->SizeGB = '';
			$DGnotExist->RaidMode = '';
			$smarty->assign('dgDtl',$DGnotExist);
			$smarty->assign('DGNotExist',1);
		}
		else {
			$dgDetail = array_shift($dglist);
			$hds = $dgDetail->getHDList();
			$hdList = new CtnHdList();
			
			if($hds)
			{
				$filter = new HdMigrateFilter($dgDetail->getSmallestAvailablePDSize(), $hds);
				
				$hdList->setAdapterID($HBAID);
				$hdList->toGetHDInfo();
				$hdList->toGetValidSize();
				$hdList->toGetSpareInfo();
				$hdList->toGetHdFreeInfo();
				$hdList->setFilter($filter);
				$hdList->smartyAssign($smarty);
				$hdList->initContainer();
			}
			$hba = HBAFactory::getInstance($HBAID);
			if ($hba) {
				//raid mode can be migrated to
				$this->setMigrateRaidModes($hba,$dgDetail);
			}
			
		}
			
    	$CancelAlert = gettext(AlertMsg::MIGRATE_CANCEL)."?";
    	$smarty->assign("CancelAlert",$CancelAlert);
		$smarty->assign("ID", $ID);
    	$smarty->assign("HBAID",$HBAID);
	}
	
	protected function setMigrateRaidModes($hba,$dgDetail)
	{
		$supportRaids = array();
		//raid 0 can be migrated to all raid level
		//Allows migrate to the same or higher redundant mode only (if source VD is not RAID50 or RAID60). 
		//For example, RAID1 to RAID5 is okay but not vice versa.  Treat RAID10 and RAID1E as RAID1. 
		//raid 50 and raid 60 can not do migration now
		//the following are migration support table
		/*
		            	From
		 TO				JBOD   Raid0 Raid1/1E Raid10   Raid5  Raid50  Raid6 Raid60             
		 JBOD            No     No    No       No       No     No      No    No                
		 Raid0           No     Yes   No       No       No     No      No    No                
		 Raid1/1E        No     Yes   Yes      Yes      No     No      No    No                
		 Raid10          No     Yes   Yes      Yes      No     No      No    No                
		 Raid5           No     Yes   Yes      Yes      Yes    No      No    No                
		 Raid50          No     Yes   Yes      Yes      Yes    No      No    No                
		 Raid6           No     Yes   Yes      Yes      Yes    No      Yes   No                
		 Raid60          No     Yes   Yes      Yes      Yes    No      Yes   No    
		*/
		if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID0) {
			if ($hba->supportLDRaid0()) {
				$supportRaids[RAIDMode::LD_MODE_RAID0] = RAIDMode::RAID0;
			}
		/*	if ($hba->supportLDRaid1()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
			}*/ //R0 should can not migrate to R1
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid5()) {//&& $dgDetail->getStripeBlockSize() == LDStripeSize::StripeSize64K
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {// && $dgDetail->getStripeBlockSize() == LDStripeSize::StripeSize64K 
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {// && $dgDetail->getStripeBlockSize() == LDStripeSize::StripeSize64K
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {// && $dgDetail->getStripeBlockSize() == LDStripeSize::StripeSize64K
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID1) 
		{
//			if ($hba->supportLDRaid1()) {
//				$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
//			}//R1 should can not migrate to R1, for the original member disks can not remove
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID10) 
		{
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID1E) 
		{
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID5) 
		{
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID6) 
		{
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID50) 
		{
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($dgDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID60) 
		{
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		
		$this->smarty->assign("supportRaids", $supportRaids);
	}
}
?>