<?php
class HDInfo extends DevInfo
{
	public $ID = 0;
	public $Name = 0;
	public $Type = 0;
	public $AdapterID = 0;
	public $TotalCapacity = 0;
	public $UsedCapacity = 0;
	public $ValidCapacity = 0;

	//not used
	public $Status;
	
	public $StatusStr = 0;
	public $isOffline = 0;
    public $IsAssigned = 0;
	
	//spare info
	public $IsSpare = 0;
	public $IsSpareStr = 'No';
	public $CanSpare = 0;
	
	//free
	public $IsFree = 0;
	
	//config
	public $WriteCacheOn = 0;
        public $crypto;
        public $cryptoStatusStr;
        public $aesPercentage;
	
	public $PIOMode = 0;
	public $MDMAMode = 0;
	public $UDMAMode = 0;
	
	public $CurrentPIOMode = 0;
	public $CurrentMDMAMode = 0;
	public $CurrentUDMAMode = 0;
	
	public $FirmWareVersion = 0;
	public $SerialNo = 0;
	public $Model = 0;
	public $Features = '';
	public $WWN;

	public $IsPATA;
	public $CanLogicalUsed;
	public $canChangeCfg=0;
	
	//current speed features supported
	public $SupportSpeed = '';
	public $CurrentSpeed = '';
	
	//media patrol
	public $MPStateInt = 0;
	public $MPStateStr = 0;
	public $MPPercentage = 0;
	public $MPString = 0;
	public $canMediaPatrol = 0;
	public $canDataScrub = 0;//for spare PD
	public $canWipe = 0;
	public $canLocate = 0;
	public $canSetFree = 0;
	
	//bga related
	public $BgaPercentage;
	public $Bga;
	public $BgaString;
	public $BgaState;
	public $BgaStateString;
	
	public $enableStop = 0;
	public $enableResume = 0;
	public $enablePause = 0;
	public $enableRestart = 0;
	
	public $HDImg;
	public $LEDStatus;
	public $LEDStatusStr;
	public $LEDImg;
	public $UseThorSizePolicy;
	public $IsSSD;
	public $SSDType;
	public $SSDTypeStr;
        public $enableForceOnline = 0;
        public $needForceOnlinePercentage = 0;
    //for oem lenovo
    public $Fru;
    public $Mfa;
    public $Lenovo_8S_l2_PN;
    public $Lenovo_8S_SN;
    public $PD_status;
	
	public function setHDInfo($HD)
	{	
		$this->ID = $HD->getDeviceID();
		$this->Name = $HD->getName();
		$this->AdapterID = $HD->getAdapterID();
		$this->IsSSD = $HD->isSSD();
		//if ($this->ID == 1) $this->IsSSD = 1; //test codes
		//SLC - 1, MLC - 2, tmp tmp
		$this->SSDTypeStr = SSDNANDType::getTypeStr($HD->getSSDType()+1);
		
		//use 1024*1024*1024 if is Thor
		$sysFeature = AdapterFeature::getInstance($this->AdapterID);
		$this->UseThorSizePolicy = $sysFeature->isThor;
		
		//if tape
		if ($HD->isTAPE() || $HD->isEnclosure() || $HD->isCDDVD()) 
		{
			$this->TotalCapacity = gettext('N/A');
			$this->ValidCapacity = gettext('N/A');
		}
		else {
			$this->TotalCapacity = FormatSize($HD->getSize(),$this->UseThorSizePolicy);
			$this->ValidCapacity = FormatSize($HD->getValidSize(),$this->UseThorSizePolicy);
		}
		
		$this->UsedCapacity = FormatSize($HD->getSize() - $HD->getValidSize(),$this->UseThorSizePolicy);
				
		//set status info
		//$this->StatusInt = $HD->getStatus();
		if ($HD->isOffline()) {
			$this->StatusStr = HdStatus::HD_STATUS_OFFLINE_STR;
		}elseif ($HD->isForeign()){
			$this->StatusStr = HdStatus::HD_STATUS_FOREIGN_STR;
		}elseif ($HD->isAssigned() || (!$HD->isFree()))
		{
			$this->StatusStr = HdStatus::HD_STATUS_ASSIGNED_STR;
		}else {
			$this->StatusStr = HdStatus::HD_STATUS_FREE_STR;
		}
		$this->StatusStr = gettext($this->StatusStr);
		
		//free
		$this->IsFree = $HD->isFree();	
		$this->isOffline = $HD->isOffline();
        $this->IsAssigned = $HD->isAssigned();
		
		$this->setSpareString($HD);

		//set hd img
		$this->setHDImg($HD);
		
		//set type string
		$this->setHDTypeString($HD);
		
		$this->setBgaStatus($HD);
		
		$this->SerialNo = htmlspecialchars(trim($HD->getSerialNo()),ENT_QUOTES);
		$this->Model = htmlspecialchars(trim($HD->getModel()),ENT_QUOTES);		
		
		$this->LEDStatus = $HD->getLEDStatus();
		if ($this->LEDStatus)
			$this->LEDStatusStr = gettext("Locate on");
		else 
			$this->LEDStatusStr = gettext("Locate off");
		$this->LEDImg = LEDStatus::GetLEDImg($this->LEDStatus);
	}
	
	public function setHDDtl($HD)
	{
		$this->aesPercentage = $HD->getAesPercentage();
                
		$this->crypto = $HD->getCrypto();
                $this->cryptoStatusStr = AESCryptoStatus::getAesCryptoStatusStr($this->crypto);

                if ($HD->isOffline())
                    $this->enableForceOnline = 1;

                if ($this->cryptoStatusStr != AESCryptoStatus::HD_AES_CRYPTO_STR)  //plain disk to cripto need percentage, cipher mismatched also
                    $this->needForceOnlinePercentage = 1;
                
		$this->WriteCacheOn = $HD->isWriteCacheOn();
		$this->PIOMode = $HD->getPIOMode();
		$this->MDMAMode = $HD->getMDMAMode();
		$this->UDMAMode = $HD->getUDMAMode();
		$this->CurrentPIOMode = $HD->getCurrentPIOMode();
		$this->CurrentMDMAMode = $HD->getCurrentMDMAMode();
		$this->CurrentUDMAMode = $HD->getCurrentUDMAMode();
		$this->FirmWareVersion = $HD->getFirmWareVersion();
		$this->WWN = $HD->getWWN();
		
		//convert WWN
		//$this->convertWWN();
		
		$this->setCanChangeCfg($HD);
		
		$this->IsPATA = $HD->isPATA();
		
		// hd support features
		$this->setFeaturesStr($HD);
		
		//set support speed and current speed str
		$this->setSpeedStr($HD);
		
		$this->setConnectInfo($HD);
		
		$this->setBgaStatus($HD);

		//enable buttons	
		$this->enableButtons($HD);

        //for oem lenovo
		$this->Fru = $HD->getFru();
		$this->Mfa = $HD->getMfa();
		$this->Lenovo_8S_l2_PN = $HD->getLenovo_8S_l2_PN();
		$this->Lenovo_8S_SN = $HD->getLenovo_8S_SN();
		$this->PD_status = $HD->getPD_status();
	}
	
	private function setCanChangeCfg($HD)
	{
		$isMember = 0;
		$adapterFeature = AdapterFeature::getInstance($HD->getAdapterID());
		if ($adapterFeature->supportRAID) {
			if ($adapterFeature->supportDG) {
				$dglist = new DgList();
				$dglist->setAdapterID($HD->getAdapterID());
				$dglist->toGetDGInfo();
				$dglist->toGetDgHDInfo();
				
				foreach ($dglist->getBaseClasses() as $dg)
				{
					foreach ($dg->getHDList() as $hd)
					{
						if ($hd->getDeviceID() == $HD->getDeviceID()) {
							$isMember = 1;
							break;
						}
					}
					if ($isMember) {
						break;
					}
				}
			}
			
			$this->canChangeCfg = $HD->canLogicalUsed() 
								  && (! $HD->isOffline()) && (! $HD->isForeign()) && !$isMember//($HD->isAssigned() || $HD->isFree() || $HD->isSpare() || $HD->isMP() || $HD->isSmartChecking())
								  && getSessionPara('isAdmin'); //(! $HD->isOffline()) && (! $HD->isForeign())
		} else {
			$this->canChangeCfg = 1;//set non-RAID can config
		}
	}
	
	private function setSpareString($HD)
	{
		$this->IsSpare = $HD->isSpare();
		if ($HD->isSpare()) {
			if ($HD->isGlobalSpare()) {
				$this->IsSpareStr = gettext("Global");
			}
			else if ($HD->isDedicatedSpare()) {
                $objStr = "array";
		        $sysFeature = AdapterFeature::getInstance($this->AdapterID);
                if ($sysFeature->supportPackageVD){
                    $objStr = "virtual disk";
                }
				if ($HD->getDedicatedDGID() == 65535) {
					$this->IsSpareStr = gettext("Dedicated to an unknown " . $objStr);
				} else {
					$this->IsSpareStr = gettext("Dedicated to " . $objStr . " ") . $HD->getDedicatedDGID();
				}	
			}
		}
		else {
			$this->IsSpareStr = gettext("No");
		}
	}
	
	private function setBgaStatus($HD)
	{
		$this->Bga = $HD->getBga();
		$this->BgaState = $HD->getBgaState();
		$this->BgaPercentage = $HD->getPercentage();
		
		$this->BgaString = gettext(HdBgaStatus::getHdBgaStatusStr($this->Bga));
		if($this->BgaState == HdBgaState::HD_BGA_STATE_RUNNING ||
				$this->BgaState == HdBgaState::HD_BGA_STATE_NONE )
		{
			$this->BgaStateString = "";
		}
		else
		{
			$this->BgaStateString = gettext(HdBgaState::getHdBgaStatusStr($this->BgaState));
		}
	}
	
	private function enableButtons($HD)
	{
		$isAdmin = getSessionPara('isAdmin');
		$hbaFeature = AdapterFeature::getInstance($HD->getAdapterID());
		
		if (!$isAdmin) {
			//if not administrator, no priviledge allowed.
			return;
		}
		
		if ($this->BgaState == HdBgaState::HD_BGA_STATE_RUNNING) 
		{
			$this->enableStop = 1;	
			$this->enablePause = 1;
		}
		
		if (($this->BgaState == HdBgaState::HD_BGA_STATE_PAUSED
			|| $this->BgaState == HdBgaState::HD_BGA_STATE_AUTOPAUSED)) {
			$this->enableResume = 1;
		}
		
		/*if ($this->BgaState == HdBgaState::HD_BGA_STATE_ABORTED && $isAdmin) {
			$this->enableRestart = 1;
		}*/		
		
		if ( $HD->canLogicalUsed()
			&& (! $HD->isOffline())
			&& (! $HD->isForeign())
			&& $HD->isFree()
			&& !$HD->isSpare()
			&& (! $HD->isAssigned())
			) {
			$this->CanSpare = 1;
		}
		
		if(($HD->canLogicalUsed())
			&& (! $HD->isOffline())
			&& (! $HD->isForeign())
			&& (! $HD->isFree() || $HD->isAssigned() || $HD->isSpare())
			//Media Patrol can be performed on the PD which is spare drive or is part of a VD
			&& $this->BgaState == HdBgaState::HD_BGA_STATE_NONE
			)
		{
			//if ($hbaFeature->isSupportMediaPatrol()) {
				$this->canMediaPatrol = 1;
			//}
		}
		
		if ($HD->isSpare() && $HD->isFree()
			//Data Scrubbing can only be performed on an unassigned spare drive
			&& (! $HD->isOffline())
			&& (! $HD->isForeign())
			&& $this->BgaState == HdBgaState::HD_BGA_STATE_NONE
		) {
			//if ($hbaFeature->isSupportDG()) {
				$this->canDataScrub = 1;
			//}
		}
		
		if ($HD->isOffline() && $hbaFeature->supportHDSetFree) {//only offline disks can be set free
			$this->canSetFree = 1;
		}		
		
		if ($HD->isForeign()){ //foreign disks can noly wipe
			$this->canWipe = 1;
		}
		
		$parentDev = $HD->getParentDevice();		
		if (($HD->getConnectionType() & DCType::DC_SGPIO)
			|| (isset($parentDev) 
				&& ($parentDev->getDevType() == DeviceType::DEVICE_TYPE_EXPANDER))
			|| (isset($parentDev) 
				&& ($parentDev->getDevType() == DeviceType::DEVICE_TYPE_ENCLOSURE))
			|| (isset($parentDev)
				&& ($parentDev->getDevType() == DeviceType::DEVICE_TYPE_I2C_ENCLOSURE))
			){
			//  can locate
			$this->canLocate = 1;
		}
	}
	
	/*private function convertWWN()
	{
		if (trim($this->WWN)) 
		{
			$idArr = explode(' ',trim($this->WWN),8);
		
			$idArr = array_reverse($idArr);
			
			$this->WWN = sprintf("%02X%02X%02X%02X%02X%02X%02X%02X", 
				$idArr[0], $idArr[1],$idArr[2],$idArr[3],
				$idArr[4],$idArr[5],$idArr[6],$idArr[7]);
		}
	}*/
	
	private function setSpeedStr($HD)
	{
		$this->SupportSpeed = array();
		
		if ($HD->support1_5G())
		{
			$this->SupportSpeed[HdSpeed::HD_SPEED_1_5G] = HdFeature::STR_HD_FEATURE_1_5G;
		}
		if ($HD->support3G()) 
		{
			$this->SupportSpeed[HdSpeed::HD_SPEED_3G] = HdFeature::STR_HD_FEATURE_3G;
		}
		if ($HD->support6G()) 
		{
			$this->SupportSpeed[HdSpeed::HD_SPEED_6G] = HdFeature::STR_HD_FEATURE_6G;
		}
		if ($HD->support12G())
		{
			$this->SupportSpeed[HdSpeed::HD_SPEED_12G] = HdFeature::STR_HD_FEATURE_12G;
		}
		
		if ($HD->is3GEnable())
		{
			$this->CurrentSpeed = HdSpeed::HD_SPEED_3G;
		}
		else if ($HD->is6GEnable()) 
		{
			$this->CurrentSpeed = HdSpeed::HD_SPEED_6G;
		}
		else if ($HD->is12GEnable())
		{
			$this->CurrentSpeed = HdSpeed::HD_SPEED_12G;
		}
		else
		{
			$this->CurrentSpeed = HdSpeed::HD_SPEED_1_5G;
		}
	}
	
	private function setFeaturesStr($HD)
	{
		if ($HD->supportNCQ()) {
			$this->Features = HdFeature::STR_HD_FEATURE_NCQ;
		}
		if ($HD->supportTCQ()) {
			$this->Features .= " " . HdFeature::STR_HD_FEATURE_TCQ;
		}
		if ($HD->support1_5G()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_1_5G;
		}
		if ($HD->support3G()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_3G;
		}
		if ($HD->support6G()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_6G;
		}
		if ($HD->support12G()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_12G;
		}
		if ($HD->support48BITS()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_48BITS;
		}
		$this->Features = trim($this->Features);
		if ( ! $this->Features ) {
			$this->Features = gettext("None");
		}
		/*
		if ($HD->supportWRITE_CACHE()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_WRITE_CACHE;
		}
		
		if ($HD->supportSMART()) {
			$this->Features .= " " .HdFeature::STR_HD_FEATURE_SMART;
		}
		*/
	}
	
	private function setHDTypeString($HD)
	{
		$this->Type = DCType::getDCTypeStr($HD->getConnectionType());
		
			//. ' ' .DTType::getDTType($HD->getDeviceType());
		//$this->Type = HdType::getHdTypeStr($HD->getType());
		if ($this->IsSSD)
			$this->Type = "SSD";
	}
	
	private function setHDImg($HD)
	{
		switch ($HD->getDeviceType())
		{
			case DTType::DT_CD_DVD :
				$this->HDImg = "cd_dvd.gif";
				break;
//			case DTType::DT_ENCLOSURE :
//				$this->HDImg = "Enclosure.gif";
//				break;
			case DTType::DT_SEQ_ACCESS :
				$this->HDImg = "Tape.gif";
				break;
			case DTType::DT_DIRECT_ACCESS_BLOCK :
				$this->setPDImg($HD);
		}
	}

	private function setPDImg($HD)
	{
		if ($HD->isOffline()) {
			if ($this->IsSSD) {
				$this->HDImg = HdStatus::HD_SSD_STATUS_OFFLINE_IMG;
			} else {
				$this->HDImg = HdStatus::HD_STATUS_OFFLINE_IMG;
			}
		}elseif ($HD->isForeign()) {
			$this->HDImg = HdStatus::HD_STATUS_FOREIGN_IMG ;
		}
		else 
		{
			//if not offline
			if ($HD->isFree() && !$HD->isAssigned()) {
				if ($this->IsSpare)
					$this->HDImg = HdStatus::HD_STATUS_SPARE_IMG ;
				else {
					if ($this->IsSSD) {
						$this->HDImg = HdStatus::HD_SSD_STATUS_FREE_IMG;
					} else {
						$this->HDImg = HdStatus::HD_STATUS_FREE_IMG;
					}
				}
			}
			else {
				if ($this->IsSpare)
					$this->HDImg = HdStatus::HD_STATUS_ASSIGNED_SPARE_IMG ;
				else {
					if ($this->IsSSD) {
						$this->HDImg = HdStatus::HD_SSD_STATUS_ASSIGNED_IMG;
					} else {
						$this->HDImg = HdStatus::HD_STATUS_ASSIGNED_IMG;
					}
				}
			}
		}
	}
}
?>