/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class FileSystemUtils {
    private static ArrayList<String> systemFolders;
    private static ArrayList<String> projectUniqeFiles;

    public static void writeToFile(String path, String content) throws IOException {
        FileWriter file = new FileWriter(path);
        file.write(content);
        file.flush();
        file.close();
    }

    public static boolean deleteFile(String path) throws IOException {
        return Files.deleteIfExists(new File(path).toPath());
    }

    public static String readFileContent(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cbuf = new char[1024];
        int length = 1024;
        while (fileReader.read(cbuf, 0, length - 1) != -1) {
            stringBuilder.append(cbuf);
        }
        fileReader.close();
        String result = FileSystemUtils.removeCtrlAllChar(stringBuilder.toString());
        return result;
    }

    private static String removeCtrlAllChar(String s) {
        return s.replaceAll("[\\x00-\\x09\\x11\\x12\\x14-\\x1F\\x7F]", "");
    }

    public static void createFile(String path, String content) throws Exception {
        File file = new File(path);
        file.createNewFile();
        FileSystemUtils.writeToFile(path, content);
    }

    public static IFile createFileInProject(IProject project, String path, String content) throws Exception {
        IFile file = project.getFile(path.toString());
        file.create((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), 1, null);
        return file;
    }

    public static ArrayList<String> getSystemFolders() {
        if (systemFolders == null) {
            systemFolders = new ArrayList();
            systemFolders.add("build");
            systemFolders.add("modules");
            systemFolders.add("out");
            systemFolders.add("PDTs");
            systemFolders.add("modules" + File.separator + "sensors");
            systemFolders.add("build" + File.separator + ManagerEnums.CompilationMode.Release.getFriendlyName());
            systemFolders.add("build" + File.separator + ManagerEnums.CompilationMode.Debug.getFriendlyName());
        }
        return systemFolders;
    }

    public static ArrayList<String> getProjectUniqeFiles() {
        if (projectUniqeFiles == null) {
            projectUniqeFiles = new ArrayList();
            projectUniqeFiles.add(".cproject");
            projectUniqeFiles.add(".project");
        }
        return projectUniqeFiles;
    }

    public static void createFolderUnderProjectFolder(IProject project, String folderName) throws ISSException {
        IFolder folder = project.getFolder(folderName);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                throw new ISSException("Could not create the " + folderName + " folder. " + ExceptionHandler.parseException((Exception)((Object)e)));
            }
        }
    }
}

