/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model;

import com.intel.sensing.fdk.common.BiMap;
import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.common.utils.ManagerXMLUtils;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.SensorTypeListDao;
import com.intel.sensing.fdk.model.dao.VendorListDao;
import com.intel.sensing.fdk.model.entity.SensorTypeListEntity;
import com.intel.sensing.fdk.model.entity.VendorListEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SensorsDefinitionsMapping {
    private static SensorsDefinitionsMapping instance = null;
    private static BiMap<Integer, String> fdkDefinedSensorTypes;
    private static BiMap<Integer, String> vendorsDefinitions;
    private static ArrayList<String> fieldIdsDefinitions;
    private static ArrayList<String> unitsDefinitions;
    private static HashMap<String, String> callbackDefinitions;
    private static BiMap<Integer, String> physicalMinTypes;

    public static SensorsDefinitionsMapping getInstance() {
        if (instance == null) {
            instance = new SensorsDefinitionsMapping();
            try {
                fdkDefinedSensorTypes = SensorsDefinitionsMapping.loadSensorTypes();
                physicalMinTypes = SensorsDefinitionsMapping.loadPhysicalMinTypesDefinitions();
                vendorsDefinitions = SensorsDefinitionsMapping.loadVendorsDefinitions();
                fieldIdsDefinitions = SensorsDefinitionsMapping.loadFieldIdsDefinitions();
                unitsDefinitions = SensorsDefinitionsMapping.loadUnitsDefinitions();
                callbackDefinitions = SensorsDefinitionsMapping.loadCallbacksDefinitions();
            }
            catch (Exception e) {
                ISSLogger.e((Exception)e);
                ExceptionHandler.HandleExceptionInSeparateThread((Exception)e);
            }
        }
        return instance;
    }

    public BiMap<Integer, String> getFDKDefinedSensorTypes() {
        return fdkDefinedSensorTypes;
    }

    public BiMap<Integer, String> getPhysicalMinTypes() {
        return physicalMinTypes;
    }

    public BiMap<Integer, String> getVendors() {
        return vendorsDefinitions;
    }

    public ArrayList<String> getFieldIdsDefinitions() {
        return fieldIdsDefinitions;
    }

    public ArrayList<String> getUnitsDefinitions() {
        return unitsDefinitions;
    }

    public HashMap<String, String> getCallbacksDefinitions() {
        return callbackDefinitions;
    }

    public void addSensorType(Integer typeId, String typeName) {
        this.getFDKDefinedSensorTypes().put((Object)typeId, (Object)typeName);
        this.getPhysicalMinTypes().put((Object)typeId, (Object)typeName);
    }

    public String getSensorTypeName(Integer typeId, ManagerEnums.ObjectTypes objectType) {
        String typeName = "";
        typeName = (String)this.getFDKDefinedSensorTypes().getForward((Object)typeId);
        if (typeName.equals("")) {
            typeName = "SensorType_" + Integer.toString(typeId);
        }
        return typeName;
    }

    public void addVendor(Integer vendorId, String vendorName) {
        this.getVendors().put((Object)vendorId, (Object)vendorName);
    }

    public void removeSensorType(Integer typeId, String typeName) {
        this.getFDKDefinedSensorTypes().remove((Object)typeId, (Object)typeName);
        this.getPhysicalMinTypes().remove((Object)typeId, (Object)typeName);
    }

    public void removeVendor(Integer vendorId, String vendorName) {
        this.getVendors().remove((Object)vendorId, (Object)vendorName);
    }

    public BiMap<Integer, String> getModelsByVendorAndType(String vendorName, String typeName, boolean onlyPhysical) throws Exception {
        if (vendorName != null && typeName != null && !vendorName.isEmpty() && !typeName.isEmpty()) {
            int typeId;
            int vendorId;
            try {
                vendorId = (Integer)this.getVendors().getBackward((Object)vendorName);
            }
            catch (Exception exception) {
                try {
                    vendorId = Integer.parseInt(vendorName);
                }
                catch (Exception exception2) {
                    throw new Exception("Unrecognized vendor.");
                }
            }
            try {
                typeId = onlyPhysical ? ((Integer)this.getFDKDefinedSensorTypes().getBackward((Object)typeName)).intValue() : ((Integer)this.getFDKDefinedSensorTypes().getBackward((Object)typeName)).intValue();
            }
            catch (Exception exception) {
                try {
                    typeId = Integer.parseInt(typeName);
                }
                catch (Exception exception3) {
                    throw new Exception("Unrecognized sensor type.");
                }
            }
            BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>> generalList = this.loadModelsDefinitions(onlyPhysical);
            BiMap currentVendorList = (BiMap)generalList.getForward((Object)vendorId);
            if (currentVendorList != null) {
                return (BiMap)currentVendorList.getForward((Object)typeId);
            }
        }
        return null;
    }

    private static BiMap<Integer, String> loadSensorTypes() throws Exception {
        BiMap ret = new BiMap();
        String file = ManagerFileUtils.getIntelSensorTypeFilePath();
        SensorsDefinitionsMapping.getSensorTypesFromJson(file, (BiMap<Integer, String>)ret);
        String userFile = ManagerFileUtils.getUserSensorTypeDefinitionsFilePath();
        SensorsDefinitionsMapping.getSensorTypesFromJson(userFile, (BiMap<Integer, String>)ret);
        return ret;
    }

    private static BiMap<Integer, String> loadPhysicalMinTypesDefinitions() throws Exception {
        BiMap ret = new BiMap();
        ret.put((Object)17, (Object)"BIOMETRIC_PRESENCE");
        ret.put((Object)49, (Object)"ENVIRONMENTAL_ATMOSPHERIC_PRESSURE");
        ret.put((Object)50, (Object)"ENVIRONMENTAL_HUMIDITY");
        ret.put((Object)51, (Object)"ENVIRONMENTAL_TEMPERATURE");
        ret.put((Object)527, (Object)"INTEL_MOTION_MAGNETOMETER_3D");
        ret.put((Object)65, (Object)"LIGHT_AMBIENTLIGHT");
        ret.put((Object)115, (Object)"MOTION_ACCELEROMETER_3D");
        ret.put((Object)118, (Object)"MOTION_GYROMETER_3D");
        ret.put((Object)228, (Object)"OTHER_HEALTH_MONITOR");
        String userFile = ManagerFileUtils.getUserSensorTypeDefinitionsFilePath();
        SensorsDefinitionsMapping.getSensorTypesFromJson(userFile, (BiMap<Integer, String>)ret);
        return ret;
    }

    private static BiMap<Integer, String> loadVendorsDefinitions() throws Exception {
        BiMap ret = new BiMap();
        String file = ManagerFileUtils.getSensorVendorListFilePath();
        SensorsDefinitionsMapping.getVendorTypesFromJson(file, (BiMap<Integer, String>)ret);
        String userFile = ManagerFileUtils.getUserSensorVendorListFilePath();
        SensorsDefinitionsMapping.getVendorTypesFromJson(userFile, (BiMap<Integer, String>)ret);
        return ret;
    }

    private static void getVendorTypesFromJson(String file, BiMap<Integer, String> map) throws Exception {
        if (new File(file).exists()) {
            VendorListDao VendorDao = DaoFactory.getDao(VendorListDao.class);
            VendorListEntity VendorList = VendorDao.getEntityByFilePath(file);
            int i = 0;
            while (i < VendorList.getSensorVendorList().size()) {
                int id = VendorList.getSensorVendorList().get(i).getVendorID();
                String name = VendorList.getSensorVendorList().get(i).getVendorName();
                map.put((Object)id, (Object)name);
                ++i;
            }
        }
    }

    private static void getSensorTypesFromJson(String file, BiMap<Integer, String> map) throws Exception {
        if (new File(file).exists()) {
            SensorTypeListDao SensorTypeDao = DaoFactory.getDao(SensorTypeListDao.class);
            SensorTypeListEntity SensorTypeList = SensorTypeDao.getEntityByFilePath(file);
            int i = 0;
            while (i < SensorTypeList.getSensorTypeList().size()) {
                int id = SensorTypeList.getSensorTypeList().get(i).getSensorTypeID();
                String name = SensorTypeList.getSensorTypeList().get(i).getSensorTypeName();
                map.put((Object)id, (Object)name);
                ++i;
            }
        }
    }

    private BiMap<Integer, BiMap<Integer, BiMap<Integer, String>>> loadModelsDefinitions(boolean onlyPhysical) throws Exception {
        BiMap ret = new BiMap();
        String file = ManagerFileUtils.getIntelSensorDefinitionsFilePath();
        NodeList vendorsList = ManagerXMLUtils.getXMLElements((String)file, (String)"Vendor");
        int i = 0;
        while (i < vendorsList.getLength()) {
            Element vendor = (Element)vendorsList.item(i);
            BiMap types = new BiMap();
            NodeList typesList = vendor.getElementsByTagName("SensorType");
            int j = 0;
            while (j < typesList.getLength()) {
                Element type = (Element)typesList.item(j);
                BiMap models = new BiMap();
                NodeList modelsList = type.getElementsByTagName("Model");
                int k = 0;
                while (k < modelsList.getLength()) {
                    Element model = (Element)modelsList.item(k);
                    if (!model.getAttribute("ModelName").isEmpty() && (onlyPhysical && Boolean.parseBoolean(model.getAttribute("isPhysical")) || !onlyPhysical)) {
                        int id = Integer.parseInt(model.getAttribute("ModelId"));
                        String name = model.getAttribute("ModelName");
                        models.put((Object)id, (Object)name);
                    }
                    ++k;
                }
                types.put((Object)Integer.parseInt(type.getAttribute("SensorTypeId")), (Object)models);
                ++j;
            }
            ret.put((Object)Integer.parseInt(vendor.getAttribute("VendorId")), (Object)types);
            ++i;
        }
        return ret;
    }

    private static ArrayList<String> loadFieldIdsDefinitions() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String file = ManagerFileUtils.getIntelSensorDefinitionsFilePath();
        NodeList fieldIdsList = ManagerXMLUtils.getXMLElements((String)file, (String)"Usage");
        int i = 0;
        while (i < fieldIdsList.getLength()) {
            ret.add(fieldIdsList.item(i).getTextContent());
            ++i;
        }
        return ret;
    }

    private static ArrayList<String> loadUnitsDefinitions() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String file = ManagerFileUtils.getIntelSensorDefinitionsFilePath();
        NodeList unitsList = ManagerXMLUtils.getXMLElements((String)file, (String)"Unit");
        int i = 0;
        while (i < unitsList.getLength()) {
            ret.add(unitsList.item(i).getTextContent());
            ++i;
        }
        return ret;
    }

    private static HashMap<String, String> loadCallbacksDefinitions() throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        String file = ManagerFileUtils.getIntelSensorDefinitionsFilePath();
        NodeList callbacksList = ManagerXMLUtils.getXMLElements((String)file, (String)"Callback");
        int i = 0;
        while (i < callbacksList.getLength()) {
            Element callback = (Element)callbacksList.item(i);
            ret.put(callback.getAttribute("Name"), callback.getAttribute("Prototype"));
            ++i;
        }
        return ret;
    }

    public List<Integer> getIntelImplementedFormats(String typeId, ManagerEnums.ObjectTypes objectType) throws Exception {
        if (objectType == ManagerEnums.ObjectTypes.PHYSICAL || objectType == ManagerEnums.ObjectTypes.VIRTUAL) {
            boolean isPhysical = objectType == ManagerEnums.ObjectTypes.PHYSICAL;
            ArrayList<Integer> ret = new ArrayList<Integer>();
            String file = ManagerFileUtils.getIntelSensorDefinitionsFilePath();
            NodeList types = ManagerXMLUtils.getXMLElements((String)file, (String)"CalibrationFormats", (String)"CalibrationSensorType");
            int i = 0;
            while (i < types.getLength()) {
                String id = types.item(i).getAttributes().getNamedItem("SensorTypeId").getNodeValue();
                Node physicNode = types.item(i).getAttributes().getNamedItem("physical");
                if (id.equals(typeId) && (physicNode == null || physicNode.getNodeValue().equals(isPhysical ? "1" : "0"))) {
                    NodeList formatIds = ((Element)types.item(i)).getElementsByTagName("FormatId");
                    int j = 0;
                    while (j < formatIds.getLength()) {
                        ret.add(Integer.parseInt(formatIds.item(j).getTextContent()));
                        ++j;
                    }
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    public ArrayList<String> getSensorTypeList(ManagerEnums.ObjectTypes objectType) {
        if (objectType == ManagerEnums.ObjectTypes.PHYSICAL) {
            return this.getFDKDefinedSensorTypes().getValueList();
        }
        if (objectType == ManagerEnums.ObjectTypes.VIRTUAL) {
            return this.getFDKDefinedSensorTypes().getValueList();
        }
        return new ArrayList<String>();
    }
}

