/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.project;

import com.boothen.jsonedit.model.AntlrAdapter;
import com.boothen.jsonedit.model.ParseProblem;
import com.boothen.jsonedit.model.ParseResult;
import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.exceptions.ISSError;
import com.intel.sensing.fdk.common.utils.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class JsonFileCheker {
    public List<ISSError> check(IFile file, int errorReason) {
        try {
            return JsonFileCheker.tryParse(file);
        }
        catch (IOException e) {
            ArrayList<ISSError> ret = new ArrayList<ISSError>();
            ISSError err = new ISSError(ISSError.Severity.ERROR, 0, ExceptionHandler.parseException((Exception)e), (IResource)file);
            ret.add(err);
            return ret;
        }
    }

    public static List<ISSError> tryParse(IFile file) throws IOException {
        String filePath = file.getLocation().toOSString();
        String jContent = FileSystemUtils.readFileContent((File)new File(filePath));
        StringReader reader = new StringReader(jContent);
        ParseResult result = AntlrAdapter.convert((Reader)reader);
        ArrayList problems = new ArrayList();
        problems.addAll(result.getLexerErrors());
        problems.addAll(result.getParserErrors());
        List<ISSError> ret = problems.stream().map(prob -> {
            ISSError.Severity sv = ISSError.Severity.FATAL;
            switch (prob.getSeverity()) {
                case ERROR: {
                    sv = ISSError.Severity.FATAL;
                }
                case WARNING: {
                    sv = ISSError.Severity.WARNING;
                }
                case INFO: {
                    sv = ISSError.Severity.INFO;
                }
            }
            if (prob.getSeverity() == ParseProblem.Severity.ERROR) {
                sv = ISSError.Severity.FATAL;
            }
            String msg = String.valueOf(prob.getMessage()) + ". line " + prob.getLine() + ", index " + prob.getStartPositionInLine() + ".";
            ISSError err = new ISSError(sv, 1, msg, (IResource)file);
            err.setLine(prob.getLine());
            err.setIndex(prob.getStartPositionInLine());
            return err;
        }).collect(Collectors.toList());
        return ret;
    }
}

